/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.logex;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.glassfish.gmbal.logex.Chain;
import org.glassfish.gmbal.logex.ExceptionWrapper;
import org.glassfish.gmbal.logex.Log;
import org.glassfish.gmbal.logex.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapperGenerator {
    private static final Formatter formatter = new ShortFormatter();

    private WrapperGenerator() {
    }

    private static int findAnnotatedParameter(Annotation[][] pannos, Class<? extends Annotation> cls) {
        for (int ctr1 = 0; ctr1 < pannos.length; ++ctr1) {
            Annotation[] annos = pannos[ctr1];
            for (int ctr2 = 0; ctr2 < annos.length; ++ctr2) {
                Annotation anno = annos[ctr2];
                if (!cls.isInstance(anno)) continue;
                return ctr1;
            }
        }
        return -1;
    }

    private static Object[] getWithSkip(Object[] args, int skip) {
        if (skip >= 0) {
            Object[] result = new Object[args.length - 1];
            int rindex = 0;
            for (int ctr = 0; ctr < args.length; ++ctr) {
                if (ctr == skip) continue;
                result[rindex++] = args[ctr];
            }
            return result;
        }
        return args;
    }

    private static String getMessage(Method method, int numParams, String idPrefix, int logId) {
        Message message = method.getAnnotation(Message.class);
        StringBuilder sb = new StringBuilder();
        sb.append(idPrefix);
        sb.append(logId);
        sb.append(": ");
        if (message == null) {
            sb.append(method.getName());
            sb.append(' ');
            for (int ctr = 0; ctr < numParams; ++ctr) {
                if (ctr > 0) {
                    sb.append(", ");
                }
                sb.append("arg");
                sb.append(ctr);
                sb.append("={" + ctr + "}");
            }
        } else {
            sb.append(message.value());
        }
        return sb.toString();
    }

    private static void inferCaller(LogRecord lrec) {
        String cname;
        int ix;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        StackTraceElement frame = null;
        String wcname = "$Proxy";
        String baseName = WrapperGenerator.class.getName();
        String nestedName = WrapperGenerator.class.getName() + "$1";
        for (ix = 0; ix < stack.length && ((cname = (frame = stack[ix]).getClassName()).contains(wcname) || cname.equals(baseName) || cname.equals(nestedName)); ++ix) {
        }
        if (ix < stack.length) {
            lrec.setSourceClassName(frame.getClassName());
            lrec.setSourceMethodName(frame.getMethodName());
        }
    }

    private static LogRecord makeLogRecord(Level level, String key, Object[] args, Throwable cause, Logger logger) {
        LogRecord result = new LogRecord(level, key);
        if (args != null && args.length > 0) {
            result.setParameters(args);
        }
        if (level != Level.INFO) {
            if (cause != null) {
                result.setThrown(cause);
            }
            WrapperGenerator.inferCaller(result);
        }
        result.setLoggerName(logger.getName());
        result.setResourceBundle(logger.getResourceBundle());
        return result;
    }

    private static Exception makeException(Class<?> rtype, String msg) {
        try {
            Constructor<?> cons = rtype.getConstructor(String.class);
            return (Exception)cons.newInstance(msg);
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    private static String handleMessageOnly(Method method, Logger logger, Object[] messageParams) {
        String transMsg;
        String msg = method.getAnnotation(Message.class).value();
        ResourceBundle catalog = logger.getResourceBundle();
        try {
            transMsg = catalog.getString(msg);
        }
        catch (Exception exc) {
            transMsg = msg;
        }
        if (transMsg.indexOf("{0") >= 0) {
            return MessageFormat.format(transMsg, messageParams);
        }
        return transMsg;
    }

    private static Object handleFullLogging(Log log, Method method, Logger logger, String idPrefix, Object[] messageParams, Throwable cause) {
        int logId = log.id();
        Level level = log.level().getLevel();
        Class<?> rtype = method.getReturnType();
        int numParams = messageParams == null ? 0 : messageParams.length;
        String msgString = WrapperGenerator.getMessage(method, numParams, idPrefix, logId);
        LogRecord lrec = WrapperGenerator.makeLogRecord(level, msgString, messageParams, cause, logger);
        if (logger.isLoggable(level)) {
            logger.log(lrec);
        }
        if (rtype.equals(Void.TYPE)) {
            return null;
        }
        String fullMessage = formatter.format(lrec);
        if (Exception.class.isAssignableFrom(rtype)) {
            Exception exc = WrapperGenerator.makeException(rtype, fullMessage);
            exc.initCause(cause);
            return exc;
        }
        if (String.class.isAssignableFrom(rtype)) {
            return fullMessage;
        }
        throw new RuntimeException("Method " + method + " has an illegal return type");
    }

    public static <T> T makeWrapper(final Class<T> cls) {
        if (!cls.isInterface()) {
            throw new IllegalArgumentException("Class " + cls + "is not an interface");
        }
        ExceptionWrapper ew = cls.getAnnotation(ExceptionWrapper.class);
        final String idPrefix = ew.idPrefix();
        String str = ew.loggerName();
        if (str.length() == 0) {
            str = cls.getPackage().getName();
        }
        final String name = str;
        InvocationHandler inh = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Annotation[][] pannos = method.getParameterAnnotations();
                int chainIndex = WrapperGenerator.findAnnotatedParameter(pannos, Chain.class);
                Throwable cause = null;
                Object[] messageParams = WrapperGenerator.getWithSkip(args, chainIndex);
                if (chainIndex >= 0) {
                    cause = (Throwable)args[chainIndex];
                }
                Logger logger = Logger.getLogger(name);
                Class<?> rtype = method.getReturnType();
                Log log = method.getAnnotation(Log.class);
                if (log == null) {
                    if (!rtype.equals(String.class)) {
                        throw new IllegalArgumentException("No @Log annotation present on " + cls.getName() + "." + method.getName());
                    }
                    return WrapperGenerator.handleMessageOnly(method, logger, messageParams);
                }
                return WrapperGenerator.handleFullLogging(log, method, logger, idPrefix, messageParams, cause);
            }
        };
        ClassLoader loader = cls.getClassLoader();
        Class[] classes = new Class[]{cls};
        return (T)Proxy.newProxyInstance(loader, classes, inh);
    }

    private static class ShortFormatter
    extends Formatter {
        private ShortFormatter() {
        }

        public String format(LogRecord record) {
            StringBuilder sb = new StringBuilder();
            sb.append(record.getLevel().getLocalizedName());
            sb.append(": ");
            String message = this.formatMessage(record);
            sb.append(message);
            return sb.toString();
        }
    }
}

