/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.tools.file;

import org.glassfish.gmbal.tools.file.FileWrapper;
import org.glassfish.gmbal.tools.file.Recognizer;
import org.glassfish.gmbal.tools.file.Scanner;

public class ActionFactory {
    private final int verbose;
    private final boolean dryRun;

    public ActionFactory() {
        this(0, false);
    }

    public ActionFactory(int verbose) {
        this(verbose, false);
    }

    public ActionFactory(int verbose, boolean dryRun) {
        this.verbose = verbose;
        this.dryRun = dryRun;
    }

    public Scanner.Action getSkipAction() {
        return new Scanner.Action(){

            public String toString() {
                return "SkipAction";
            }

            public boolean evaluate(FileWrapper fw) {
                if (ActionFactory.this.verbose > 0) {
                    System.out.println("SkipAction called on " + fw);
                }
                return true;
            }
        };
    }

    public Scanner.Action getStopAction() {
        return new Scanner.Action(){

            public String toString() {
                return "StopAction";
            }

            public boolean evaluate(FileWrapper fw) {
                if (ActionFactory.this.verbose > 0) {
                    System.out.println("StopAction called on " + fw);
                }
                return false;
            }
        };
    }

    public Recognizer getRecognizerAction() {
        return new Recognizer(this.verbose, this.dryRun);
    }
}

