/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.client;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.client.AMXBooter;
import com.sun.appserv.management.client.ConnectionSource;
import com.sun.appserv.management.client.handler.ConverterHandlerFactory;
import com.sun.appserv.management.client.handler.ConverterHandlerUtil;
import com.sun.appserv.management.client.handler.ProxyCache;
import com.sun.appserv.management.helper.AMXDebugHelper;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.jmx.MBeanProxyHandler;
import com.sun.appserv.management.util.jmx.MBeanServerConnectionConnectionSource;
import com.sun.appserv.management.util.jmx.MBeanServerConnectionSource;
import com.sun.appserv.management.util.misc.ClassUtil;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.relation.MBeanServerNotificationFilter;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProxyFactory
implements NotificationListener {
    private final ProxyCache mProxyCache;
    private final ConnectionSource mConnectionSource;
    private final ObjectName mDomainRootObjectName;
    private final DomainRoot mDomainRoot;
    private final String mMBeanServerID;
    private static final AMXDebugHelper mDebug = new AMXDebugHelper("com.sun.appserv.management.client.ProxyFactory");
    private static final Map<MBeanServerConnection, ProxyFactory> INSTANCES = Collections.synchronizedMap(new HashMap());
    private static final String DOMAIN_ROOT_KEY = "DomainRoot";

    private static void debug(Object ... args) {
        mDebug.println(args);
    }

    private static void warning(Object ... args) {
        ProxyFactory.debug(args);
    }

    private ProxyFactory(ConnectionSource connSource) {
        mDebug.setEchoToStdOut(true);
        assert (connSource != null);
        this.mConnectionSource = connSource;
        this.mProxyCache = new ProxyCache();
        try {
            MBeanServerConnection conn = this.getConnection();
            this.mMBeanServerID = JMXUtil.getMBeanServerID(conn);
            this.mDomainRootObjectName = AMXBooter.findDomainRoot(conn);
            if (this.mDomainRootObjectName == null) {
                throw new IllegalStateException("ProxyFactory: AMX has not been started");
            }
            this.mDomainRoot = this.getProxy(this.mDomainRootObjectName, DomainRoot.class, true);
            try {
                MBeanServerNotificationFilter filter = new MBeanServerNotificationFilter();
                filter.enableAllObjectNames();
                filter.disableAllTypes();
                filter.enableType("JMX.mbean.unregistered");
                JMXUtil.listenToMBeanServerDelegate(conn, this, filter, null);
            }
            catch (Exception e) {
                ProxyFactory.warning("ProxyFactory: connection does not support notifications: ", this.mMBeanServerID, connSource);
            }
            JMXConnector connector = connSource.getJMXConnector(false);
            if (connector != null) {
                try {
                    connector.addConnectionNotificationListener(this, null, null);
                }
                catch (Exception e) {
                    ProxyFactory.warning("addConnectionNotificationListener failed: ", this.mMBeanServerID, connSource, e);
                }
            }
        }
        catch (Exception e) {
            ProxyFactory.warning("ProxyFactory.ProxyFactory:\n", e);
            throw new RuntimeException(e);
        }
    }

    private void connectionBad() {
        HashSet proxies = new HashSet();
        proxies.addAll(this.mProxyCache.values());
        this.mProxyCache.clear();
        for (AMX proxy : proxies) {
            ConverterHandlerUtil.connectionBad(proxy);
        }
    }

    public boolean checkConnection() {
        boolean connectionGood = true;
        try {
            this.getConnection().isRegistered(JMXUtil.getMBeanServerDelegateObjectName());
            connectionGood = true;
        }
        catch (Exception e) {
            this.connectionBad();
        }
        return connectionGood;
    }

    void notifsLost() {
    }

    @Override
    public void handleNotification(Notification notifIn, Object handback) {
        String type = notifIn.getType();
        if (type.equals("JMX.mbean.unregistered")) {
            MBeanServerNotification notif = (MBeanServerNotification)notifIn;
            ObjectName objectName = notif.getMBeanName();
            AMX proxy = this.getProxy(objectName, AMX.class, false);
            this.mProxyCache.remove(objectName);
            ConverterHandlerUtil.targetUnregistered(proxy);
        } else if (notifIn instanceof JMXConnectionNotification) {
            if (type.equals("jmx.remote.connection.closed") || type.equals("jmx.remote.connection.failed")) {
                ProxyFactory.debug("ProxyFactory.handleNotification: connection closed or failed: ", notifIn);
                this.connectionBad();
            } else if (type.equals("jmx.remote.connection.notifs.lost")) {
                ProxyFactory.debug("ProxyFactory.handleNotification: notifications lost: ", notifIn);
                this.notifsLost();
            }
        } else {
            ProxyFactory.debug("ProxyFactory.handleNotification: UNKNOWN notification: ", notifIn);
        }
    }

    public DomainRoot createDomainRoot() throws IOException {
        return this.mDomainRoot;
    }

    public DomainRoot initDomainRoot() throws IOException {
        ObjectName domainRootObjectName = this.getDomainRootObjectName();
        DomainRoot domainRoot = (DomainRoot)this.newProxyInstance(domainRootObjectName, new Class[]{DomainRoot.class});
        return domainRoot;
    }

    public DomainRoot getDomainRoot() {
        return this.getDomainRoot(false);
    }

    public DomainRoot getDomainRoot(boolean waitReady) {
        if (waitReady) {
            this.mDomainRoot.waitAMXReady();
        }
        return this.mDomainRoot;
    }

    public ConnectionSource getConnectionSource() {
        return this.mConnectionSource;
    }

    public String getMBeanServerID() {
        return this.mMBeanServerID;
    }

    public ObjectName getDomainRootObjectName() throws IOException {
        return this.mDomainRootObjectName;
    }

    public static ProxyFactory getInstance(MBeanServer server) {
        return ProxyFactory.getInstance(new MBeanServerConnectionSource(server), true);
    }

    public static ProxyFactory getInstance(MBeanServerConnection conn) {
        return ProxyFactory.getInstance(new MBeanServerConnectionConnectionSource(conn), true);
    }

    public static ProxyFactory getInstance(ConnectionSource conn) {
        return ProxyFactory.getInstance(conn, true);
    }

    public static synchronized ProxyFactory getInstance(ConnectionSource connSource, boolean useMBeanServerID) {
        ProxyFactory instance = ProxyFactory.findInstance(connSource);
        if (instance == null) {
            try {
                MBeanServerConnection conn = connSource.getMBeanServerConnection(false);
                instance = ProxyFactory.findInstance(conn);
                if (instance == null && (useMBeanServerID || connSource instanceof MBeanServerConnectionSource)) {
                    String id = JMXUtil.getMBeanServerID(conn);
                    instance = ProxyFactory.findInstanceByID(id);
                }
                if (instance == null) {
                    ProxyFactory.debug("Creating new ProxyFactory for ConnectionSource / conn", connSource, conn);
                    instance = new ProxyFactory(connSource);
                    INSTANCES.put(conn, instance);
                }
            }
            catch (Exception e) {
                ProxyFactory.warning("ProxyFactory.getInstance: failure creating ProxyFactory: ", e);
                throw new RuntimeException(e);
            }
        }
        return instance;
    }

    public static synchronized ProxyFactory findInstance(ConnectionSource conn) {
        return INSTANCES.get(conn);
    }

    public static synchronized ProxyFactory findInstance(MBeanServerConnection conn) {
        ProxyFactory instance = null;
        Collection<ProxyFactory> values = INSTANCES.values();
        for (ProxyFactory factory : values) {
            if (factory.getConnectionSource().getExistingMBeanServerConnection() != conn) continue;
            instance = factory;
            break;
        }
        return instance;
    }

    public static synchronized ProxyFactory findInstanceByID(String mbeanServerID) {
        ProxyFactory instance = null;
        Collection<ProxyFactory> values = INSTANCES.values();
        for (ProxyFactory factory : values) {
            if (!factory.getMBeanServerID().equals(mbeanServerID)) continue;
            instance = factory;
            break;
        }
        return instance;
    }

    public AMX getProxy(ObjectName objectName) {
        return this.getProxy(objectName, true);
    }

    public AMX getProxy(ObjectName objectName, boolean create) {
        return this.getProxy(objectName, AMX.class, create);
    }

    public synchronized <T extends AMX> T getProxy(ObjectName objectName, Class<T> theInterface) {
        return this.getProxy(objectName, theInterface, true);
    }

    public synchronized <T extends AMX> T getProxy(ObjectName objectName, Class<T> theClass, boolean create) {
        AMX proxy = this.mProxyCache.getCachedProxy(objectName);
        if (proxy == null && create) {
            proxy = this.createProxy(objectName);
        }
        return (T)((AMX)theClass.cast(proxy));
    }

    protected MBeanServerConnection getConnection() throws IOException {
        return this.getConnectionSource().getMBeanServerConnection(false);
    }

    private AMX createProxy(ObjectName objectName) {
        AMX proxy = null;
        try {
            String proxyInterfaceName = null;
            Class<?> proxyInterface = null;
            proxyInterfaceName = (String)this.getConnection().getAttribute(objectName, "InterfaceName");
            proxyInterface = ClassUtil.getClassFromName(proxyInterfaceName);
            proxy = this.newProxyInstance(objectName, new Class[]{proxyInterface});
        }
        catch (IllegalArgumentException e) {
            ProxyFactory.debug("createProxy", e);
            throw e;
        }
        catch (Exception e) {
            ProxyFactory.debug("createProxy", e);
            throw new RuntimeException(e);
        }
        return proxy;
    }

    private MBeanProxyHandler createProxyHandler(ObjectName objectName) throws IOException {
        return ConverterHandlerFactory.createHandler(this.mConnectionSource, objectName);
    }

    public AMX newProxyInstance(ObjectName objectName, Class<?>[] interfaceClasses) throws IOException {
        MBeanProxyHandler handler = this.createProxyHandler(objectName);
        ClassLoader classLoader = interfaceClasses[0].getClassLoader();
        AMX proxy = Util.asAMX(Proxy.newProxyInstance(classLoader, interfaceClasses, (InvocationHandler)handler));
        if (proxy != null) {
            this.mProxyCache.remove(objectName);
            this.mProxyCache.cacheProxy(proxy);
        }
        return proxy;
    }

    protected static String toString(Object o) {
        return SmartStringifier.toString(o);
    }

    public Set<AMX> toProxySet(Set<ObjectName> objectNames) {
        HashSet<AMX> s = new HashSet<AMX>();
        for (ObjectName objectName : objectNames) {
            try {
                AMX proxy = this.getProxy(objectName, AMX.class, true);
                assert (!s.contains(proxy));
                s.add(proxy);
            }
            catch (Exception e) {
                ProxyFactory.debug("ProxyFactory.toProxySet: exception for MBean ", objectName, " = ", ExceptionUtil.getRootCause(e));
            }
        }
        return s;
    }

    public List<AMX> toProxyList(Collection<ObjectName> objectNames) {
        ArrayList<AMX> list = new ArrayList<AMX>();
        for (ObjectName objectName : objectNames) {
            try {
                AMX proxy = this.getProxy(objectName, AMX.class, true);
                list.add(proxy);
            }
            catch (Exception e) {
                ProxyFactory.debug("ProxyFactory.toProxySet: exception for MBean ", objectName, " = ", ExceptionUtil.getRootCause(e));
            }
        }
        return list;
    }

    public Map<String, AMX> toProxyMap(Map<String, ObjectName> objectNameMap) {
        HashMap<String, AMX> resultMap = new HashMap<String, AMX>();
        Set<String> keys = objectNameMap.keySet();
        for (String key : keys) {
            ObjectName objectName = objectNameMap.get(key);
            try {
                AMX proxy = this.getProxy(objectName, AMX.class, true);
                resultMap.put(key, proxy);
            }
            catch (Exception e) {
                ProxyFactory.debug("ProxyFactory.toProxySet: exception for MBean ", objectName, " = ", ExceptionUtil.getRootCause(e));
            }
        }
        return resultMap;
    }
}

