/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.generic;

import com.sun.corba.ee.spi.orbutil.generic.BinaryFunction;
import com.sun.corba.ee.spi.orbutil.generic.UnaryBooleanFunction;
import com.sun.corba.ee.spi.orbutil.generic.UnaryFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Algorithms {
    public static <A, R> UnaryFunction<A, R> mapToFunction(final Map<A, R> map) {
        return new UnaryFunction<A, R>(){

            @Override
            public R evaluate(A arg) {
                return map.get(arg);
            }
        };
    }

    public static <A, R> void map(List<A> arg, List<R> result, UnaryFunction<A, R> func) {
        for (A a : arg) {
            R newArg = func.evaluate(a);
            if (newArg == null) continue;
            result.add(newArg);
        }
    }

    public static <A, R> List<R> map(List<A> arg, UnaryFunction<A, R> func) {
        ArrayList result = new ArrayList();
        Algorithms.map(arg, result, func);
        return result;
    }

    public static <A> void filter(List<A> arg, List<A> result, final UnaryBooleanFunction<A> predicate) {
        UnaryFunction filter = new UnaryFunction<A, A>(){

            @Override
            public A evaluate(A arg) {
                return predicate.evaluate(arg) ? arg : null;
            }
        };
        Algorithms.map(arg, result, filter);
    }

    public static <A> List<A> filter(List<A> arg, UnaryBooleanFunction<A> predicate) {
        ArrayList result = new ArrayList();
        Algorithms.filter(arg, result, predicate);
        return result;
    }

    public static <A> A find(List<A> arg, UnaryBooleanFunction<A> predicate) {
        for (A a : arg) {
            if (!predicate.evaluate(a)) continue;
            return a;
        }
        return null;
    }

    public static <A, R> R fold(List<A> list, R initial, BinaryFunction<R, A, R> func) {
        R result = initial;
        for (A elem : list) {
            result = func.evaluate(result, elem);
        }
        return result;
    }
}

