/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.AbstractConnectorHandler;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.SSLCallbackHandler;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCallbackHandler
implements SSLCallbackHandler<Context> {
    private ConnectorHandler connectorHandler;
    private boolean delegateToProtocolChain = true;

    public DefaultCallbackHandler(ConnectorHandler connectorHandler) {
        this(connectorHandler, true);
    }

    public DefaultCallbackHandler(ConnectorHandler connectorHandler, boolean delegateToProtocolChain) {
        this.connectorHandler = connectorHandler;
        this.delegateToProtocolChain = delegateToProtocolChain;
    }

    @Override
    public void onConnect(IOEvent<Context> ioEvent) {
        SelectionKey key = ioEvent.attachment().getSelectionKey();
        if (this.connectorHandler instanceof AbstractConnectorHandler) {
            ((AbstractConnectorHandler)this.connectorHandler).setUnderlyingChannel(key.channel());
        }
        try {
            this.connectorHandler.finishConnect(key);
            ioEvent.attachment().getSelectorHandler().register(key, 1);
        }
        catch (IOException ex) {
            Controller.logger().severe(ex.getMessage());
        }
    }

    @Override
    public void onRead(IOEvent<Context> ioEvent) {
        if (!this.delegateToProtocolChain) {
            return;
        }
        Context context = ioEvent.attachment();
        try {
            context.getProtocolChain().execute(context);
        }
        catch (Exception ex) {
            Controller.logger().log(Level.SEVERE, "Read/Write operation failed.", ex);
        }
    }

    @Override
    public void onWrite(IOEvent<Context> ioEvent) {
        this.onRead(ioEvent);
    }

    @Override
    public void onHandshake(IOEvent<Context> ioEvent) {
    }

    public boolean isDelegateToProtocolChain() {
        return this.delegateToProtocolChain;
    }

    public void setDelegateToProtocolChain(boolean delegateToProtocolChain) {
        this.delegateToProtocolChain = delegateToProtocolChain;
    }
}

