/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api;

import com.sun.xml.bind.util.Which;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedData
public enum SOAPVersion {
    SOAP_11("http://schemas.xmlsoap.org/wsdl/soap/http", "http://schemas.xmlsoap.org/soap/envelope/", "text/xml", "http://schemas.xmlsoap.org/soap/actor/next", "actor", "SOAP 1.1 Protocol", new QName("http://schemas.xmlsoap.org/soap/envelope/", "MustUnderstand"), "Client", "Server", Collections.singleton("http://schemas.xmlsoap.org/soap/actor/next")),
    SOAP_12("http://www.w3.org/2003/05/soap/bindings/HTTP/", "http://www.w3.org/2003/05/soap-envelope", "application/soap+xml", "http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver", "role", "SOAP 1.2 Protocol", new QName("http://www.w3.org/2003/05/soap-envelope", "MustUnderstand"), "Sender", "Receiver", new HashSet<String>(Arrays.asList("http://www.w3.org/2003/05/soap-envelope/role/next", "http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver")));

    @ManagedAttribute
    public final String httpBindingId;
    public final String nsUri;
    public final String contentType;
    public final QName faultCodeMustUnderstand;
    public final MessageFactory saajMessageFactory;
    public final SOAPFactory saajSoapFactory;
    public final String implicitRole;
    public final Set<String> implicitRoleSet;
    public final Set<String> requiredRoles;
    public final String roleAttributeName;
    public final QName faultCodeClient;
    public final QName faultCodeServer;

    private SOAPVersion(String httpBindingId, String nsUri, String contentType, String implicitRole, String roleAttributeName, String saajFactoryString, QName faultCodeMustUnderstand, String faultCodeClientLocalName, String faultCodeServerLocalName, Set<String> requiredRoles) {
        this.httpBindingId = httpBindingId;
        this.nsUri = nsUri;
        this.contentType = contentType;
        this.implicitRole = implicitRole;
        this.implicitRoleSet = Collections.singleton(implicitRole);
        this.roleAttributeName = roleAttributeName;
        try {
            this.saajMessageFactory = MessageFactory.newInstance((String)saajFactoryString);
            this.saajSoapFactory = SOAPFactory.newInstance((String)saajFactoryString);
        }
        catch (SOAPException e) {
            throw new Error(e);
        }
        catch (NoSuchMethodError e) {
            LinkageError x = new LinkageError("You are loading old SAAJ from " + Which.which(MessageFactory.class));
            x.initCause(e);
            throw x;
        }
        this.faultCodeMustUnderstand = faultCodeMustUnderstand;
        this.requiredRoles = requiredRoles;
        this.faultCodeClient = new QName(nsUri, faultCodeClientLocalName);
        this.faultCodeServer = new QName(nsUri, faultCodeServerLocalName);
    }

    public String toString() {
        return this.httpBindingId;
    }

    public static SOAPVersion fromHttpBinding(String binding) {
        if (binding == null) {
            return SOAP_11;
        }
        if (binding.equals(SOAPVersion.SOAP_12.httpBindingId)) {
            return SOAP_12;
        }
        return SOAP_11;
    }

    public static SOAPVersion fromNsUri(String nsUri) {
        if (nsUri.equals(SOAPVersion.SOAP_12.nsUri)) {
            return SOAP_12;
        }
        return SOAP_11;
    }
}

