/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.NotNull;
import com.sun.xml.ws.rx.rm.protocol.AcknowledgementData;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ApplicationMessageBase
implements ApplicationMessage {
    @NotNull
    private final String correlationId;
    private String sequenceId;
    private long messageNumber;
    private AcknowledgementData acknowledgementData;
    private AtomicInteger resendCount = new AtomicInteger();

    protected ApplicationMessageBase(@NotNull String correlationId) {
        if (correlationId == null) {
            throw new NullPointerException("correlationId initialization parameter must not be 'null'");
        }
        this.correlationId = correlationId;
    }

    protected ApplicationMessageBase(@NotNull String correlationId, String sequenceId, long messageNumber, AcknowledgementData acknowledgementData) {
        this(correlationId);
        this.sequenceId = sequenceId;
        this.messageNumber = messageNumber;
        this.acknowledgementData = acknowledgementData;
    }

    public AcknowledgementData getAcknowledgementData() {
        return this.acknowledgementData;
    }

    @NotNull
    public String getCorrelationId() {
        return this.correlationId;
    }

    public long getMessageNumber() {
        return this.messageNumber;
    }

    public String getSequenceId() {
        return this.sequenceId;
    }

    public void setAcknowledgementData(AcknowledgementData data) {
        this.acknowledgementData = data;
    }

    public void setSequenceData(String sequenceId, long messageNumber) {
        assert (sequenceId != null);
        this.sequenceId = sequenceId;
        this.messageNumber = messageNumber;
    }

    public int getNextResendCount() {
        return this.resendCount.incrementAndGet();
    }
}

