/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.commons.Logger;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.rm.protocol.AcknowledgementData;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.RedeliveryTask;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateMessageRegistrationException;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.UnknownSequenceException;
import java.util.List;

class DestinationMessageHandler
implements RedeliveryTask.DeliveryHandler {
    private static final Logger LOGGER = Logger.getLogger(DestinationMessageHandler.class);
    private final SequenceManager sequenceManager;

    DestinationMessageHandler(@NotNull SequenceManager sequenceManager) {
        assert (sequenceManager != null);
        this.sequenceManager = sequenceManager;
    }

    public void registerMessage(@NotNull ApplicationMessage inMessage) throws DuplicateMessageRegistrationException, UnknownSequenceException {
        assert (inMessage != null);
        Sequence inboundSequence = this.sequenceManager.getSequence(inMessage.getSequenceId());
        inboundSequence.registerMessage(inMessage, true);
        inboundSequence.setAckRequestedFlag();
    }

    public void processAcknowledgements(@Nullable AcknowledgementData acknowledgementData) throws UnknownSequenceException {
        List<Sequence.AckRange> acknowledgedRanges;
        if (acknowledgementData == null) {
            return;
        }
        if (acknowledgementData.getAcknowledgedSequenceId() != null && !(acknowledgedRanges = acknowledgementData.getAcknowledgedRanges()).isEmpty()) {
            this.sequenceManager.getSequence(acknowledgementData.getAcknowledgedSequenceId()).acknowledgeMessageIds(acknowledgedRanges);
        }
        if (acknowledgementData.getAckReqestedSequenceId() != null) {
            Sequence inboundSequence = this.sequenceManager.getSequence(acknowledgementData.getAckReqestedSequenceId());
            inboundSequence.setAckRequestedFlag();
        }
    }

    public AcknowledgementData getAcknowledgementData(String inboundSequenceId) throws UnknownSequenceException {
        Sequence outboundSequence;
        AcknowledgementData.Builder ackDataBuilder = AcknowledgementData.getBuilder();
        Sequence inboundSequence = this.sequenceManager.getSequence(inboundSequenceId);
        if (inboundSequence.isAckRequested()) {
            ackDataBuilder.acknowledgements(inboundSequence.getId(), inboundSequence.getAcknowledgedMessageIds());
            inboundSequence.clearAckRequestedFlag();
        }
        if ((outboundSequence = this.sequenceManager.getBoundSequence(inboundSequenceId)) != null && outboundSequence.hasUnacknowledgedMessages()) {
            ackDataBuilder.ackReqestedSequenceId(outboundSequence.getId());
            outboundSequence.updateLastAcknowledgementRequestTime();
        }
        AcknowledgementData acknowledgementData = ackDataBuilder.build();
        return acknowledgementData;
    }

    public void acknowledgeApplicationLayerDelivery(ApplicationMessage inMessage) throws UnknownSequenceException {
        this.sequenceManager.getSequence(inMessage.getSequenceId()).acknowledgeMessageId(inMessage.getMessageNumber());
    }

    public void putToDeliveryQueue(ApplicationMessage message) throws RxRuntimeException, UnknownSequenceException {
        this.sequenceManager.getSequence(message.getSequenceId()).getDeliveryQueue().put(message);
    }
}

