/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.io;

import com.sun.corba.ee.impl.io.ObjectStreamClass;
import com.sun.corba.ee.impl.io.ObjectStreamClassCorbaExt;
import com.sun.corba.ee.impl.io.ObjectStreamField;
import com.sun.corba.ee.impl.io.OutputStreamHook;
import com.sun.corba.ee.impl.javax.rmi.CORBA.Util;
import com.sun.corba.ee.impl.logging.UtilSystemException;
import com.sun.corba.ee.impl.orbutil.ClassInfoCache;
import com.sun.corba.ee.impl.util.RepositoryId;
import com.sun.corba.ee.impl.util.Utility;
import com.sun.corba.ee.spi.btrace.TraceValueHandler;
import com.sun.corba.ee.spi.btrace.Traceable;
import com.sun.corba.ee.spi.btrace.ValueHandlerWrite;
import com.sun.corba.ee.spi.orb.ORB;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Stack;
import org.omg.CORBA.portable.ValueOutputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import sun.corba.Bridge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Traceable
public class IIOPOutputStream
extends OutputStreamHook {
    private UtilSystemException wrapper = ORB.getStaticLogWrapperTable().get_RPC_ENCODING_Util();
    private static Bridge bridge = AccessController.doPrivileged(new PrivilegedAction<Bridge>(){

        @Override
        public Bridge run() {
            return Bridge.get();
        }
    });
    private OutputStream orbStream;
    private Object currentObject = null;
    private ObjectStreamClass currentClassDesc = null;
    private int recursionDepth = 0;
    private int simpleWriteDepth = 0;
    private IOException abortIOException = null;
    private Stack<ObjectStreamClass> classDescStack = new Stack();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TraceValueHandler
    @ValueHandlerWrite
    protected void beginOptionalCustomData() {
        if (this.valueHandlerDebug()) {
            this.dputil.enter("beginOptionalCustomData", new Object[0]);
        }
        try {
            if (this.streamFormatVersion == 2) {
                ValueOutputStream vout = (ValueOutputStream)this.orbStream;
                vout.start_value(this.currentClassDesc.getRMIIIOPOptionalDataRepId());
            }
        }
        finally {
            if (this.valueHandlerDebug()) {
                this.dputil.exit();
            }
        }
    }

    public final void setOrbStream(OutputStream os) {
        this.orbStream = os;
        this.setORB(os.orb());
    }

    @Override
    public final OutputStream getOrbStream() {
        return this.orbStream;
    }

    public final void increaseRecursionDepth() {
        ++this.recursionDepth;
        if (this.valueHandlerDebug()) {
            this.dputil.dprint("Incrementing recursion depth to " + this.recursionDepth);
        }
    }

    public final int decreaseRecursionDepth() {
        --this.recursionDepth;
        if (this.valueHandlerDebug()) {
            this.dputil.dprint("Decrementing recursion depth to " + this.recursionDepth);
        }
        return this.recursionDepth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFormatVersion() {
        if (this.valueHandlerDebug()) {
            this.dputil.enter("writeFormatVersion", new Object[0]);
        }
        try {
            this.orbStream.write_octet(this.streamFormatVersion);
        }
        finally {
            if (this.valueHandlerDebug()) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TraceValueHandler
    @ValueHandlerWrite
    public final void writeObjectOverride(Object obj) throws IOException {
        if (this.valueHandlerDebug()) {
            this.dputil.enter("writeObjectOverride", new Object[0]);
        }
        try {
            this.writeObjectState.writeData(this);
            Util.getInstance().writeAbstractObject((org.omg.CORBA.portable.OutputStream)this.orbStream, obj);
        }
        finally {
            if (this.valueHandlerDebug()) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TraceValueHandler
    @ValueHandlerWrite
    public final void simpleWriteObject(Object obj, byte formatVersion) {
        if (this.valueHandlerDebug()) {
            this.dputil.enter("simpleWriteObject", "obj", obj);
        }
        try {
            byte oldStreamFormatVersion = this.streamFormatVersion;
            this.streamFormatVersion = formatVersion;
            Object prevObject = this.currentObject;
            ObjectStreamClass prevClassDesc = this.currentClassDesc;
            ++this.simpleWriteDepth;
            try {
                this.outputObject(obj);
            }
            catch (IOException ee) {
                if (this.abortIOException == null) {
                    this.abortIOException = ee;
                }
            }
            finally {
                this.streamFormatVersion = oldStreamFormatVersion;
                --this.simpleWriteDepth;
                this.currentObject = prevObject;
                this.currentClassDesc = prevClassDesc;
            }
            IOException pending = this.abortIOException;
            if (this.simpleWriteDepth == 0) {
                this.abortIOException = null;
            }
            if (pending != null) {
                bridge.throwException((Throwable)pending);
            }
        }
        finally {
            if (this.valueHandlerDebug()) {
                this.dputil.exit();
            }
        }
    }

    @Override
    ObjectStreamField[] getFieldsNoCopy() {
        return this.currentClassDesc.getFieldsNoCopy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TraceValueHandler
    @ValueHandlerWrite
    public final void defaultWriteObjectDelegate() {
        if (this.valueHandlerDebug()) {
            this.dputil.enter("defaultWriteObjectDelegate", new Object[0]);
        }
        try {
            if (this.currentObject == null || this.currentClassDesc == null) {
                throw new NotActiveException("defaultWriteObjectDelegate");
            }
            ObjectStreamField[] fields = this.currentClassDesc.getFieldsNoCopy();
            if (fields.length > 0) {
                this.outputClassFields(this.currentObject, this.currentClassDesc.forClass(), fields);
            }
        }
        catch (IOException ioe) {
            bridge.throwException((Throwable)ioe);
        }
        finally {
            if (this.valueHandlerDebug()) {
                this.dputil.exit();
            }
        }
    }

    public final boolean enableReplaceObjectDelegate(boolean enable) {
        return false;
    }

    @Override
    protected final void annotateClass(Class<?> cl) throws IOException {
        throw new IOException("Method annotateClass not supported");
    }

    @Override
    public final void close() throws IOException {
    }

    @Override
    protected final void drain() throws IOException {
    }

    @Override
    @TraceValueHandler
    @ValueHandlerWrite
    public final void flush() throws IOException {
        try {
            this.orbStream.flush();
        }
        catch (Error e) {
            IOException ioexc = new IOException(e.getMessage());
            ioexc.initCause(e);
            throw ioexc;
        }
    }

    @Override
    @TraceValueHandler
    @ValueHandlerWrite
    protected final Object replaceObject(Object obj) throws IOException {
        throw new IOException("Method replaceObject not supported");
    }

    @Override
    @TraceValueHandler
    @ValueHandlerWrite
    public final void reset() throws IOException {
        try {
            if (this.currentObject != null || this.currentClassDesc != null) {
                throw new IOException("Illegal call to reset");
            }
            this.abortIOException = null;
            if (this.classDescStack == null) {
                this.classDescStack = new Stack();
            } else {
                this.classDescStack.setSize(0);
            }
        }
        catch (Error e) {
            IOException ioexc = new IOException(e.getMessage());
            ioexc.initCause(e);
            throw ioexc;
        }
    }

    @Override
    @TraceValueHandler
    @ValueHandlerWrite
    public final void write(byte[] b) throws IOException {
        try {
            this.writeObjectState.writeData(this);
            this.orbStream.write_octet_array(b, 0, b.length);
        }
        catch (Error e) {
            IOException ioexc = new IOException(e.getMessage());
            ioexc.initCause(e);
            throw ioexc;
        }
    }

    @Override
    @TraceValueHandler
    @ValueHandlerWrite
    public final void write(byte[] b, int off, int len) throws IOException {
        try {
            this.writeObjectState.writeData(this);
            this.orbStream.write_octet_array(b, off, len);
        }
        catch (Error e) {
            IOException ioexc = new IOException(e.getMessage());
            ioexc.initCause(e);
            throw ioexc;
        }
    }

    @Override
    @TraceValueHandler
    @ValueHandlerWrite
    public final void write(int data) throws IOException {
        try {
            this.writeObjectState.writeData(this);
            this.orbStream.write_octet((byte)(data & 0xFF));
        }
        catch (Error e) {
            IOException ioexc = new IOException(e.getMessage());
            ioexc.initCause(e);
            throw ioexc;
        }
    }

    @Override
    @TraceValueHandler
    @ValueHandlerWrite
    public final void writeBoolean(boolean data) throws IOException {
        try {
            this.writeObjectState.writeData(this);
            this.orbStream.write_boolean(data);
        }
        catch (Error e) {
            IOException ioexc = new IOException(e.getMessage());
            ioexc.initCause(e);
            throw ioexc;
        }
    }

    @Override
    @TraceValueHandler
    @ValueHandlerWrite
    public final void writeByte(int data) throws IOException {
        try {
            this.writeObjectState.writeData(this);
            this.orbStream.write_octet((byte)data);
        }
        catch (Error e) {
            IOException ioexc = new IOException(e.getMessage());
            ioexc.initCause(e);
            throw ioexc;
        }
    }

    @Override
    @TraceValueHandler
    @ValueHandlerWrite
    public final void writeBytes(String data) throws IOException {
        try {
            this.writeObjectState.writeData(this);
            byte[] buf = data.getBytes();
            this.orbStream.write_octet_array(buf, 0, buf.length);
        }
        catch (Error e) {
            IOException ioexc = new IOException(e.getMessage());
            ioexc.initCause(e);
            throw ioexc;
        }
    }

    @Override
    @TraceValueHandler
    @ValueHandlerWrite
    public final void writeChar(int data) throws IOException {
        try {
            this.writeObjectState.writeData(this);
            this.orbStream.write_wchar((char)data);
        }
        catch (Error e) {
            IOException ioexc = new IOException(e.getMessage());
            ioexc.initCause(e);
            throw ioexc;
        }
    }

    @Override
    @TraceValueHandler
    @ValueHandlerWrite
    public final void writeChars(String data) throws IOException {
        try {
            this.writeObjectState.writeData(this);
            char[] buf = data.toCharArray();
            this.orbStream.write_wchar_array(buf, 0, buf.length);
        }
        catch (Error e) {
            IOException ioexc = new IOException(e.getMessage());
            ioexc.initCause(e);
            throw ioexc;
        }
    }

    @Override
    @TraceValueHandler
    @ValueHandlerWrite
    public final void writeDouble(double data) throws IOException {
        try {
            this.writeObjectState.writeData(this);
            this.orbStream.write_double(data);
        }
        catch (Error e) {
            IOException ioexc = new IOException(e.getMessage());
            ioexc.initCause(e);
            throw ioexc;
        }
    }

    @Override
    @TraceValueHandler
    @ValueHandlerWrite
    public final void writeFloat(float data) throws IOException {
        try {
            this.writeObjectState.writeData(this);
            this.orbStream.write_float(data);
        }
        catch (Error e) {
            IOException ioexc = new IOException(e.getMessage());
            ioexc.initCause(e);
            throw ioexc;
        }
    }

    @Override
    @TraceValueHandler
    @ValueHandlerWrite
    public final void writeInt(int data) throws IOException {
        try {
            this.writeObjectState.writeData(this);
            this.orbStream.write_long(data);
        }
        catch (Error e) {
            IOException ioexc = new IOException(e.getMessage());
            ioexc.initCause(e);
            throw ioexc;
        }
    }

    @Override
    @TraceValueHandler
    @ValueHandlerWrite
    public final void writeLong(long data) throws IOException {
        try {
            this.writeObjectState.writeData(this);
            this.orbStream.write_longlong(data);
        }
        catch (Error e) {
            IOException ioexc = new IOException(e.getMessage());
            ioexc.initCause(e);
            throw ioexc;
        }
    }

    @Override
    @TraceValueHandler
    @ValueHandlerWrite
    public final void writeShort(int data) throws IOException {
        try {
            this.writeObjectState.writeData(this);
            this.orbStream.write_short((short)data);
        }
        catch (Error e) {
            IOException ioexc = new IOException(e.getMessage());
            ioexc.initCause(e);
            throw ioexc;
        }
    }

    @Override
    protected final void writeStreamHeader() throws IOException {
    }

    protected void internalWriteUTF(org.omg.CORBA.portable.OutputStream stream, String data) {
        stream.write_wstring(data);
    }

    @Override
    @TraceValueHandler
    @ValueHandlerWrite
    public final void writeUTF(String data) throws IOException {
        try {
            this.writeObjectState.writeData(this);
            this.internalWriteUTF((org.omg.CORBA.portable.OutputStream)this.orbStream, data);
        }
        catch (Error e) {
            IOException ioexc = new IOException(e.getMessage());
            ioexc.initCause(e);
            throw ioexc;
        }
    }

    private boolean checkSpecialClasses(Object obj) throws IOException {
        if (obj instanceof ObjectStreamClass) {
            throw new IOException("Serialization of ObjectStreamClass not supported");
        }
        return false;
    }

    private boolean checkSubstitutableSpecialClasses(Object obj) throws IOException {
        if (obj instanceof String) {
            this.orbStream.write_value((Serializable)obj);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TraceValueHandler
    @ValueHandlerWrite
    private void outputObject(Object obj) throws IOException {
        block19: {
            if (this.valueHandlerDebug()) {
                this.dputil.enter("outputObject", "obj", obj);
            }
            try {
                this.currentObject = obj;
                Class<?> currclass = obj.getClass();
                this.currentClassDesc = ObjectStreamClass.lookup(currclass);
                if (this.currentClassDesc == null) {
                    throw new NotSerializableException(currclass.getName());
                }
                if (this.currentClassDesc.isExternalizable()) {
                    this.writeFormatVersion();
                    OutputStreamHook.WriteObjectState oldState = this.writeObjectState;
                    this.setState(NOT_IN_WRITE_OBJECT);
                    try {
                        Externalizable ext = (Externalizable)obj;
                        ext.writeExternal(this);
                        break block19;
                    }
                    finally {
                        this.setState(oldState);
                    }
                }
                int stackMark = this.classDescStack.size();
                try {
                    ObjectStreamClass next;
                    while ((next = this.currentClassDesc.getSuperclass()) != null) {
                        this.classDescStack.push(this.currentClassDesc);
                        this.currentClassDesc = next;
                    }
                    do {
                        OutputStreamHook.WriteObjectState oldState = this.writeObjectState;
                        try {
                            this.setState(NOT_IN_WRITE_OBJECT);
                            if (this.currentClassDesc.hasWriteObject()) {
                                this.invokeObjectWriter(this.currentClassDesc, obj);
                                continue;
                            }
                            this.defaultWriteObjectDelegate();
                        }
                        finally {
                            this.setState(oldState);
                        }
                    } while (this.classDescStack.size() > stackMark && (this.currentClassDesc = this.classDescStack.pop()) != null);
                }
                finally {
                    this.classDescStack.setSize(stackMark);
                }
            }
            finally {
                if (this.valueHandlerDebug()) {
                    this.dputil.exit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TraceValueHandler
    @ValueHandlerWrite
    private void invokeObjectWriter(ObjectStreamClass osc, Object obj) throws IOException {
        if (this.valueHandlerDebug()) {
            this.dputil.enter("invokeObjectWriter", "obj", obj);
        }
        try {
            Class c = osc.forClass();
            try {
                this.writeFormatVersion();
                this.writeObjectState.enterWriteObject(this);
                try {
                    osc.writeObjectMethod.invoke(obj, this);
                }
                finally {
                    this.writeObjectState.exitWriteObject(this);
                }
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new Error("invokeObjectWriter internal error", e);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        finally {
            if (this.valueHandlerDebug()) {
                this.dputil.exit();
            }
        }
    }

    @Override
    @TraceValueHandler
    @ValueHandlerWrite
    void writeField(ObjectStreamField field, Object value) throws IOException {
        switch (field.getTypeCode()) {
            case 'B': {
                if (value == null) {
                    this.orbStream.write_octet((byte)0);
                    break;
                }
                this.orbStream.write_octet(((Byte)value).byteValue());
                break;
            }
            case 'C': {
                if (value == null) {
                    this.orbStream.write_wchar('\u0000');
                    break;
                }
                this.orbStream.write_wchar(((Character)value).charValue());
                break;
            }
            case 'F': {
                if (value == null) {
                    this.orbStream.write_float(0.0f);
                    break;
                }
                this.orbStream.write_float(((Float)value).floatValue());
                break;
            }
            case 'D': {
                if (value == null) {
                    this.orbStream.write_double(0.0);
                    break;
                }
                this.orbStream.write_double(((Double)value).doubleValue());
                break;
            }
            case 'I': {
                if (value == null) {
                    this.orbStream.write_long(0);
                    break;
                }
                this.orbStream.write_long(((Integer)value).intValue());
                break;
            }
            case 'J': {
                if (value == null) {
                    this.orbStream.write_longlong(0L);
                    break;
                }
                this.orbStream.write_longlong(((Long)value).longValue());
                break;
            }
            case 'S': {
                if (value == null) {
                    this.orbStream.write_short((short)0);
                    break;
                }
                this.orbStream.write_short(((Short)value).shortValue());
                break;
            }
            case 'Z': {
                if (value == null) {
                    this.orbStream.write_boolean(false);
                    break;
                }
                this.orbStream.write_boolean(((Boolean)value).booleanValue());
                break;
            }
            case 'L': 
            case '[': {
                this.writeObjectField(field, value);
                break;
            }
            default: {
                throw new InvalidClassException(this.currentClassDesc.getName());
            }
        }
    }

    @TraceValueHandler
    @ValueHandlerWrite
    private void writeObjectField(ObjectStreamField field, Object objectValue) throws IOException {
        if (ObjectStreamClassCorbaExt.isAny(field.getTypeString())) {
            Util.getInstance().writeAny((org.omg.CORBA.portable.OutputStream)this.orbStream, objectValue);
        } else {
            Class type = field.getType();
            int callType = 2;
            ClassInfoCache.ClassInfo cinfo = field.getClassInfo();
            if (cinfo.isInterface()) {
                String className = type.getName();
                if (cinfo.isARemote(type)) {
                    callType = 0;
                } else if (cinfo.isACORBAObject(type)) {
                    callType = 0;
                } else if (RepositoryId.isAbstractBase(type)) {
                    callType = 1;
                } else if (ObjectStreamClassCorbaExt.isAbstractInterface(type)) {
                    callType = 1;
                }
            }
            switch (callType) {
                case 0: {
                    Util.getInstance().writeRemoteObject((org.omg.CORBA.portable.OutputStream)this.orbStream, objectValue);
                    break;
                }
                case 1: {
                    Util.getInstance().writeAbstractObject((org.omg.CORBA.portable.OutputStream)this.orbStream, objectValue);
                    break;
                }
                case 2: {
                    try {
                        this.orbStream.write_value((Serializable)objectValue, type);
                        break;
                    }
                    catch (ClassCastException cce) {
                        if (objectValue instanceof Serializable) {
                            throw cce;
                        }
                        Utility.throwNotSerializableForCorba(objectValue.getClass().getName());
                    }
                }
            }
        }
    }

    @TraceValueHandler
    @ValueHandlerWrite
    private void outputClassFields(Object o, Class cl, ObjectStreamField[] fields) throws IOException, InvalidClassException {
        block11: for (int i = 0; i < fields.length; ++i) {
            ObjectStreamField field = fields[i];
            long offset = field.getFieldID();
            if (offset == -1L) {
                throw new InvalidClassException(cl.getName(), "Nonexistent field " + fields[i].getName());
            }
            switch (field.getTypeCode()) {
                case 'B': {
                    byte byteValue = bridge.getByte(o, offset);
                    this.orbStream.write_octet(byteValue);
                    continue block11;
                }
                case 'C': {
                    char charValue = bridge.getChar(o, offset);
                    this.orbStream.write_wchar(charValue);
                    continue block11;
                }
                case 'F': {
                    float floatValue = bridge.getFloat(o, offset);
                    this.orbStream.write_float(floatValue);
                    continue block11;
                }
                case 'D': {
                    double doubleValue = bridge.getDouble(o, offset);
                    this.orbStream.write_double(doubleValue);
                    continue block11;
                }
                case 'I': {
                    int intValue = bridge.getInt(o, offset);
                    this.orbStream.write_long(intValue);
                    continue block11;
                }
                case 'J': {
                    long longValue = bridge.getLong(o, offset);
                    this.orbStream.write_longlong(longValue);
                    continue block11;
                }
                case 'S': {
                    short shortValue = bridge.getShort(o, offset);
                    this.orbStream.write_short(shortValue);
                    continue block11;
                }
                case 'Z': {
                    boolean booleanValue = bridge.getBoolean(o, offset);
                    this.orbStream.write_boolean(booleanValue);
                    continue block11;
                }
                case 'L': 
                case '[': {
                    Object objectValue = bridge.getObject(o, offset);
                    this.writeObjectField(fields[i], objectValue);
                    continue block11;
                }
                default: {
                    throw new InvalidClassException(cl.getName());
                }
            }
        }
    }
}

