/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.j2ee.statistics;

import java.util.Map;
import javax.management.j2ee.statistics.BoundaryStatistic;
import javax.management.j2ee.statistics.BoundedRangeStatistic;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.RangeStatistic;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.TimeStatistic;
import javax.management.openmbean.CompositeData;
import org.glassfish.admin.amx.j2ee.statistics.BoundaryStatisticImpl;
import org.glassfish.admin.amx.j2ee.statistics.BoundedRangeStatisticImpl;
import org.glassfish.admin.amx.j2ee.statistics.CountStatisticImpl;
import org.glassfish.admin.amx.j2ee.statistics.MapStatistic;
import org.glassfish.admin.amx.j2ee.statistics.MapStatisticImpl;
import org.glassfish.admin.amx.j2ee.statistics.NumberStatistic;
import org.glassfish.admin.amx.j2ee.statistics.NumberStatisticImpl;
import org.glassfish.admin.amx.j2ee.statistics.RangeStatisticImpl;
import org.glassfish.admin.amx.j2ee.statistics.StringStatistic;
import org.glassfish.admin.amx.j2ee.statistics.StringStatisticImpl;
import org.glassfish.admin.amx.j2ee.statistics.TimeStatisticImpl;
import org.glassfish.admin.amx.util.ClassUtil;
import org.glassfish.admin.amx.util.TypeCast;
import org.glassfish.admin.amx.util.jmx.OpenMBeanUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StatisticFactory {
    private static final String COUNT_STATISTIC = CountStatistic.class.getName();
    private static final String TIME_STATISTIC = TimeStatistic.class.getName();
    private static final String RANGE_STATISTIC = RangeStatistic.class.getName();
    private static final String BOUNDARY_STATISTIC = BoundaryStatistic.class.getName();
    private static final String BOUNDED_RANGE_STATISTIC = BoundedRangeStatistic.class.getName();
    private static final String STRING_STATISTIC = StringStatistic.class.getName();
    private static final String MAP_STATISTIC = MapStatistic.class.getName();
    private static final String NUMBER_STATISTIC = NumberStatistic.class.getName();
    private static final Class<? extends Statistic>[] KNOWN_STATISTICS = (Class[])TypeCast.asArray((Object)new Class[]{CountStatistic.class, TimeStatistic.class, BoundedRangeStatistic.class, RangeStatistic.class, BoundaryStatistic.class, StringStatistic.class, NumberStatistic.class});
    private static final String INTERNAL_STRING_STATISTIC_CLASSNAME = "com.sun.enterprise.admin.monitor.stats.StringStatisticImpl";

    private StatisticFactory() {
    }

    public static Statistic create(Class<? extends Statistic> theInterface, CompositeData data) {
        return StatisticFactory.create(theInterface, OpenMBeanUtil.compositeDataToMap((CompositeData)data));
    }

    public static Statistic create(CompositeData data) {
        String typeName = data.getCompositeType().getTypeName();
        Class<Statistic> theInterface = null;
        if (typeName.equals(COUNT_STATISTIC)) {
            theInterface = CountStatistic.class;
        } else if (typeName.equals(TIME_STATISTIC)) {
            theInterface = TimeStatistic.class;
        } else if (typeName.equals(RANGE_STATISTIC)) {
            theInterface = RangeStatistic.class;
        } else if (typeName.equals(BOUNDARY_STATISTIC)) {
            theInterface = BoundaryStatistic.class;
        } else if (typeName.equals(BOUNDED_RANGE_STATISTIC)) {
            theInterface = BoundedRangeStatistic.class;
        } else if (typeName.equals(STRING_STATISTIC)) {
            theInterface = StringStatistic.class;
        } else if (typeName.equals(NUMBER_STATISTIC)) {
            theInterface = NumberStatistic.class;
        } else if (typeName.equals(MAP_STATISTIC)) {
            theInterface = MapStatistic.class;
        } else {
            try {
                theInterface = TypeCast.asClass((Class)ClassUtil.classForName((String)typeName));
            }
            catch (Exception e) {
                theInterface = Statistic.class;
            }
        }
        return StatisticFactory.create(theInterface, data);
    }

    public static Statistic create(Class<? extends Statistic> theInterface, Map<String, ?> mappings) {
        Statistic result = null;
        if (theInterface == CountStatistic.class) {
            result = new CountStatisticImpl(mappings);
        } else if (theInterface == RangeStatistic.class) {
            result = new RangeStatisticImpl(mappings);
        } else if (theInterface == BoundaryStatistic.class) {
            result = new BoundaryStatisticImpl(mappings);
        } else if (theInterface == BoundedRangeStatistic.class) {
            result = new BoundedRangeStatisticImpl(mappings);
        } else if (theInterface == TimeStatistic.class) {
            result = new TimeStatisticImpl(mappings);
        } else if (theInterface == StringStatistic.class) {
            result = new StringStatisticImpl(mappings);
        } else if (theInterface == NumberStatistic.class) {
            result = new NumberStatisticImpl(mappings);
        } else if (theInterface == MapStatistic.class) {
            result = new MapStatisticImpl(mappings);
        } else {
            throw new IllegalArgumentException("Unsupported Statistic interface: " + theInterface.getName());
        }
        return result;
    }

    public static Class<? extends Statistic> getInterface(Statistic s) {
        Class<?> implClass = s.getClass();
        Class theInterface = MapStatistic.class;
        for (int i = 0; i < KNOWN_STATISTICS.length; ++i) {
            Class<? extends Statistic> candidateInterface = KNOWN_STATISTICS[i];
            if (!candidateInterface.isAssignableFrom(implClass)) continue;
            theInterface = candidateInterface;
            break;
        }
        if (theInterface == MapStatistic.class && !(s instanceof MapStatisticImpl)) {
            if (s.getClass().getName().equals(INTERNAL_STRING_STATISTIC_CLASSNAME)) {
                theInterface = StringStatistic.class;
            } else {
                throw new IllegalArgumentException("Unknown statistic class: " + s.getClass().getName());
            }
        }
        return theInterface;
    }
}

