/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.jpa;

import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitsDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.logging.LogDomains;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import org.glassfish.persistence.common.Java2DBProcessorHelper;
import org.glassfish.persistence.jpa.JPAJava2DBProcessor;
import org.glassfish.persistence.jpa.PersistenceUnitInfoImpl;
import org.glassfish.persistence.jpa.ProviderContainerContractInfo;

public class PersistenceUnitLoader {
    private ProviderContainerContractInfo providerContainerContractInfo;
    private EntityManagerFactory emf;
    private boolean java2db;
    private JPAJava2DBProcessor processor;
    private static Logger logger = LogDomains.getLogger(PersistenceUnitLoader.class, (String)"javax.enterprise.system.tools.deployment");
    private static Map<String, String> integrationPropertiesWithJava2DB;
    private static Map<String, String> integrationPropertiesWithoutJava2DB;

    public PersistenceUnitLoader(PersistenceUnitDescriptor puToInstatntiate, ProviderContainerContractInfo providerContainerContractInfo) {
        this.providerContainerContractInfo = providerContainerContractInfo;
        this.setSystemPropertyToEnableDoPrivilegedInEclipseLink();
        this.emf = this.loadPU(puToInstatntiate);
    }

    public EntityManagerFactory getEMF() {
        return this.emf;
    }

    private void setSystemPropertyToEnableDoPrivilegedInEclipseLink() {
        String PROPERTY_NAME = "eclipselink.security.usedoprivileged";
        if (System.getProperty("eclipselink.security.usedoprivileged") == null) {
            System.setProperty("eclipselink.security.usedoprivileged", String.valueOf(Boolean.TRUE));
        }
    }

    private EntityManagerFactory loadPU(PersistenceUnitDescriptor pud) {
        PersistenceProvider provider;
        PersistenceUnitInfoImpl pInfo = new PersistenceUnitInfoImpl(pud, this.providerContainerContractInfo);
        String applicationLocation = this.providerContainerContractInfo.getApplicationLocation();
        boolean fineMsgLoggable = logger.isLoggable(Level.FINE);
        if (fineMsgLoggable) {
            logger.fine("Loading persistence unit for application: \"" + applicationLocation + "\"pu Root is: " + pud.getPuRoot());
            logger.fine("PersistenceInfo for this pud is :\n" + pInfo);
        }
        try {
            provider = (PersistenceProvider)PersistenceProvider.class.cast(((ClassLoader)ClassLoader.class.cast(this.providerContainerContractInfo.getClassLoader())).loadClass(pInfo.getPersistenceProviderClassName()).newInstance());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        boolean isDeploy = this.providerContainerContractInfo.isDeploy();
        if (isDeploy) {
            this.processor = new JPAJava2DBProcessor(new Java2DBProcessorHelper(this.providerContainerContractInfo.getDeploymentContext()));
            this.java2db = this.processor.isJava2DbPU(pud);
        }
        Map<String, String> overrides = this.java2db ? integrationPropertiesWithJava2DB : integrationPropertiesWithoutJava2DB;
        EntityManagerFactory emf = provider.createContainerEntityManagerFactory((PersistenceUnitInfo)pInfo, overrides);
        if (fineMsgLoggable) {
            logger.logp(Level.FINE, "PersistenceUnitLoader", "loadPU", "emf = {0}", emf);
        }
        PersistenceUnitsDescriptor parent = pud.getParent();
        RootDeploymentDescriptor containingBundle = parent.getParent();
        this.providerContainerContractInfo.registerEMF(pInfo.getPersistenceUnitName(), pud.getPuRoot(), containingBundle, emf);
        if (fineMsgLoggable) {
            logger.fine("Finished loading persistence unit for application: " + applicationLocation);
        }
        return emf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doJava2DB() {
        if (this.java2db) {
            boolean fineMsgLoggable = logger.isLoggable(Level.FINE);
            EntityManager em = null;
            try {
                if (fineMsgLoggable) {
                    logger.fine("<--- To Create EM");
                }
                em = this.emf.createEntityManager();
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
            finally {
                if (em != null) {
                    em.close();
                }
            }
            if (fineMsgLoggable) {
                logger.fine("---> Done Create EM");
            }
            if (fineMsgLoggable) {
                logger.fine("<--- To Create Tables");
            }
            this.processor.createTablesInDB();
            if (fineMsgLoggable) {
                logger.fine("---> Done Create Tables");
            }
        }
    }

    static {
        HashMap<String, String> props = new HashMap<String, String>();
        String ECLIPSELINK_SERVER_PLATFORM_CLASS_NAME_PROPERTY = "eclipselink.target-server";
        props.put("eclipselink.target-server", System.getProperty("eclipselink.target-server", "SunAS9"));
        String TOPLINK_SERVER_PLATFORM_CLASS_NAME_PROPERTY = "toplink.target-server";
        props.put("toplink.target-server", System.getProperty("toplink.target-server", "SunAS9"));
        String HIBERNATE_TRANSACTION_MANAGER_LOOKUP_CLASS_PROPERTY = "hibernate.transaction.manager_lookup_class";
        props.put("hibernate.transaction.manager_lookup_class", System.getProperty("hibernate.transaction.manager_lookup_class", "org.hibernate.transaction.SunONETransactionManagerLookup"));
        Map baseIntegrationProperties = Collections.unmodifiableMap(props);
        HashMap<String, String> java2dbProps = new HashMap<String, String>(baseIntegrationProperties);
        String DROP_AND_CREATE = "drop-and-create-tables";
        String TOPLINK_DDL_GENERATION = "toplink.ddl-generation";
        java2dbProps.put("toplink.ddl-generation", "drop-and-create-tables");
        String ECLIPSELINK_DDL_GENERATION = "eclipselink.ddl-generation";
        java2dbProps.put("eclipselink.ddl-generation", "drop-and-create-tables");
        String DDL_SQL_SCRIPT_GENERATION = "sql-script";
        String TOPLINK_DDL_GENERATION_MODE = "toplink.ddl-generation.output-mode";
        java2dbProps.put("toplink.ddl-generation.output-mode", "sql-script");
        String ECLIPSELINK_DDL_GENERATION_MODE = "eclipselink.ddl-generation.output-mode";
        java2dbProps.put("eclipselink.ddl-generation.output-mode", "sql-script");
        integrationPropertiesWithJava2DB = Collections.unmodifiableMap(java2dbProps);
        HashMap<String, String> nonjava2dbProps = new HashMap<String, String>(baseIntegrationProperties);
        String ECLIPSELINK_DDL_GENERATION_MODE_PROPERTY = "eclipselink.ddl-generation.output-mode";
        nonjava2dbProps.put("eclipselink.ddl-generation.output-mode", System.getProperty("eclipselink.ddl-generation.output-mode", "none"));
        String TOPLINK_DDL_GENERATION_MODE_PROPERTY = "toplink.ddl-generation.output-mode";
        nonjava2dbProps.put("toplink.ddl-generation.output-mode", System.getProperty("toplink.ddl-generation.output-mode", "none"));
        integrationPropertiesWithoutJava2DB = Collections.unmodifiableMap(nonjava2dbProps);
    }
}

