/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.client.ProbeClientMethodHandle;
import org.glassfish.flashlight.datatree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsProviderRegistry {
    List<StatsProviderRegistryElement> regElements = new ArrayList<StatsProviderRegistryElement>();
    private Map<String, List<StatsProviderRegistryElement>> configToRegistryElementMap = new HashMap<String, List<StatsProviderRegistryElement>>();
    private Map<Object, StatsProviderRegistryElement> statsProviderToRegistryElementMap = new HashMap<Object, StatsProviderRegistryElement>();
    private MonitoringRuntimeDataRegistry mrdr;

    public StatsProviderRegistry(MonitoringRuntimeDataRegistry mrdr) {
        this.mrdr = mrdr;
    }

    public void registerStatsProvider(String configStr, String parentTreeNodePath, List<String> childTreeNodeNames, Collection<ProbeClientMethodHandle> handles, Object statsProvider) {
        StatsProviderRegistryElement spre = new StatsProviderRegistryElement(configStr, parentTreeNodePath, childTreeNodeNames, handles, statsProvider);
        if (this.configToRegistryElementMap.containsKey(configStr)) {
            List<StatsProviderRegistryElement> spreList = this.configToRegistryElementMap.get(configStr);
            spreList.add(spre);
        } else {
            ArrayList<StatsProviderRegistryElement> spreList = new ArrayList<StatsProviderRegistryElement>();
            spreList.add(spre);
            this.configToRegistryElementMap.put(configStr, spreList);
        }
        this.statsProviderToRegistryElementMap.put(statsProvider, spre);
    }

    public void unregisterStatsProvider(Object statsProvider) throws Exception {
        StatsProviderRegistryElement spre = this.statsProviderToRegistryElementMap.get(statsProvider);
        if (spre == null) {
            throw new Exception("Invalid statsProvider, cannot unregister");
        }
        String parentNodePath = spre.getParentTreeNodePath();
        List<String> childNodeNames = spre.getChildTreeNodeNames();
        TreeNode rootNode = this.mrdr.get("server");
        if (rootNode != null) {
            List nodeList = rootNode.getNodes(parentNodePath);
            TreeNode parentNode = (TreeNode)nodeList.get(0);
            Collection childNodes = parentNode.getChildNodes();
            for (TreeNode childNode : childNodes) {
                if (!childNodeNames.contains(childNode.getName())) continue;
                parentNode.removeChild(childNode);
            }
        }
        Collection<ProbeClientMethodHandle> handles = spre.getHandles();
        for (ProbeClientMethodHandle handle : handles) {
        }
        List<StatsProviderRegistryElement> spreList = this.configToRegistryElementMap.get(spre.getConfigStr());
        if (spreList != null) {
            spreList.remove(spre);
            if (spreList.isEmpty()) {
                this.configToRegistryElementMap.remove(spre.getConfigStr());
            }
        }
        this.statsProviderToRegistryElementMap.remove(statsProvider);
        spre.setStatsProvider(null);
    }

    public void enableStatsProvider(String configElement) {
        List<StatsProviderRegistryElement> spreList = this.configToRegistryElementMap.get(configElement);
        if (spreList == null) {
            return;
        }
        for (StatsProviderRegistryElement spre : spreList) {
            String parentNodePath = spre.getParentTreeNodePath();
            List<String> childNodeNames = spre.getChildTreeNodeNames();
            TreeNode rootNode = this.mrdr.get("server");
            if (rootNode != null) {
                List nodeList = rootNode.getNodes(parentNodePath);
                TreeNode parentNode = (TreeNode)nodeList.get(0);
                Collection childNodes = parentNode.getChildNodes();
                for (TreeNode childNode : childNodes) {
                    if (!childNodeNames.contains(childNode.getName()) || childNode.isEnabled()) continue;
                    childNode.setEnabled(true);
                }
            }
            for (ProbeClientMethodHandle handle : spre.getHandles()) {
                if (handle.isEnabled()) continue;
                handle.enable();
            }
            Object statsProvider = spre.getStatsProvider();
        }
    }

    public void disableStatsProvider(String configElement) {
        List<StatsProviderRegistryElement> spreList = this.configToRegistryElementMap.get(configElement);
        if (spreList == null) {
            return;
        }
        for (StatsProviderRegistryElement spre : spreList) {
            String parentNodePath = spre.getParentTreeNodePath();
            List<String> childNodeNames = spre.getChildTreeNodeNames();
            TreeNode rootNode = this.mrdr.get("server");
            if (rootNode != null) {
                List nodeList = rootNode.getNodes(parentNodePath);
                TreeNode parentNode = (TreeNode)nodeList.get(0);
                Collection childNodes = parentNode.getChildNodes();
                for (TreeNode childNode : childNodes) {
                    if (!childNodeNames.contains(childNode.getName()) || !childNode.isEnabled()) continue;
                    childNode.setEnabled(false);
                }
            }
            for (ProbeClientMethodHandle handle : spre.getHandles()) {
                if (!handle.isEnabled()) continue;
                handle.disable();
            }
            Object statsProvider = spre.getStatsProvider();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StatsProviderRegistryElement {
        String configStr;
        String parentTreeNodePath;
        List<String> childTreeNodeNames;
        Collection<ProbeClientMethodHandle> handles;
        Object statsProvider;

        public StatsProviderRegistryElement(String configStr, String parentTreeNodePath, List<String> childTreeNodeNames, Collection<ProbeClientMethodHandle> handles, Object statsProvider) {
            this.configStr = configStr;
            this.handles = handles;
            this.parentTreeNodePath = parentTreeNodePath;
            this.childTreeNodeNames = childTreeNodeNames;
            this.statsProvider = statsProvider;
        }

        public String getConfigStr() {
            return this.configStr;
        }

        public List<String> getChildTreeNodeNames() {
            return this.childTreeNodeNames;
        }

        public String getParentTreeNodePath() {
            return this.parentTreeNodePath;
        }

        public Collection<ProbeClientMethodHandle> getHandles() {
            return this.handles;
        }

        public Object getStatsProvider() {
            return this.statsProvider;
        }

        private void setStatsProvider(Object statsProvider) {
            this.statsProvider = statsProvider;
        }
    }
}

