/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.naming;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.connectors.ConnectionManagerImpl;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.service.ConnectorAdminServiceUtils;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.single.StaticModulesRegistry;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import org.glassfish.api.admin.ProcessEnvironment;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;

public class ConnectorObjectFactory
implements ObjectFactory {
    private ConnectorRuntime runtime;
    private static Logger _logger = LogDomains.getLogger(ConnectorObjectFactory.class, (String)"javax.enterprise.system.core.naming");

    public boolean isCreateResultCacheable() {
        return false;
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env) throws Exception {
        Reference ref = (Reference)obj;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ConnectorObjectFactory: " + ref + " Name:" + name);
        }
        String poolName = (String)ref.get(0).getContent();
        String moduleName = (String)ref.get(1).getContent();
        if (this.getRuntime().getEnvironment() == 2) {
            ConnectorDescriptor connectorDescriptor = null;
            String descriptorJNDIName = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForDescriptor(moduleName);
            InitialContext ic = new InitialContext(env);
            connectorDescriptor = (ConnectorDescriptor)ic.lookup(descriptorJNDIName);
            try {
                this.getRuntime().createActiveResourceAdapter(connectorDescriptor, moduleName, null);
            }
            catch (ConnectorRuntimeException e) {
                _logger.log(Level.FINE, "Failed to look up ConnectorDescriptor from JNDI", moduleName);
                NamingException ne = new NamingException("Failed to look up ConnectorDescriptor from JNDI");
                ne.setRootCause(e);
                throw ne;
            }
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (!this.getRuntime().checkAccessibility(moduleName, loader)) {
            throw new NamingException("Only the application that has the embedded resourceadapter can access the resource adapter");
        }
        Object cf = null;
        try {
            ManagedConnectionFactory mcf = this.getRuntime().obtainManagedConnectionFactory(poolName);
            if (mcf == null) {
                _logger.log(Level.FINE, "Failed to create MCF ", poolName);
                throw new ConnectorRuntimeException("Failed to create MCF");
            }
            boolean forceNoLazyAssoc = false;
            String jndiName = name.toString();
            if (jndiName.endsWith("__pm")) {
                forceNoLazyAssoc = true;
            }
            String derivedJndiName = ConnectorsUtil.deriveJndiName((String)jndiName, (Hashtable)env);
            ConnectionManagerImpl mgr = (ConnectionManagerImpl)((Object)this.getRuntime().obtainConnectionManager(poolName, forceNoLazyAssoc));
            mgr.setJndiName(derivedJndiName);
            mgr.setRarName(moduleName);
            mgr.initialize();
            cf = mcf.createConnectionFactory((ConnectionManager)((Object)mgr));
            if (cf == null) {
                String msg = "No resource adapter found";
                throw new RuntimeException(new ConfigurationException(msg));
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Connection Factory:" + cf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return cf;
    }

    private ConnectorRuntime getRuntime() {
        try {
            if (this.runtime == null) {
                this.runtime = ConnectorRuntime.getRuntime();
            }
        }
        catch (Exception e) {
            _logger.log(Level.FINEST, "unable to get Connector Runtime due to the following exception, trying client mode", e);
            this.runtime = (ConnectorRuntime)this.getHabitat().getComponent(ConnectorRuntime.class);
        }
        return this.runtime;
    }

    private Habitat getHabitat() {
        Habitat habitat = null;
        StaticModulesRegistry registry = new StaticModulesRegistry(this.getClass().getClassLoader());
        habitat = registry.createHabitat("default");
        StartupContext startupContext = new StartupContext();
        habitat.add((Inhabitant)new ExistingSingletonInhabitant((Object)startupContext));
        habitat.addComponent(null, (Object)new ProcessEnvironment(ProcessEnvironment.ProcessType.Other));
        return habitat;
    }
}

