/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.encoding.BufferManagerRead;
import com.sun.corba.ee.impl.encoding.BufferQueue;
import com.sun.corba.ee.impl.encoding.ByteBufferWithInfo;
import com.sun.corba.ee.impl.encoding.MarkAndResetHandler;
import com.sun.corba.ee.impl.encoding.RestorableInputStream;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.protocol.RequestCanceledException;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.FragmentMessage;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.Message;
import com.sun.corba.ee.pept.transport.ByteBufferPool;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import org.omg.CORBA.ORB;

public class BufferManagerReadStream
implements BufferManagerRead,
MarkAndResetHandler {
    private boolean receivedCancel = false;
    private int cancelReqId = 0;
    private boolean endOfStream = true;
    private BufferQueue fragmentQueue = new BufferQueue();
    private long FRAGMENT_TIMEOUT = 6000L;
    private com.sun.corba.ee.spi.orb.ORB orb;
    private ORBUtilSystemException wrapper;
    private boolean debug = false;
    private boolean markEngaged = false;
    private LinkedList<ByteBufferWithInfo> fragmentStack = null;
    private RestorableInputStream inputStream = null;
    private Object streamMemento = null;

    BufferManagerReadStream(com.sun.corba.ee.spi.orb.ORB orb) {
        this.orb = orb;
        this.wrapper = orb.getLogWrapperTable().get_RPC_ENCODING_ORBUtil();
        this.debug = orb.transportDebugFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelProcessing(int requestId) {
        BufferQueue bufferQueue = this.fragmentQueue;
        synchronized (bufferQueue) {
            this.receivedCancel = true;
            this.cancelReqId = requestId;
            this.fragmentQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFragment(ByteBuffer byteBuffer, FragmentMessage msg) {
        ByteBufferWithInfo bbwi = new ByteBufferWithInfo((ORB)this.orb, byteBuffer, msg.getHeaderLength());
        BufferQueue bufferQueue = this.fragmentQueue;
        synchronized (bufferQueue) {
            if (this.debug) {
                int bbAddress = System.identityHashCode(byteBuffer);
                StringBuffer sb = new StringBuffer(80);
                sb.append("processFragment() - queueing ByteBuffer id (");
                sb.append(bbAddress).append(") to fragment queue.");
                String strMsg = sb.toString();
                this.dprint(strMsg);
            }
            this.fragmentQueue.enqueue(bbwi);
            this.endOfStream = !msg.moreFragmentsToFollow();
            this.fragmentQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBufferWithInfo underflow(ByteBufferWithInfo bbwi) {
        ByteBufferWithInfo result = null;
        Object object = this.fragmentQueue;
        synchronized (object) {
            if (this.receivedCancel) {
                if (this.debug) {
                    this.dprint("underflow() - Cancel request id: " + this.cancelReqId);
                }
                throw new RequestCanceledException(this.cancelReqId);
            }
            while (this.fragmentQueue.size() == 0) {
                if (this.endOfStream) {
                    throw this.wrapper.endOfStream();
                }
                boolean interrupted = false;
                try {
                    this.fragmentQueue.wait(this.FRAGMENT_TIMEOUT);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
                if (!interrupted && this.fragmentQueue.size() == 0) {
                    throw this.wrapper.bufferReadManagerTimeout();
                }
                if (!this.receivedCancel) continue;
                if (this.debug) {
                    this.dprint("underflow() - Cancel request id after wait: " + this.cancelReqId);
                }
                throw new RequestCanceledException(this.cancelReqId);
            }
            result = this.fragmentQueue.dequeue();
            result.setFragmented(true);
            if (this.debug) {
                int bbAddr = System.identityHashCode(result.getByteBuffer());
                StringBuffer sb1 = new StringBuffer(80);
                sb1.append("underflow() - dequeued ByteBuffer id (");
                sb1.append(bbAddr).append(") from fragment queue.");
                String msg1 = sb1.toString();
                this.dprint(msg1);
            }
            if (!this.markEngaged && bbwi != null && bbwi.getByteBuffer() != null) {
                ByteBufferPool byteBufferPool = this.getByteBufferPool();
                if (this.debug) {
                    int bbAddress = System.identityHashCode(bbwi.getByteBuffer());
                    StringBuffer sb = new StringBuffer(80);
                    sb.append("underflow() - releasing ByteBuffer id (");
                    sb.append(bbAddress).append(") to ByteBufferPool.");
                    String msg = sb.toString();
                    this.dprint(msg);
                }
                byteBufferPool.releaseByteBuffer(bbwi.getByteBuffer());
                bbwi.setByteBuffer(null);
                bbwi = null;
            }
        }
        object = result;
        return object;
    }

    public void init(Message msg) {
        if (msg != null) {
            this.endOfStream = !msg.moreFragmentsToFollow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(ByteBufferWithInfo bbwi) {
        String msg;
        StringBuffer sb;
        int bbAddress;
        int inputBbAddress = 0;
        if (bbwi != null) {
            inputBbAddress = System.identityHashCode(bbwi.getByteBuffer());
        }
        ByteBufferPool byteBufferPool = this.getByteBufferPool();
        if (this.fragmentQueue != null) {
            BufferQueue bufferQueue = this.fragmentQueue;
            synchronized (bufferQueue) {
                ByteBufferWithInfo abbwi = null;
                while (this.fragmentQueue.size() != 0) {
                    abbwi = this.fragmentQueue.dequeue();
                    if (abbwi == null || abbwi.getByteBuffer() == null) continue;
                    if (this.debug && inputBbAddress != (bbAddress = System.identityHashCode(abbwi.getByteBuffer()))) {
                        sb = new StringBuffer(80);
                        sb.append("close() - fragmentQueue is ").append("releasing ByteBuffer id (").append(bbAddress).append(") to ").append("ByteBufferPool.");
                        msg = sb.toString();
                        this.dprint(msg);
                    }
                    byteBufferPool.releaseByteBuffer(abbwi.getByteBuffer());
                }
            }
            this.fragmentQueue = null;
        }
        if (this.fragmentStack != null && this.fragmentStack.size() != 0) {
            for (ByteBufferWithInfo abbwi : this.fragmentStack) {
                if (abbwi == null || abbwi.getByteBuffer() == null || inputBbAddress == (bbAddress = System.identityHashCode(abbwi.getByteBuffer()))) continue;
                if (this.debug) {
                    sb = new StringBuffer(80);
                    sb.append("close() - fragmentStack - releasing ").append("ByteBuffer id (" + bbAddress + ") to ").append("ByteBufferPool.");
                    msg = sb.toString();
                    this.dprint(msg);
                }
                byteBufferPool.releaseByteBuffer(abbwi.getByteBuffer());
            }
            this.fragmentStack = null;
        }
    }

    protected ByteBufferPool getByteBufferPool() {
        return this.orb.getByteBufferPool();
    }

    private void dprint(String msg) {
        ORBUtility.dprint("BufferManagerReadStream", msg);
    }

    public void mark(RestorableInputStream inputStream) {
        this.inputStream = inputStream;
        this.markEngaged = true;
        this.streamMemento = inputStream.createStreamMemento();
        if (this.fragmentStack != null) {
            this.fragmentStack.clear();
        }
    }

    public void fragmentationOccured(ByteBufferWithInfo newFragment) {
        if (!this.markEngaged) {
            return;
        }
        if (this.fragmentStack == null) {
            this.fragmentStack = new LinkedList();
        }
        this.fragmentStack.addFirst(new ByteBufferWithInfo(newFragment));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (!this.markEngaged) {
            return;
        }
        this.markEngaged = false;
        if (this.fragmentStack != null && this.fragmentStack.size() != 0) {
            BufferQueue bufferQueue = this.fragmentQueue;
            synchronized (bufferQueue) {
                for (ByteBufferWithInfo bbwi : this.fragmentStack) {
                    this.fragmentQueue.push(bbwi);
                }
            }
            this.fragmentStack.clear();
        }
        this.inputStream.restoreInternalState(this.streamMemento);
    }

    public MarkAndResetHandler getMarkAndResetHandler() {
        return this;
    }
}

