/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.io;

import com.sun.corba.ee.impl.io.ObjectStreamField;
import com.sun.corba.ee.impl.orbutil.DprintUtil;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.ValueOutputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public abstract class OutputStreamHook
extends ObjectOutputStream {
    protected final DprintUtil dputil = new DprintUtil(this);
    private HookPutFields putFields = null;
    private com.sun.corba.ee.spi.orb.ORB sunORB = null;
    private boolean sfvDebug = false;
    private boolean vhDebug = false;
    protected byte streamFormatVersion = 1;
    protected WriteObjectState writeObjectState = NOT_IN_WRITE_OBJECT;
    protected static final WriteObjectState NOT_IN_WRITE_OBJECT = new DefaultState();
    protected static final WriteObjectState IN_WRITE_OBJECT = new InWriteObjectState();
    protected static final WriteObjectState WROTE_DEFAULT_DATA = new WroteDefaultDataState();
    protected static final WriteObjectState WROTE_CUSTOM_DATA = new WroteCustomDataState();

    protected void setORB(ORB orb) {
        if (orb instanceof com.sun.corba.ee.spi.orb.ORB) {
            this.sunORB = (com.sun.corba.ee.spi.orb.ORB)orb;
            this.sfvDebug = this.sunORB.streamFormatVersionDebugFlag;
            this.vhDebug = this.sunORB.valueHandlerDebugFlag;
        }
    }

    protected boolean streamFormatVersionDebug() {
        return this.sfvDebug;
    }

    protected boolean valueHandlerDebug() {
        return this.vhDebug;
    }

    abstract void writeField(ObjectStreamField var1, Object var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defaultWriteObject() throws IOException {
        if (this.sunORB.streamFormatVersionDebugFlag) {
            this.dputil.enter("defaultWriteObject", new Object[0]);
        }
        try {
            this.writeObjectState.defaultWriteObject(this);
            this.defaultWriteObjectDelegate();
        }
        finally {
            if (this.sunORB.streamFormatVersionDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    public abstract void defaultWriteObjectDelegate();

    public ObjectOutputStream.PutField putFields() throws IOException {
        this.putFields = new HookPutFields();
        return this.putFields;
    }

    public byte getStreamFormatVersion() {
        return this.streamFormatVersion;
    }

    abstract ObjectStreamField[] getFieldsNoCopy();

    public void writeFields() throws IOException {
        this.writeObjectState.defaultWriteObject(this);
        this.putFields.write(this);
    }

    public abstract OutputStream getOrbStream();

    protected abstract void beginOptionalCustomData();

    protected void setState(WriteObjectState newState) {
        if (this.sunORB.streamFormatVersionDebugFlag) {
            this.dputil.enter("setState", "newState", newState);
        }
        this.writeObjectState = newState;
        if (this.sunORB.streamFormatVersionDebugFlag) {
            this.dputil.exit();
        }
    }

    protected static class WroteCustomDataState
    extends InWriteObjectState {
        protected WroteCustomDataState() {
        }

        public void exitWriteObjectOverride(OutputStreamHook stream) throws IOException {
            if (stream.getStreamFormatVersion() == 2) {
                ((ValueOutputStream)stream.getOrbStream()).end_value();
            }
            stream.setState(NOT_IN_WRITE_OBJECT);
        }

        public void defaultWriteObjectOverride(OutputStreamHook stream) throws IOException {
            throw new IOException("Cannot call defaultWriteObject/writeFields after writing custom data in RMI-IIOP");
        }

        public void writeDataOverride(OutputStreamHook stream) throws IOException {
        }
    }

    protected static class WroteDefaultDataState
    extends InWriteObjectState {
        protected WroteDefaultDataState() {
        }

        public void exitWriteObjectOverride(OutputStreamHook stream) throws IOException {
            if (stream.getStreamFormatVersion() == 2) {
                stream.getOrbStream().write_long(0);
            }
            stream.setState(NOT_IN_WRITE_OBJECT);
        }

        public void defaultWriteObjectOverride(OutputStreamHook stream) throws IOException {
            throw new IOException("Called defaultWriteObject/writeFields twice");
        }

        public void writeDataOverride(OutputStreamHook stream) throws IOException {
            stream.beginOptionalCustomData();
            stream.setState(WROTE_CUSTOM_DATA);
        }
    }

    protected static class InWriteObjectState
    extends WriteObjectState {
        protected InWriteObjectState() {
        }

        public void enterWriteObjectOverride(OutputStreamHook stream) throws IOException {
            throw new IOException("Internal state failure: Entered writeObject twice");
        }

        public void exitWriteObjectOverride(OutputStreamHook stream) throws IOException {
            stream.getOrbStream().write_boolean(false);
            if (stream.getStreamFormatVersion() == 2) {
                stream.getOrbStream().write_long(0);
            }
            stream.setState(NOT_IN_WRITE_OBJECT);
        }

        public void defaultWriteObjectOverride(OutputStreamHook stream) throws IOException {
            stream.getOrbStream().write_boolean(true);
            stream.setState(WROTE_DEFAULT_DATA);
        }

        public void writeDataOverride(OutputStreamHook stream) throws IOException {
            stream.getOrbStream().write_boolean(false);
            stream.beginOptionalCustomData();
            stream.setState(WROTE_CUSTOM_DATA);
        }
    }

    protected static class DefaultState
    extends WriteObjectState {
        protected DefaultState() {
        }

        public void enterWriteObjectOverride(OutputStreamHook stream) throws IOException {
            stream.setState(IN_WRITE_OBJECT);
        }
    }

    protected static class WriteObjectState {
        private final DprintUtil dputil = new DprintUtil(this);
        private final String name;

        public WriteObjectState() {
            String className = this.getClass().getName();
            int index = className.indexOf(36);
            this.name = className.substring(index + 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void enterWriteObject(OutputStreamHook stream) throws IOException {
            if (stream.streamFormatVersionDebug()) {
                this.dputil.enter("enterWriteObject", new Object[0]);
            }
            try {
                this.enterWriteObjectOverride(stream);
            }
            finally {
                if (stream.streamFormatVersionDebug()) {
                    this.dputil.exit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void exitWriteObject(OutputStreamHook stream) throws IOException {
            if (stream.streamFormatVersionDebug()) {
                this.dputil.enter("exitWriteObject", new Object[0]);
            }
            try {
                this.exitWriteObjectOverride(stream);
            }
            finally {
                if (stream.streamFormatVersionDebug()) {
                    this.dputil.exit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void defaultWriteObject(OutputStreamHook stream) throws IOException {
            if (stream.streamFormatVersionDebug()) {
                this.dputil.enter("defaultWriteObject", new Object[0]);
            }
            try {
                this.defaultWriteObjectOverride(stream);
            }
            finally {
                if (stream.streamFormatVersionDebug()) {
                    this.dputil.exit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void writeData(OutputStreamHook stream) throws IOException {
            if (stream.streamFormatVersionDebug()) {
                this.dputil.enter("writeData", new Object[0]);
            }
            try {
                this.writeDataOverride(stream);
            }
            finally {
                if (stream.streamFormatVersionDebug()) {
                    this.dputil.exit();
                }
            }
        }

        public void enterWriteObjectOverride(OutputStreamHook stream) throws IOException {
        }

        public void exitWriteObjectOverride(OutputStreamHook stream) throws IOException {
        }

        public void defaultWriteObjectOverride(OutputStreamHook stream) throws IOException {
        }

        public void writeDataOverride(OutputStreamHook stream) throws IOException {
        }

        public String toString() {
            return this.name;
        }
    }

    private class HookPutFields
    extends ObjectOutputStream.PutField {
        private Map<String, Object> fields = new HashMap<String, Object>();

        private HookPutFields() {
        }

        public void put(String name, boolean value) {
            this.fields.put(name, value);
        }

        public void put(String name, char value) {
            this.fields.put(name, Character.valueOf(value));
        }

        public void put(String name, byte value) {
            this.fields.put(name, value);
        }

        public void put(String name, short value) {
            this.fields.put(name, value);
        }

        public void put(String name, int value) {
            this.fields.put(name, value);
        }

        public void put(String name, long value) {
            this.fields.put(name, value);
        }

        public void put(String name, float value) {
            this.fields.put(name, Float.valueOf(value));
        }

        public void put(String name, double value) {
            this.fields.put(name, value);
        }

        public void put(String name, Object value) {
            this.fields.put(name, value);
        }

        public void write(ObjectOutput out) throws IOException {
            OutputStreamHook hook = (OutputStreamHook)out;
            ObjectStreamField[] osfields = hook.getFieldsNoCopy();
            for (int i = 0; i < osfields.length; ++i) {
                Object value = this.fields.get(osfields[i].getName());
                hook.writeField(osfields[i], value);
            }
        }
    }
}

