/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.pept.transport.ByteBufferPool;
import com.sun.corba.ee.spi.orb.ORB;
import java.nio.ByteBuffer;

public class ByteBufferPoolImpl
implements ByteBufferPool {
    private static final ORBUtilSystemException wrapper = ORB.getStaticLogWrapperTable().get_RPC_TRANSPORT_ORBUtil();
    private ByteBuffer byteBufferSlab;
    private final boolean useDirectBuffers;
    private final int byteBufferSlabSize;
    private final ORB orb;

    public ByteBufferPoolImpl(ORB orb) {
        this.orb = orb;
        boolean bl = this.useDirectBuffers = !this.orb.getORBData().disableDirectByteBufferUse();
        if (this.useDirectBuffers) {
            this.byteBufferSlabSize = orb.getORBData().getPooledDirectByteBufferSlabSize();
            this.byteBufferSlab = this.allocateDirectByteBufferSlab();
        } else {
            this.byteBufferSlabSize = -1;
            this.byteBufferSlab = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getByteBuffer(int size) {
        if (this.useDirectBuffers) {
            if (size > this.byteBufferSlabSize) {
                return ByteBuffer.allocate(size);
            }
            ByteBufferPoolImpl byteBufferPoolImpl = this;
            synchronized (byteBufferPoolImpl) {
                if (this.byteBufferSlab == null || this.byteBufferSlab.capacity() - this.byteBufferSlab.limit() < size) {
                    this.byteBufferSlab = this.allocateDirectByteBufferSlab();
                }
                this.byteBufferSlab.limit(this.byteBufferSlab.position() + size);
                ByteBuffer view = this.byteBufferSlab.slice();
                this.byteBufferSlab.position(this.byteBufferSlab.limit());
                return view;
            }
        }
        return ByteBuffer.allocate(size);
    }

    public void releaseByteBuffer(ByteBuffer buffer) {
    }

    public int activeCount() {
        return 0;
    }

    public ByteBuffer reAllocate(ByteBuffer oldByteBuffer, int minimumSize) {
        int size;
        for (size = this.orb.getORBData().getReadByteBufferSize(); size <= minimumSize; size *= 2) {
        }
        if (size > this.orb.getORBData().getMaxReadByteBufferSizeThreshold()) {
            if (minimumSize > this.orb.getORBData().getMaxReadByteBufferSizeThreshold()) {
                throw wrapper.maximumReadByteBufferSizeExceeded(this.orb.getORBData().getMaxReadByteBufferSizeThreshold(), size, "com.sun.corba.ee.transport.ORBMaximumReadByteBufferSize");
            }
            size = minimumSize;
        }
        ByteBuffer newByteBuffer = this.getByteBuffer(size);
        newByteBuffer.put(oldByteBuffer);
        return newByteBuffer;
    }

    private ByteBuffer allocateDirectByteBufferSlab() {
        return ByteBuffer.allocateDirect(this.byteBufferSlabSize);
    }
}

