/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.util.LocalStringManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.appclient.client.acc.ACCClassLoader;
import org.glassfish.appclient.client.acc.ACCModulesManager;
import org.glassfish.appclient.client.acc.FacadeLaunchable;
import org.glassfish.appclient.client.acc.UndeployedLaunchable;
import org.glassfish.appclient.client.acc.UserError;
import org.jvnet.hk2.component.Habitat;
import org.xml.sax.SAXParseException;

interface Launchable {
    public Class getMainClass() throws ClassNotFoundException;

    public ApplicationClientDescriptor getDescriptor(ClassLoader var1) throws IOException, SAXParseException;

    public void validateDescriptor();

    public URI getURI();

    public String getAnchorDir();

    public static class MainClass
    implements Launchable {
        private final Class mainClass;
        private ApplicationClientDescriptor acDesc = null;
        private ClassLoader classLoader = null;
        private AppClientArchivist archivist = null;

        MainClass(Class mainClass) {
            this.mainClass = mainClass;
        }

        public Class getMainClass() throws ClassNotFoundException {
            return this.mainClass;
        }

        public ApplicationClientDescriptor getDescriptor(ClassLoader loader) throws IOException, SAXParseException {
            if (this.acDesc == null) {
                this.archivist = new AppClientArchivist();
                this.acDesc = this.archivist.getDefaultBundleDescriptor();
                this.archivist.setDescriptor((RootDeploymentDescriptor)this.acDesc);
                this.classLoader = loader;
            }
            return this.acDesc;
        }

        public void validateDescriptor() {
            this.archivist.validate(this.classLoader);
        }

        public URI getURI() {
            return null;
        }

        public String getAnchorDir() {
            return null;
        }
    }

    public static class LaunchableUtil {
        private static final LocalStringManager localStrings = new LocalStringManagerImpl(LaunchableUtil.class);

        static Launchable newLaunchable(URI uri, String callerSuppliedMainClassName, String callerSuppliedAppName, Habitat habitat) throws IOException, BootException, URISyntaxException, XMLStreamException, SAXParseException, UserError {
            ArchiveFactory af = ACCModulesManager.getComponent(ArchiveFactory.class);
            ReadableArchive ra = null;
            try {
                ra = af.openArchive(uri);
            }
            catch (IOException e) {
                String msg = localStrings.getLocalString(Launchable.class, "appclient.cannotFindJarFile", "Could not locate the requested client JAR file {0}; please try again with an existing, valid client JAR", new Object[]{uri});
                throw new UserError(msg);
            }
            Launchable result = FacadeLaunchable.newFacade(habitat, ra, callerSuppliedMainClassName, callerSuppliedAppName);
            if (result != null) {
                ra.close();
            } else {
                result = UndeployedLaunchable.newUndeployedLaunchable(ra, callerSuppliedMainClassName, callerSuppliedAppName, Thread.currentThread().getContextClassLoader());
            }
            if (result != null) {
                URL clientOrFacadeURL = new URL("file:" + result.getURI().getSchemeSpecificPart());
                ACCClassLoader.instance().appendURL(clientOrFacadeURL);
                return result;
            }
            String msg = localStrings.getLocalString(Launchable.class, "appclient.invalidArchive", "The location {0} could not be opened as an archive; an app client or an enterprise app was expected", new Object[]{uri});
            throw new UserError(msg);
        }

        static Launchable newLaunchable(Class mainClass) {
            return new MainClass(mainClass);
        }

        static boolean matchesMainClassName(ReadableArchive archive, String callerSpecifiedMainClassName) throws IOException {
            return callerSpecifiedMainClassName != null && archive.exists(LaunchableUtil.classNameToArchivePath(callerSpecifiedMainClassName));
        }

        static boolean matchesName(URI groupFacadeURI, ReadableArchive clientFacadeArchive, String appClientName) throws IOException, SAXParseException {
            ApplicationClientDescriptor acd = null;
            AppClientArchivist archivist = new AppClientArchivist();
            acd = (ApplicationClientDescriptor)archivist.open(clientFacadeArchive);
            String moduleID = acd.getModuleID();
            if (moduleID.endsWith(".jar")) {
                moduleID = LaunchableUtil.deriveModuleID(groupFacadeURI, clientFacadeArchive.getURI());
            }
            String displayName = acd.getDisplayName();
            return moduleID != null && moduleID.equals(appClientName) || displayName != null && displayName.equals(appClientName);
        }

        private static String classNameToArchivePath(String className) {
            return className.replace('.', '/') + ".class";
        }

        private static String deriveModuleID(URI groupFacadeURI, URI clientArchiveURI) {
            URI dirURI = LaunchableUtil.stripDotJar(groupFacadeURI);
            URI clientArchiveRelativeURI = LaunchableUtil.stripDotJar(dirURI.relativize(URI.create("file:" + clientArchiveURI.getRawSchemeSpecificPart())));
            return clientArchiveRelativeURI.getRawSchemeSpecificPart();
        }

        private static URI stripDotJar(URI uri) {
            String pathWithoutDotJar = uri.getRawSchemeSpecificPart();
            pathWithoutDotJar = pathWithoutDotJar.substring(0, pathWithoutDotJar.length() - ".jar".length());
            return URI.create("file:" + pathWithoutDotJar);
        }
    }
}

