/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.InterceptorDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.annotation.context.ManagedBeanContext;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedList;
import javax.annotation.ManagedBean;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ProcessingContext;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ManagedBeanHandler
extends AbstractHandler {
    public Class<? extends Annotation> getAnnotationType() {
        return ManagedBean.class;
    }

    public HandlerProcessingResult processAnnotation(AnnotationInfo element) throws AnnotationProcessorException {
        Method managedBeanAroundInvoke;
        AnnotatedElementHandler aeHandler = element.getProcessingContext().getHandler();
        if (aeHandler instanceof ManagedBeanContext) {
            return this.getDefaultProcessedResult();
        }
        ManagedBeanDescriptor managedBeanDesc = new ManagedBeanDescriptor();
        ManagedBean resourceAn = (ManagedBean)element.getAnnotation();
        String logicalName = resourceAn.value();
        if (!logicalName.equals("")) {
            managedBeanDesc.setName(logicalName);
        }
        Class managedBeanClass = (Class)element.getAnnotatedElement();
        managedBeanDesc.setBeanClassName(managedBeanClass.getName());
        Class[] interceptors = null;
        Annotation interceptorsAnn = this.getClassAnnotation(managedBeanClass, "javax.interceptor.Interceptors");
        if (interceptorsAnn != null) {
            try {
                Method m = interceptorsAnn.annotationType().getDeclaredMethod("value", new Class[0]);
                interceptors = (Class[])m.invoke((Object)interceptorsAnn, new Object[0]);
            }
            catch (Exception e) {
                AnnotationProcessorException ape = new AnnotationProcessorException(e.getMessage(), element);
                ape.initCause((Throwable)e);
                throw ape;
            }
        }
        if ((managedBeanAroundInvoke = this.getMethodForMethodAnnotation(managedBeanClass, "javax.interceptor.AroundInvoke")) != null) {
            LifecycleCallbackDescriptor desc = new LifecycleCallbackDescriptor();
            desc.setLifecycleCallbackClass(managedBeanClass.getName());
            desc.setLifecycleCallbackMethod(managedBeanAroundInvoke.getName());
            managedBeanDesc.addAroundInvokeDescriptor(desc);
        }
        if (aeHandler instanceof ResourceContainerContext) {
            ((ResourceContainerContext)aeHandler).addManagedBean(managedBeanDesc);
            ManagedBeanContext managedBeanContext = new ManagedBeanContext(managedBeanDesc);
            ProcessingContext procContext = element.getProcessingContext();
            procContext.pushHandler((AnnotatedElementHandler)managedBeanContext);
            procContext.getProcessor().process(procContext, new Class[]{managedBeanClass});
            if (interceptors != null) {
                LinkedList<InterceptorDescriptor> classInterceptorChain = new LinkedList<InterceptorDescriptor>();
                for (Class i : interceptors) {
                    InterceptorDescriptor nextInterceptor = new InterceptorDescriptor();
                    nextInterceptor.setInterceptorClassName(i.getName());
                    managedBeanContext.setInterceptorMode(nextInterceptor);
                    procContext.pushHandler((AnnotatedElementHandler)managedBeanContext);
                    procContext.getProcessor().process(procContext, new Class[]{i});
                    managedBeanContext.unsetInterceptorMode();
                    classInterceptorChain.add(nextInterceptor);
                    Method interceptorAroundInvoke = this.getMethodForMethodAnnotation(i, "javax.interceptor.AroundInvoke");
                    if (interceptorAroundInvoke == null) continue;
                    LifecycleCallbackDescriptor desc = new LifecycleCallbackDescriptor();
                    desc.setLifecycleCallbackClass(i.getName());
                    desc.setLifecycleCallbackMethod(interceptorAroundInvoke.getName());
                    nextInterceptor.addAroundInvokeDescriptor(desc);
                }
                managedBeanDesc.setClassInterceptorChain(classInterceptorChain);
            }
        }
        return this.getDefaultProcessedResult();
    }

    private Annotation getClassAnnotation(Class c, String annotationClassName) {
        for (Annotation next : c.getDeclaredAnnotations()) {
            if (!next.annotationType().getName().equals(annotationClassName)) continue;
            return next;
        }
        return null;
    }

    private Method getMethodForMethodAnnotation(Class c, String annotationClassName) {
        for (Method m : c.getDeclaredMethods()) {
            for (Annotation next : m.getDeclaredAnnotations()) {
                if (!next.annotationType().getName().equals(annotationClassName)) continue;
                return m;
            }
        }
        return null;
    }
}

