/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.TimestampLockingPolicy;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.DirectToFieldChangeRecord;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectChangeSet
implements Serializable,
org.eclipse.persistence.sessions.changesets.ObjectChangeSet {
    protected List<org.eclipse.persistence.sessions.changesets.ChangeRecord> changes;
    protected transient Map<String, ChangeRecord> attributesToChanges;
    protected boolean shouldBeDeleted;
    protected CacheKey cacheKey;
    protected transient Class classType;
    protected String className;
    protected boolean isNew;
    protected boolean isAggregate;
    protected Object oldKey;
    protected Object newKey;
    protected transient UnitOfWorkChangeSet unitOfWorkChangeSet;
    protected transient OptimisticLockingPolicy optimisticLockingPolicy;
    protected Object initialWriteLockValue;
    protected Object writeLockValue;
    protected boolean isInvalid;
    protected transient Object cloneObject;
    protected boolean hasVersionChange;
    protected Boolean shouldModifyVersionField;
    protected boolean hasCmpPolicyForcedUpdate;
    protected boolean hasChangesFromCascadeLocking;
    protected transient Set<String> deferredSet;
    protected int cacheSynchronizationType;
    protected transient CacheKey activeCacheKey;
    protected transient ClassDescriptor descriptor;

    public ObjectChangeSet() {
    }

    public ObjectChangeSet(Vector primaryKey, ClassDescriptor descriptor, Object cloneObject, UnitOfWorkChangeSet parent, boolean isNew) {
        this.cacheSynchronizationType = 0;
        this.cloneObject = cloneObject;
        this.isNew = isNew;
        this.shouldBeDeleted = false;
        if (primaryKey != null && !primaryKey.contains(null)) {
            this.cacheKey = new CacheKey(primaryKey);
        }
        this.classType = descriptor.getJavaClass();
        this.className = this.classType.getName();
        this.descriptor = descriptor;
        this.cacheSynchronizationType = descriptor.getCacheSynchronizationType();
        this.unitOfWorkChangeSet = parent;
        this.isAggregate = false;
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void clear() {
        this.shouldBeDeleted = false;
        this.setOldKey(null);
        this.setNewKey(null);
        this.changes = null;
        this.attributesToChanges = null;
    }

    public void addChange(ChangeRecord changeRecord) {
        if (changeRecord == null) {
            return;
        }
        String attributeName = changeRecord.getAttribute();
        Map attributeToChanges = this.getAttributesToChanges();
        List<org.eclipse.persistence.sessions.changesets.ChangeRecord> changes = this.getChanges();
        ChangeRecord existingChangeRecord = (ChangeRecord)attributeToChanges.get(attributeName);
        if (existingChangeRecord != null) {
            changes.remove(existingChangeRecord);
        }
        changes.add(changeRecord);
        attributeToChanges.put(attributeName, changeRecord);
        this.dirtyUOWChangeSet();
    }

    public void deferredDetectionRequiredOn(String attributeName) {
        this.getDeferredSet().add(attributeName);
    }

    public boolean containsChangesFromSynchronization() {
        return this.cacheSynchronizationType == 3 || this.cacheSynchronizationType == 1;
    }

    public boolean equals(Object object) {
        if (object instanceof ObjectChangeSet) {
            return this.equals((ObjectChangeSet)object);
        }
        return false;
    }

    @Override
    public boolean equals(org.eclipse.persistence.sessions.changesets.ObjectChangeSet objectChange) {
        if (this == objectChange) {
            return true;
        }
        if (this.getCacheKey() == null) {
            return false;
        }
        return this.getCacheKey().equals(((ObjectChangeSet)objectChange).getCacheKey());
    }

    public Map getAttributesToChanges() {
        if (this.attributesToChanges == null) {
            this.attributesToChanges = new HashMap<String, ChangeRecord>();
        }
        return this.attributesToChanges;
    }

    @Override
    public org.eclipse.persistence.sessions.changesets.ChangeRecord getChangesForAttributeNamed(String attributeName) {
        return (ChangeRecord)this.getAttributesToChanges().get(attributeName);
    }

    public CacheKey getCacheKey() {
        return this.cacheKey;
    }

    @Override
    public List<String> getChangedAttributeNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (org.eclipse.persistence.sessions.changesets.ChangeRecord changeRecord : this.getChanges()) {
            names.add(changeRecord.getAttribute());
        }
        return names;
    }

    @Override
    public List<org.eclipse.persistence.sessions.changesets.ChangeRecord> getChanges() {
        if (this.changes == null) {
            this.changes = new ArrayList<org.eclipse.persistence.sessions.changesets.ChangeRecord>();
        }
        return this.changes;
    }

    public Class getClassType() {
        return this.classType;
    }

    @Override
    public Class getClassType(Session session) {
        if (this.classType == null) {
            this.classType = (Class)((AbstractSession)session).getDatasourcePlatform().getConversionManager().convertObject(this.getClassName(), ClassConstants.CLASS);
        }
        return this.classType;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public Object getInitialWriteLockValue() {
        return this.initialWriteLockValue;
    }

    @Override
    public Object getOldKey() {
        return this.oldKey;
    }

    @Override
    public Object getNewKey() {
        return this.newKey;
    }

    @Override
    public Vector getPrimaryKeys() {
        if (this.getCacheKey() == null) {
            return null;
        }
        return this.getCacheKey().getKey();
    }

    public int getSynchronizationType() {
        return this.cacheSynchronizationType;
    }

    public Object getTargetVersionOfSourceObject(AbstractSession session) {
        return this.getTargetVersionOfSourceObject(session, false);
    }

    public Object getTargetVersionOfSourceObject(AbstractSession session, boolean shouldRead) {
        Object attributeValue = null;
        ClassDescriptor descriptor = this.getDescriptor();
        if (descriptor == null) {
            descriptor = session.getDescriptor(this.getClassType(session));
        }
        if (descriptor != null) {
            attributeValue = session.isUnitOfWork() ? (((UnitOfWorkImpl)session).getLifecycle() == 4 ? ((UnitOfWorkImpl)session).getOriginalVersionOfObjectOrNull(this.getUnitOfWorkClone(), this, descriptor) : this.getUnitOfWorkClone()) : session.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(this.getPrimaryKeys(), this.getClassType(session), descriptor);
            if (attributeValue == null && shouldRead) {
                ReadObjectQuery query = new ReadObjectQuery();
                query.setShouldUseWrapperPolicy(false);
                query.setReferenceClass(this.getClassType(session));
                query.setSelectionKey(this.getPrimaryKeys());
                attributeValue = session.executeQuery(query);
            }
        }
        return attributeValue;
    }

    public Object getUnitOfWorkClone() {
        return this.cloneObject;
    }

    @Override
    public org.eclipse.persistence.sessions.changesets.UnitOfWorkChangeSet getUOWChangeSet() {
        return this.unitOfWorkChangeSet;
    }

    @Override
    public Object getWriteLockValue() {
        return this.writeLockValue;
    }

    @Override
    public boolean hasChangeFor(String attributeName) {
        for (org.eclipse.persistence.sessions.changesets.ChangeRecord changeRecord : this.getChanges()) {
            if (!changeRecord.getAttribute().equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasChanges() {
        return this.isNew || this.hasVersionChange || this.changes != null && !this.changes.isEmpty();
    }

    public boolean hasForcedChanges() {
        return this.shouldModifyVersionField != null || this.hasCmpPolicyForcedUpdate;
    }

    public void setShouldModifyVersionField(Boolean shouldModifyVersionField) {
        this.shouldModifyVersionField = shouldModifyVersionField;
        if (shouldModifyVersionField != null && shouldModifyVersionField.booleanValue()) {
            this.hasVersionChange = true;
        }
    }

    public Boolean shouldModifyVersionField() {
        return this.shouldModifyVersionField;
    }

    public void setHasCmpPolicyForcedUpdate(boolean hasCmpPolicyForcedUpdate) {
        this.hasCmpPolicyForcedUpdate = hasCmpPolicyForcedUpdate;
    }

    public boolean hasCmpPolicyForcedUpdate() {
        return this.hasCmpPolicyForcedUpdate;
    }

    public boolean hasForcedChangesFromCascadeLocking() {
        return this.hasChangesFromCascadeLocking;
    }

    public void setHasForcedChangesFromCascadeLocking(boolean newValue) {
        this.setShouldModifyVersionField(Boolean.TRUE);
        this.hasChangesFromCascadeLocking = newValue;
    }

    public int hashCode() {
        if (this.getCacheKey() == null) {
            return System.identityHashCode(this);
        }
        return this.getCacheKey().hashCode();
    }

    public boolean hasKeys() {
        return this.newKey != null || this.oldKey != null;
    }

    public boolean isAggregate() {
        return this.isAggregate;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    public boolean isInvalid() {
        return this.isInvalid;
    }

    public void mergeObjectChanges(ObjectChangeSet changeSetToMergeFrom, UnitOfWorkChangeSet mergeToChangeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
        if (this == changeSetToMergeFrom || this.isInvalid()) {
            return;
        }
        if (changeSetToMergeFrom.optimisticLockingPolicy != null) {
            if (this.optimisticLockingPolicy == null) {
                this.optimisticLockingPolicy = changeSetToMergeFrom.optimisticLockingPolicy;
                this.initialWriteLockValue = changeSetToMergeFrom.initialWriteLockValue;
                this.writeLockValue = changeSetToMergeFrom.writeLockValue;
            } else {
                Object writeLockValueToCompare = this.writeLockValue;
                if (writeLockValueToCompare == null) {
                    writeLockValueToCompare = this.initialWriteLockValue;
                }
                if (this.optimisticLockingPolicy.compareWriteLockValues(writeLockValueToCompare, changeSetToMergeFrom.initialWriteLockValue) != 0) {
                    this.isInvalid = true;
                    return;
                }
                if (changeSetToMergeFrom.writeLockValue != null) {
                    this.writeLockValue = changeSetToMergeFrom.writeLockValue;
                }
            }
        }
        List<org.eclipse.persistence.sessions.changesets.ChangeRecord> changesToMerge = changeSetToMergeFrom.getChanges();
        int size = changesToMerge.size();
        for (int index = 0; index < size; ++index) {
            ChangeRecord record = (ChangeRecord)changesToMerge.get(index);
            ChangeRecord thisRecord = (ChangeRecord)this.getChangesForAttributeNamed(record.getAttribute());
            if (thisRecord == null) {
                record.updateReferences(mergeToChangeSet, mergeFromChangeSet);
                record.setOwner(this);
                this.addChange(record);
                continue;
            }
            thisRecord.mergeRecord(record, mergeToChangeSet, mergeFromChangeSet);
        }
        this.shouldBeDeleted = changeSetToMergeFrom.shouldBeDeleted;
        this.setOldKey(changeSetToMergeFrom.oldKey);
        this.setNewKey(changeSetToMergeFrom.newKey);
        this.hasVersionChange = changeSetToMergeFrom.hasVersionChange;
        this.shouldModifyVersionField = changeSetToMergeFrom.shouldModifyVersionField;
        this.hasCmpPolicyForcedUpdate = changeSetToMergeFrom.hasCmpPolicyForcedUpdate;
        this.hasChangesFromCascadeLocking = changeSetToMergeFrom.hasChangesFromCascadeLocking;
    }

    public void readCompleteChangeSet(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.readIdentityInformation(stream);
        this.changes = (List)stream.readObject();
        this.oldKey = stream.readObject();
        this.newKey = stream.readObject();
    }

    public void readIdentityInformation(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.cacheKey = (CacheKey)stream.readObject();
        this.className = (String)stream.readObject();
        this.writeLockValue = stream.readObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int cacheSyncType;
        this.cacheSynchronizationType = cacheSyncType = stream.read();
        this.shouldBeDeleted = stream.readBoolean();
        this.isInvalid = stream.readBoolean();
        this.isNew = stream.readBoolean();
        this.isAggregate = stream.readBoolean();
        if (this.shouldBeDeleted || cacheSyncType == 4 || cacheSyncType == 2) {
            this.readIdentityInformation(stream);
        } else {
            this.readCompleteChangeSet(stream);
        }
    }

    public void setCacheKey(CacheKey cacheKey) {
        this.cacheKey = cacheKey;
    }

    public void setChanges(List changesList) {
        this.changes = changesList;
        this.updateUOWChangeSet();
    }

    public void setClassType(Class newValue) {
        this.classType = newValue;
    }

    public void setClassName(String newValue) {
        this.className = newValue;
    }

    public void setIsAggregate(boolean isAggregate) {
        this.isAggregate = isAggregate;
    }

    protected void setIsNew(boolean newIsNew) {
        this.isNew = newIsNew;
    }

    public void setOldKey(Object key) {
        if (key == null || this.oldKey == null) {
            this.oldKey = key;
        }
    }

    public void setNewKey(Object key) {
        this.newKey = key;
    }

    public void setShouldBeDeleted(boolean newValue) {
        this.shouldBeDeleted = newValue;
    }

    public void setSynchronizationType(int type) {
        this.cacheSynchronizationType = type;
    }

    public void setUOWChangeSet(UnitOfWorkChangeSet newUnitOfWorkChangeSet) {
        this.unitOfWorkChangeSet = newUnitOfWorkChangeSet;
    }

    public void setOptimisticLockingPolicyAndInitialWriteLockValue(OptimisticLockingPolicy optimisticLockingPolicy, AbstractSession session) {
        if (optimisticLockingPolicy.supportsWriteLockValuesComparison()) {
            this.optimisticLockingPolicy = optimisticLockingPolicy;
            this.initialWriteLockValue = optimisticLockingPolicy.getWriteLockValue(this.cloneObject, this.getPrimaryKeys(), session);
        }
    }

    public void setWriteLockValue(Object newWriteLockValue) {
        this.writeLockValue = newWriteLockValue;
        this.hasVersionChange = true;
        this.updateUOWChangeSet();
    }

    public void setInitialWriteLockValue(Object initialWriteLockValue) {
        if (this.initialWriteLockValue == null) {
            this.initialWriteLockValue = initialWriteLockValue;
        }
    }

    public boolean shouldBeDeleted() {
        return this.shouldBeDeleted;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.getClassName() + ")" + this.getChanges().toString();
    }

    public void updateChangeRecordForAttribute(String attributeName, Object value) {
        ChangeRecord changeRecord = (ChangeRecord)this.getChangesForAttributeNamed(attributeName);
        if (changeRecord != null) {
            changeRecord.updateChangeRecordWithNewValue(value);
        }
    }

    public void updateChangeRecordForAttributeWithMappedObject(String attributeName, Object value, AbstractSession session) {
        ClassDescriptor descriptor;
        ObjectChangeSet referenceChangeSet = (ObjectChangeSet)this.getUOWChangeSet().getObjectChangeSetForClone(value);
        if (referenceChangeSet == null && (descriptor = session.getDescriptor(value.getClass())) != null) {
            referenceChangeSet = descriptor.getObjectBuilder().createObjectChangeSet(value, (UnitOfWorkChangeSet)this.getUOWChangeSet(), false, session);
        }
        this.updateChangeRecordForAttribute(attributeName, referenceChangeSet);
    }

    public void updateChangeRecordForAttribute(DatabaseMapping mapping, Object value, AbstractSession session) {
        String attributeName = mapping.getAttributeName();
        ChangeRecord changeRecord = (ChangeRecord)this.getChangesForAttributeNamed(attributeName);
        if (mapping.isDirectToFieldMapping()) {
            value = ((AbstractDirectMapping)mapping).getAttributeValue(value, session);
        }
        if (changeRecord != null) {
            changeRecord.updateChangeRecordWithNewValue(value);
        } else if (mapping.isDirectToFieldMapping()) {
            changeRecord = new DirectToFieldChangeRecord(this);
            changeRecord.setAttribute(attributeName);
            changeRecord.setMapping(mapping);
            ((DirectToFieldChangeRecord)changeRecord).setNewValue(value);
            this.addChange(changeRecord);
        }
    }

    public void updateReferences(UnitOfWorkChangeSet localChangeSet, UnitOfWorkChangeSet mergingChangeSet) {
        int size = this.getChanges().size();
        for (int index = 0; index < size; ++index) {
            ChangeRecord record = (ChangeRecord)this.getChanges().get(index);
            record.updateReferences(localChangeSet, mergingChangeSet);
            record.setOwner(this);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.write(this.cacheSynchronizationType);
        stream.writeBoolean(this.shouldBeDeleted);
        stream.writeBoolean(this.isInvalid);
        stream.writeBoolean(this.isNew);
        stream.writeBoolean(this.isAggregate);
        if (this.shouldBeDeleted || this.cacheSynchronizationType == 4 || this.cacheSynchronizationType == 2) {
            this.writeIdentityInformation(stream);
        } else {
            this.writeCompleteChangeSet(stream);
        }
    }

    public void writeIdentityInformation(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.cacheKey);
        stream.writeObject(this.className);
        stream.writeObject(this.writeLockValue);
    }

    public void writeCompleteChangeSet(ObjectOutputStream stream) throws IOException {
        if (this.isNew && (this.changes == null || this.changes.isEmpty())) {
            AbstractSession unitOfWork = this.unitOfWorkChangeSet.getSession();
            ClassDescriptor descriptor = this.getDescriptor();
            if (unitOfWork != null && descriptor != null) {
                Vector<DatabaseMapping> mappings = descriptor.getMappings();
                int mappingsSize = mappings.size();
                for (int index = 0; index < mappingsSize; ++index) {
                    DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
                    this.addChange(mapping.compareForChange(this.cloneObject, this.cloneObject, this, unitOfWork));
                }
            }
        }
        this.writeIdentityInformation(stream);
        stream.writeObject(this.changes);
        stream.writeObject(this.oldKey);
        stream.writeObject(this.newKey);
    }

    public void setPrimaryKeys(Vector key) {
        if (key == null) {
            return;
        }
        if (this.getCacheKey() == null) {
            this.setCacheKey(new CacheKey(key));
        } else {
            this.getCacheKey().setKey(key);
        }
    }

    public Set<String> getDeferredSet() {
        if (this.deferredSet == null) {
            this.deferredSet = new HashSet<String>();
        }
        return this.deferredSet;
    }

    public boolean hasDeferredAttributes() {
        return this.deferredSet != null && !this.deferredSet.isEmpty();
    }

    protected void dirtyUOWChangeSet() {
        UnitOfWorkChangeSet unitOfWorkChangeSet = (UnitOfWorkChangeSet)this.getUOWChangeSet();
        if (unitOfWorkChangeSet != null) {
            unitOfWorkChangeSet.setHasChanges(true);
        }
    }

    protected void updateUOWChangeSet() {
        if (this.getUOWChangeSet() != null) {
            ((UnitOfWorkChangeSet)this.getUOWChangeSet()).setHasChanges(this.hasChanges());
        }
    }

    protected void rebuildWriteLockValueFromUserFormat(ClassDescriptor descriptor, AbstractSession session) {
        if (descriptor.getOptimisticLockingPolicy() instanceof TimestampLockingPolicy) {
            this.writeLockValue = session.getPlatform(descriptor.getJavaClass()).getConversionManager().convertObject(this.writeLockValue, ClassConstants.JavaSqlTimestamp_Class);
        } else if (descriptor.getOptimisticLockingPolicy() instanceof VersionLockingPolicy) {
            this.writeLockValue = session.getPlatform(descriptor.getJavaClass()).getConversionManager().convertObject(this.writeLockValue, ClassConstants.BIGDECIMAL);
        }
    }

    public void removeChange(String attributeName) {
        org.eclipse.persistence.sessions.changesets.ChangeRecord record = this.getChangesForAttributeNamed(attributeName);
        if (record != null) {
            this.getChanges().remove(record);
            this.attributesToChanges.remove(attributeName);
        }
    }

    protected void removeFromIdentityMap(AbstractSession session) {
        session.getIdentityMapAccessor().removeFromIdentityMap(this.getPrimaryKeys(), this.getClassType(session));
    }

    public boolean shouldInvalidateObject(Object original, AbstractSession session) {
        if (this.optimisticLockingPolicy == null) {
            return false;
        }
        if (session.isRemoteSession()) {
            return false;
        }
        if (this.isInvalid()) {
            return true;
        }
        Object originalWriteLockValue = this.optimisticLockingPolicy.getWriteLockValue(original, this.getPrimaryKeys(), session);
        if (this.initialWriteLockValue == null) {
            return this.hasChanges();
        }
        return originalWriteLockValue != null && this.optimisticLockingPolicy.compareWriteLockValues(this.initialWriteLockValue, originalWriteLockValue) != 0;
    }

    public CacheKey getActiveCacheKey() {
        return this.activeCacheKey;
    }

    public void setActiveCacheKey(CacheKey activeCacheKey) {
        this.activeCacheKey = activeCacheKey;
    }
}

