/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence;

import com.sun.xml.ws.commons.Logger;
import com.sun.xml.ws.rx.rm.faults.AbstractSoapFaultException;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueueBuilder;
import com.sun.xml.ws.rx.rm.runtime.sequence.AbstractSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateMessageRegistrationException;
import com.sun.xml.ws.rx.rm.runtime.sequence.IllegalMessageIdentifierException;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceData;
import com.sun.xml.ws.rx.util.TimeSynchronizer;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InboundSequence
extends AbstractSequence {
    public static final long INITIAL_LAST_MESSAGE_ID = 0L;
    private static final Logger LOGGER = Logger.getLogger(InboundSequence.class);
    private final Set<Long> allUnackedMessageNumbers = new TreeSet<Long>();
    private final Set<Long> registeredUnackedMessageNumbers = new HashSet<Long>();

    public InboundSequence(SequenceData data, DeliveryQueueBuilder deliveryQueueBuilder, TimeSynchronizer timeSynchronizer) {
        super(data, deliveryQueueBuilder, timeSynchronizer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerMessage(ApplicationMessage message, boolean storeMessageFlag) throws DuplicateMessageRegistrationException, IllegalStateException {
        this.checkSequenceCreatedStatus("", AbstractSoapFaultException.Code.Receiver);
        if (!this.getId().equals(message.getSequenceId())) {
            throw new IllegalArgumentException(String.format("Cannot register message: sequence identifier on the application message [ %s ] is different from the identifier of this sequence [ %s ].", message.getSequenceId(), this.getId()));
        }
        try {
            this.data.lockWrite();
            if (message.getMessageNumber() > this.getLastMessageId()) {
                for (long lostIdentifier = this.getLastMessageId() + 1L; lostIdentifier <= message.getMessageNumber(); ++lostIdentifier) {
                    this.allUnackedMessageNumbers.add(lostIdentifier);
                }
                this.data.setLastMessageId(message.getMessageNumber());
            } else if (this.registeredUnackedMessageNumbers.contains(message.getMessageNumber())) {
                throw LOGGER.logException(new DuplicateMessageRegistrationException(this.getId(), message.getMessageNumber()), Level.FINE);
            }
            this.registeredUnackedMessageNumbers.add(message.getMessageNumber());
            if (storeMessageFlag) {
                this.storeMessage(message, this.getUnackedMessageIdentifierKey(message.getMessageNumber()));
            }
        }
        finally {
            this.data.unlockWrite();
        }
    }

    @Override
    Collection<Long> getUnackedMessageIdStorage() {
        return this.allUnackedMessageNumbers;
    }

    @Override
    public void acknowledgeMessageIds(List<Sequence.AckRange> ranges) {
        throw new UnsupportedOperationException(String.format("This operation is not supported on %s class", this.getClass().getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acknowledgeMessageId(long messageId) throws IllegalMessageIdentifierException, IllegalStateException {
        this.checkSequenceCreatedStatus(LocalizationMessages.WSRM_1135_WRONG_SEQUENCE_STATE_ACKNOWLEDGEMENT_REJECTED(this.getId(), (Object)this.getState()), AbstractSoapFaultException.Code.Receiver);
        try {
            this.data.lockWrite();
            if (!this.registeredUnackedMessageNumbers.remove(messageId)) {
                throw LOGGER.logSevereException(new IllegalMessageIdentifierException(this.getId(), messageId));
            }
            if (!this.allUnackedMessageNumbers.remove(messageId)) {
                throw LOGGER.logSevereException(new IllegalMessageIdentifierException(this.getId(), messageId));
            }
        }
        finally {
            this.data.unlockWrite();
        }
        this.getDeliveryQueue().onSequenceAcknowledgement();
    }

    private Long getUnackedMessageIdentifierKey(long messageNumber) {
        Long msgNumberKey2 = null;
        for (Long msgNumberKey2 : this.registeredUnackedMessageNumbers) {
            if (msgNumberKey2 == messageNumber) break;
        }
        return msgNumberKey2;
    }
}

