/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policyconv;

import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.policy.AlgorithmSuite;
import com.sun.xml.wss.impl.policy.mls.EncryptionTarget;
import java.util.logging.Level;
import javax.xml.namespace.QName;

public class EncryptionTargetCreator {
    public AlgorithmSuite algorithmSuite;
    public boolean enforce = false;

    public EncryptionTargetCreator(AlgorithmSuite algorithmSuite, boolean enforce) {
        this.algorithmSuite = algorithmSuite;
        this.enforce = enforce;
    }

    public EncryptionTarget newQNameEncryptionTarget(QName targetValue) {
        EncryptionTarget target = new EncryptionTarget();
        target.setEnforce(this.enforce);
        target.setDataEncryptionAlgorithm(this.algorithmSuite.getEncryptionAlgorithm());
        target.setType("qname");
        target.setQName(targetValue);
        target.setValue("{" + targetValue.getNamespaceURI() + "}" + targetValue.getLocalPart());
        target.setContentOnly(false);
        if (Constants.logger.isLoggable(Level.FINE)) {
            Constants.logger.log(Level.FINE, "QName Encryption Target with value " + target.getValue() + " has been added");
        }
        return target;
    }

    public EncryptionTarget newXpathEncryptionTarget(String xpathTarget) {
        EncryptionTarget target = new EncryptionTarget();
        target.setType("xpath");
        target.setValue(xpathTarget);
        target.setEnforce(this.enforce);
        target.setDataEncryptionAlgorithm(this.algorithmSuite.getEncryptionAlgorithm());
        target.setContentOnly(false);
        if (Constants.logger.isLoggable(Level.FINE)) {
            Constants.logger.log(Level.FINE, "XPath Encryption Target with value " + target.getValue() + " has been added");
        }
        return target;
    }

    public EncryptionTarget newURIEncryptionTarget(String uri) {
        EncryptionTarget target = new EncryptionTarget();
        target.setEnforce(this.enforce);
        target.setDataEncryptionAlgorithm(this.algorithmSuite.getEncryptionAlgorithm());
        target.setType("uri");
        target.setValue(uri);
        target.setContentOnly(false);
        if (Constants.logger.isLoggable(Level.FINE)) {
            Constants.logger.log(Level.FINE, "URI Encryption Target with value " + target.getValue() + " has been added");
        }
        return target;
    }

    public void addAttachmentTransform(EncryptionTarget target, String transformURI) {
        EncryptionTarget.Transform tr = target.newEncryptionTransform();
        tr.setTransform(transformURI);
        target.addCipherReferenceTransform(tr);
    }
}

