/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.amx;

import javax.management.ObjectName;

public final class AMXValues {
    public static final String ATTR_PARENT = "Parent";
    public static final String ATTR_CHILDREN = "Children";
    public static final String ATTR_NAME = "Name";
    public static final String TYPE_KEY = "type";
    public static final String NAME_KEY = "name";
    public static final String NO_NAME = "";
    public static final String PARENT_PATH_KEY = "pp";
    public static final String TYPE_FIELD = "AMX_TYPE";
    public static final String DESC_PREFIX = "amx.";
    public static final String NOTIFICATION_PREFIX = "amx.";
    public static final String DESC_STD_IMMUTABLE_INFO = "immutableInfo";
    public static final String DESC_STD_INTERFACE_NAME = "interfaceName";
    public static final String DESC_GENERIC_INTERFACE_NAME = "amx.genericInterfaceName";
    public static final String DESC_IS_SINGLETON = "amx.isSingleton";
    public static final String DESC_IS_GLOBAL_SINGLETON = "amx.isGlobalSingleton";
    public static final String DESC_GROUP = "amx.group";
    public static final String DESC_SUPPORTS_ADOPTION = "amx.supportsAdoption";
    public static final String DESC_SUB_TYPES = "amx.subTypes";
    public static final String GROUP_CONFIGURATION = "configuration";
    public static final String GROUP_MONITORING = "monitoring";
    public static final String GROUP_UTILITY = "utility";
    public static final String GROUP_JSR77 = "jsr77";
    public static final String GROUP_OTHER = "other";

    private AMXValues() {
    }

    public static String amxJMXDomain() {
        return "v3";
    }

    public static String dasName() {
        return "server";
    }

    public static String dasConfig() {
        return AMXValues.dasName() + "-config";
    }

    public static ObjectName domainRoot() {
        return AMXValues.newObjectName(NO_NAME, "domain-root", AMXValues.amxJMXDomain());
    }

    public static ObjectName monitoringRoot() {
        return AMXValues.newObjectName("/", "mon", null);
    }

    public static ObjectName serverMon(String serverName) {
        return AMXValues.newObjectName("/mon", "server-mon", serverName);
    }

    public static ObjectName getMBeanServerDelegateObjectName() {
        return AMXValues.newObjectName("JMImplementation", "type=MBeanServerDelegate");
    }

    public static String prop(String key, String value) {
        return key + "=" + value;
    }

    public static ObjectName newObjectName(String s) {
        try {
            return new ObjectName(s);
        }
        catch (Exception e) {
            throw new RuntimeException("bad ObjectName", e);
        }
    }

    public static ObjectName newObjectName(String pp, String type, String name) {
        String props = AMXValues.prop(PARENT_PATH_KEY, pp) + "," + AMXValues.prop(TYPE_KEY, type);
        if (name != null) {
            props = props + "," + AMXValues.prop(NAME_KEY, name);
        }
        return AMXValues.newObjectName(AMXValues.amxJMXDomain(), props);
    }

    public static ObjectName newObjectName(String domain, String props) {
        return AMXValues.newObjectName(domain + ":" + props);
    }
}

