/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.threadpool;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.threadpool.WorkQueueImpl;
import com.sun.corba.ee.impl.orbutil.threadpool.WorkerThreadNotNeededException;
import com.sun.corba.ee.spi.monitoring.LongMonitoredAttributeBase;
import com.sun.corba.ee.spi.monitoring.MonitoredObject;
import com.sun.corba.ee.spi.monitoring.MonitoringFactories;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.threadpool.NoSuchWorkQueueException;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPool;
import com.sun.corba.ee.spi.orbutil.threadpool.Work;
import com.sun.corba.ee.spi.orbutil.threadpool.WorkQueue;
import java.io.Closeable;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadPoolImpl
implements ThreadPool {
    private static AtomicInteger threadCounter = new AtomicInteger(0);
    private static final ORBUtilSystemException wrapper = ORB.getStaticLogWrapperTable().get_RPC_TRANSPORT_ORBUtil();
    private final WorkQueue workQueue;
    private int availableWorkerThreads = 0;
    private int currentThreadCount = 0;
    private final int minWorkerThreads;
    private final int maxWorkerThreads;
    private final long inactivityTimeout;
    private AtomicLong processedCount = new AtomicLong(1L);
    private AtomicLong totalTimeTaken = new AtomicLong(0L);
    private final String name;
    private MonitoredObject threadpoolMonitoredObject;
    private ThreadGroup threadGroup;
    private final ClassLoader workerThreadClassLoader;
    Object workersLock = new Object();
    List<WorkerThread> workers = new ArrayList<WorkerThread>();

    public ThreadPoolImpl(String threadpoolName) {
        this(Thread.currentThread().getThreadGroup(), threadpoolName);
    }

    public ThreadPoolImpl(ThreadGroup tg, String threadpoolName) {
        this(tg, threadpoolName, ThreadPoolImpl.getDefaultClassLoader());
    }

    public ThreadPoolImpl(ThreadGroup tg, String threadpoolName, ClassLoader defaultClassLoader) {
        this.inactivityTimeout = 120000L;
        this.minWorkerThreads = 0;
        this.maxWorkerThreads = Integer.MAX_VALUE;
        this.workQueue = new WorkQueueImpl(this);
        this.threadGroup = tg;
        this.name = threadpoolName;
        this.workerThreadClassLoader = defaultClassLoader;
        this.initializeMonitoring();
    }

    public ThreadPoolImpl(int minSize, int maxSize, long timeout, String threadpoolName) {
        this(minSize, maxSize, timeout, threadpoolName, ThreadPoolImpl.getDefaultClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPoolImpl(int minSize, int maxSize, long timeout, String threadpoolName, ClassLoader defaultClassLoader) {
        this.inactivityTimeout = timeout;
        this.minWorkerThreads = minSize;
        this.maxWorkerThreads = maxSize;
        this.workQueue = new WorkQueueImpl(this);
        this.threadGroup = Thread.currentThread().getThreadGroup();
        this.name = threadpoolName;
        this.workerThreadClassLoader = defaultClassLoader;
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            for (int i = 0; i < this.minWorkerThreads; ++i) {
                this.createWorkerThread();
            }
        }
        this.initializeMonitoring();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        ArrayList<WorkerThread> copy = null;
        Object object = this.workersLock;
        synchronized (object) {
            copy = new ArrayList<WorkerThread>(this.workers);
        }
        for (WorkerThread wt : copy) {
            wt.close();
            while (wt.getState() != Thread.State.TERMINATED) {
                try {
                    wt.join();
                }
                catch (InterruptedException exc) {
                    wrapper.interruptedJoinCallWhileClosingThreadPool(exc, (Object)wt, (Object)this);
                }
            }
        }
        this.threadGroup = null;
    }

    private static ClassLoader getDefaultClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        return cl;
    }

    private void initializeMonitoring() {
        MonitoredObject root = MonitoringFactories.getMonitoringManagerFactory().createMonitoringManager("orb", null).getRootMonitoredObject();
        MonitoredObject threadPoolMonitoringObjectRoot = root.getChild("threadpool");
        if (threadPoolMonitoringObjectRoot == null) {
            threadPoolMonitoringObjectRoot = MonitoringFactories.getMonitoredObjectFactory().createMonitoredObject("threadpool", "Monitoring for all ThreadPool instances");
            root.addChild(threadPoolMonitoringObjectRoot);
        }
        this.threadpoolMonitoredObject = MonitoringFactories.getMonitoredObjectFactory().createMonitoredObject(this.name, "Monitoring for a ThreadPool");
        threadPoolMonitoringObjectRoot.addChild(this.threadpoolMonitoredObject);
        LongMonitoredAttributeBase b1 = new LongMonitoredAttributeBase("currentNumberOfThreads", "Current number of total threads in the ThreadPool"){

            public Object getValue() {
                return (long)ThreadPoolImpl.this.currentNumberOfThreads();
            }
        };
        this.threadpoolMonitoredObject.addAttribute(b1);
        LongMonitoredAttributeBase b2 = new LongMonitoredAttributeBase("numberOfAvailableThreads", "Current number of total threads in the ThreadPool"){

            public Object getValue() {
                return (long)ThreadPoolImpl.this.numberOfAvailableThreads();
            }
        };
        this.threadpoolMonitoredObject.addAttribute(b2);
        LongMonitoredAttributeBase b3 = new LongMonitoredAttributeBase("numberOfBusyThreads", "Number of busy threads in the ThreadPool"){

            public Object getValue() {
                return (long)ThreadPoolImpl.this.numberOfBusyThreads();
            }
        };
        this.threadpoolMonitoredObject.addAttribute(b3);
        LongMonitoredAttributeBase b4 = new LongMonitoredAttributeBase("averageWorkCompletionTime", "Average elapsed time taken to complete a work item by the ThreadPool"){

            public Object getValue() {
                return ThreadPoolImpl.this.averageWorkCompletionTime();
            }
        };
        this.threadpoolMonitoredObject.addAttribute(b4);
        LongMonitoredAttributeBase b5 = new LongMonitoredAttributeBase("currentProcessedCount", "Number of Work items processed by the ThreadPool"){

            public Object getValue() {
                return ThreadPoolImpl.this.currentProcessedCount();
            }
        };
        this.threadpoolMonitoredObject.addAttribute(b5);
        this.threadpoolMonitoredObject.addChild(((WorkQueueImpl)this.workQueue).getMonitoredObject());
    }

    MonitoredObject getMonitoredObject() {
        return this.threadpoolMonitoredObject;
    }

    public WorkQueue getAnyWorkQueue() {
        return this.workQueue;
    }

    public WorkQueue getWorkQueue(int queueId) throws NoSuchWorkQueueException {
        if (queueId != 0) {
            throw new NoSuchWorkQueueException();
        }
        return this.workQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thread createWorkerThreadHelper(String name) {
        WorkerThread thread = new WorkerThread(this.threadGroup, name);
        Object object = this.workersLock;
        synchronized (object) {
            this.workers.add(thread);
        }
        thread.setDaemon(true);
        wrapper.workerThreadCreated(thread, thread.getContextClassLoader());
        thread.start();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createWorkerThread() {
        final String name = this.getName();
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            try {
                if (System.getSecurityManager() == null) {
                    this.createWorkerThreadHelper(name);
                } else {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return ThreadPoolImpl.this.createWorkerThreadHelper(name);
                        }
                    });
                }
            }
            catch (Throwable t) {
                this.decrementCurrentNumberOfThreads();
                wrapper.workerThreadCreationFailure(t);
            }
            finally {
                this.incrementCurrentNumberOfThreads();
            }
        }
    }

    public int minimumNumberOfThreads() {
        return this.minWorkerThreads;
    }

    public int maximumNumberOfThreads() {
        return this.maxWorkerThreads;
    }

    public long idleTimeoutForThreads() {
        return this.inactivityTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int currentNumberOfThreads() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            return this.currentThreadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrementCurrentNumberOfThreads() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            --this.currentThreadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementCurrentNumberOfThreads() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            ++this.currentThreadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numberOfAvailableThreads() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            return this.availableWorkerThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numberOfBusyThreads() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            return this.currentNumberOfThreads() - this.numberOfAvailableThreads();
        }
    }

    public long averageWorkCompletionTime() {
        return this.totalTimeTaken.get() / this.processedCount.get();
    }

    public long currentProcessedCount() {
        return this.processedCount.get();
    }

    public String getName() {
        return this.name;
    }

    public int numberOfWorkQueues() {
        return 1;
    }

    private static int getUniqueThreadId() {
        return threadCounter.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrementNumberOfAvailableThreads() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            --this.availableWorkerThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementNumberOfAvailableThreads() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            ++this.availableWorkerThreads;
        }
    }

    private class WorkerThread
    extends Thread
    implements Closeable {
        private static final String THREAD_POOLNAME_PREFIX_STR = "p: ";
        private static final String WORKER_THREAD_NAME_PREFIX_STR = "; w: ";
        private static final String IDLE_STR = "Idle";
        private Work currentWork;
        private volatile boolean closeCalled;
        private String threadPoolName;

        WorkerThread(ThreadGroup tg, String threadPoolName) {
            super(tg, THREAD_POOLNAME_PREFIX_STR + threadPoolName + WORKER_THREAD_NAME_PREFIX_STR + ThreadPoolImpl.getUniqueThreadId());
            this.closeCalled = false;
            this.threadPoolName = threadPoolName;
            this.currentWork = null;
        }

        private void setClassLoader() {
            if (System.getSecurityManager() == null) {
                this.setClassLoaderHelper();
            } else {
                ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return WorkerThread.this.setClassLoaderHelper();
                    }
                });
            }
        }

        private ClassLoader setClassLoaderHelper() {
            Thread thr = Thread.currentThread();
            ClassLoader result = thr.getContextClassLoader();
            thr.setContextClassLoader(ThreadPoolImpl.this.workerThreadClassLoader);
            return result;
        }

        public synchronized void close() {
            this.closeCalled = true;
            this.interrupt();
        }

        private void resetClassLoader() {
            ClassLoader currentClassLoader = null;
            try {
                currentClassLoader = System.getSecurityManager() == null ? this.getContextClassLoader() : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return WorkerThread.this.getContextClassLoader();
                    }
                });
            }
            catch (SecurityException se) {
                throw wrapper.workerThreadGetContextClassloaderFailed(this, se);
            }
            if (ThreadPoolImpl.this.workerThreadClassLoader != currentClassLoader) {
                wrapper.workerThreadForgotClassloaderReset(this, currentClassLoader, ThreadPoolImpl.this.workerThreadClassLoader);
                try {
                    this.setClassLoader();
                    wrapper.workerThreadClassloaderReset(this, currentClassLoader, ThreadPoolImpl.this.workerThreadClassLoader);
                }
                catch (SecurityException se) {
                    wrapper.workerThreadResetContextClassloaderFailed(this, se);
                }
            }
        }

        private void performWork() {
            long start = System.currentTimeMillis();
            try {
                this.currentWork.doWork();
            }
            catch (Throwable t) {
                wrapper.workerThreadDoWorkThrowable(this, t);
            }
            long elapsedTime = System.currentTimeMillis() - start;
            ThreadPoolImpl.this.totalTimeTaken.addAndGet(elapsedTime);
            ThreadPoolImpl.this.processedCount.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!this.closeCalled) {
                    block20: {
                        try {
                            this.currentWork = ((WorkQueueImpl)ThreadPoolImpl.this.workQueue).requestWork(ThreadPoolImpl.this.inactivityTimeout);
                            if (this.currentWork == null) {
                            }
                            break block20;
                        }
                        catch (WorkerThreadNotNeededException toe) {
                            wrapper.workerThreadNotNeeded(this, ThreadPoolImpl.this.currentNumberOfThreads(), ThreadPoolImpl.this.minimumNumberOfThreads());
                            this.closeCalled = true;
                        }
                        catch (InterruptedException exc) {
                            wrapper.workQueueThreadInterrupted(exc, (Object)this.getName(), (Object)this.closeCalled);
                        }
                        catch (Throwable t) {
                            wrapper.workerThreadThrowableFromRequestWork(this, t, ThreadPoolImpl.this.workQueue.getName());
                        }
                        continue;
                    }
                    this.performWork();
                    this.currentWork = null;
                    this.resetClassLoader();
                }
            }
            catch (Throwable e) {
                wrapper.workerThreadCaughtUnexpectedThrowable(this, e);
            }
            finally {
                Object t = ThreadPoolImpl.this.workersLock;
                synchronized (t) {
                    ThreadPoolImpl.this.workers.remove(this);
                }
            }
        }
    }
}

