/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.interceptors;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.MessageBeanContainer;
import com.sun.ejb.containers.StatelessSessionContainer;
import com.sun.ejb.containers.interceptors.AroundInvokeChainImpl;
import com.sun.ejb.containers.interceptors.AroundInvokeInterceptor;
import com.sun.ejb.containers.interceptors.BeanAroundInvokeInterceptor;
import com.sun.ejb.containers.interceptors.BeanCallbackInterceptor;
import com.sun.ejb.containers.interceptors.CallbackChainImpl;
import com.sun.ejb.containers.interceptors.CallbackInterceptor;
import com.sun.ejb.containers.interceptors.CallbackInvocationContext;
import com.sun.ejb.containers.interceptors.RuntimeInterceptorDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.InterceptorDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EnterpriseBean;
import javax.interceptor.InvocationContext;
import org.glassfish.api.interceptor.InterceptorInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorManager {
    private BaseContainer container;
    private EjbDescriptor ejbDesc;
    private InterceptorInfo interceptorInfo;
    private ClassLoader loader;
    private Class beanClass;
    private String beanClassName;
    private Logger _logger;
    private Class[] interceptorClasses;
    private Class[] serializableInterceptorClasses;
    private Map<String, Integer> instanceIndexMap = new HashMap<String, Integer>();
    private boolean interceptorsExists;
    private String[] pre30LCMethodNames;
    private Class[] lcAnnotationClasses;
    private CallbackChainImpl[] callbackChain;
    private List<RuntimeInterceptorDescriptor> runtimeInterceptors = new ArrayList<RuntimeInterceptorDescriptor>();

    public InterceptorManager(Logger _logger, BaseContainer container, Class[] lcAnnotationClasses, String[] pre30LCMethodNames) throws Exception {
        this._logger = _logger;
        this.container = container;
        this.lcAnnotationClasses = lcAnnotationClasses;
        this.pre30LCMethodNames = pre30LCMethodNames;
        this.ejbDesc = container.getEjbDescriptor();
        this.loader = container.getClassLoader();
        this.beanClassName = this.ejbDesc.getEjbImplClassName();
        this.beanClass = this.loader.loadClass(this.beanClassName);
        this.buildEjbInterceptorChain();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "InterceptorManager: " + this.toString());
        }
    }

    public InterceptorManager(Logger _logger, ClassLoader classLoader, String className, InterceptorInfo interceptorInfo) throws Exception {
        this._logger = _logger;
        this.loader = classLoader;
        this.beanClassName = className;
        this.beanClass = this.loader.loadClass(this.beanClassName);
        this.interceptorInfo = interceptorInfo;
        this.buildInterceptorChain(interceptorInfo);
    }

    public Object[] createInterceptorInstances() {
        int newInstanceSize;
        int size = this.serializableInterceptorClasses.length + this.runtimeInterceptors.size();
        Object[] interceptors = new Object[size];
        for (Class clazz : this.serializableInterceptorClasses) {
            try {
                interceptors[index] = clazz.newInstance();
            }
            catch (IllegalAccessException illEx) {
                throw new RuntimeException(illEx);
            }
            catch (InstantiationException instEx) {
                throw new RuntimeException(instEx);
            }
        }
        int index = newInstanceSize;
        for (RuntimeInterceptorDescriptor systemInterceptor : this.runtimeInterceptors) {
            interceptors[index] = systemInterceptor.interceptorInstance;
            ++index;
        }
        return interceptors;
    }

    public void registerRuntimeInterceptor(Object o) {
        int index = this.serializableInterceptorClasses.length + this.runtimeInterceptors.size();
        boolean hasPostConstruct = false;
        RuntimeInterceptorDescriptor desc = new RuntimeInterceptorDescriptor();
        desc.index = index;
        desc.interceptorInstance = o;
        for (Method m : o.getClass().getDeclaredMethods()) {
            PostConstruct postConstruct = m.getAnnotation(PostConstruct.class);
            if (postConstruct == null) continue;
            desc.postConstructMethod = m;
            hasPostConstruct = true;
            break;
        }
        if (hasPostConstruct) {
            CallbackInterceptor ci = new CallbackInterceptor(desc.index, desc.postConstructMethod);
            this.callbackChain[LifecycleCallbackDescriptor.CallbackType.POST_CONSTRUCT.ordinal()].prependInterceptor(ci);
        }
        this.runtimeInterceptors.add(desc);
    }

    public InterceptorChain getAroundInvokeChain(MethodDescriptor mDesc, Method beanMethod) {
        ArrayList<AroundInvokeInterceptor> interceptors = new ArrayList<AroundInvokeInterceptor>();
        if (this.ejbDesc != null) {
            for (EjbInterceptor interceptor : this.ejbDesc.getFrameworkInterceptors()) {
                Set aroundInvokeDescs = interceptor.getAroundInvokeDescriptors();
                if (aroundInvokeDescs.isEmpty()) continue;
                List orderedAIInterceptors = null;
                Class interceptorClass = interceptor.getInterceptorClass();
                ClassLoader classLoaderToUse = interceptorClass != null ? interceptorClass.getClassLoader() : this.loader;
                try {
                    orderedAIInterceptors = interceptor.getOrderedAroundInvokeDescriptors(classLoaderToUse);
                }
                catch (Exception e) {
                    throw new IllegalStateException("No AroundInvokeIntercetpors found  on class " + interceptor.getInterceptorClassName(), e);
                }
                this.addAroundInvokeInterceptors(interceptors, (InterceptorDescriptor)interceptor, orderedAIInterceptors, interceptor.getInterceptorClassName(), classLoaderToUse);
            }
        }
        List list = this.ejbDesc != null ? this.ejbDesc.getAroundInvokeInterceptors(mDesc) : this.interceptorInfo.getAroundInvokeInterceptors(beanMethod);
        for (InterceptorDescriptor interceptor : list) {
            String className = interceptor.getInterceptorClassName();
            Set aroundInvokeDescs = interceptor.getAroundInvokeDescriptors();
            if (aroundInvokeDescs.isEmpty()) continue;
            ArrayList<LifecycleCallbackDescriptor> orderedAIInterceptors = new ArrayList();
            try {
                orderedAIInterceptors = interceptor.getOrderedAroundInvokeDescriptors(this.loader);
            }
            catch (Exception e) {
                throw new IllegalStateException("No AroundInvokeIntercetpors found  on class " + className, e);
            }
            this.addAroundInvokeInterceptors(interceptors, interceptor, orderedAIInterceptors, className, this.loader);
        }
        AroundInvokeInterceptor[] inter = interceptors.toArray(new AroundInvokeInterceptor[interceptors.size()]);
        return new AroundInvokeChainImpl(inter);
    }

    public InterceptorChain getAroundTimeoutChain(MethodDescriptor mDesc, Method beanMethod) {
        ArrayList<AroundInvokeInterceptor> interceptors = new ArrayList<AroundInvokeInterceptor>();
        if (this.ejbDesc != null) {
            for (EjbInterceptor interceptor : this.ejbDesc.getFrameworkInterceptors()) {
                Set aroundTimeoutDescs = interceptor.getAroundTimeoutDescriptors();
                if (aroundTimeoutDescs.isEmpty()) continue;
                List orderedAIInterceptors = null;
                Class interceptorClass = interceptor.getInterceptorClass();
                ClassLoader classLoaderToUse = interceptorClass != null ? interceptorClass.getClassLoader() : this.loader;
                try {
                    orderedAIInterceptors = interceptor.getOrderedAroundTimeoutDescriptors(classLoaderToUse);
                }
                catch (Exception e) {
                    throw new IllegalStateException("No AroundTimeoutIntercetpors found  on class " + interceptor.getInterceptorClassName(), e);
                }
                this.addAroundInvokeInterceptors(interceptors, (InterceptorDescriptor)interceptor, orderedAIInterceptors, interceptor.getInterceptorClassName(), classLoaderToUse);
            }
        }
        List list = this.ejbDesc.getAroundTimeoutInterceptors(mDesc);
        for (EjbInterceptor interceptor : list) {
            String className = interceptor.getInterceptorClassName();
            Set aroundTimeoutDescs = interceptor.getAroundTimeoutDescriptors();
            if (aroundTimeoutDescs.isEmpty()) continue;
            ArrayList<LifecycleCallbackDescriptor> orderedATInterceptors = new ArrayList();
            try {
                orderedATInterceptors = interceptor.getOrderedAroundTimeoutDescriptors(this.loader);
            }
            catch (Exception e) {
                throw new IllegalStateException("No AroundTimeoutIntercetpors found  on class " + className, e);
            }
            this.addAroundInvokeInterceptors(interceptors, (InterceptorDescriptor)interceptor, orderedATInterceptors, className, this.loader);
        }
        AroundInvokeInterceptor[] inter = interceptors.toArray(new AroundInvokeInterceptor[interceptors.size()]);
        return new AroundInvokeChainImpl(inter);
    }

    private void addAroundInvokeInterceptors(List<AroundInvokeInterceptor> interceptors, InterceptorDescriptor interceptor, List<LifecycleCallbackDescriptor> orderedInterceptors, String className, ClassLoader classLoaderToUse) {
        for (LifecycleCallbackDescriptor desc : orderedInterceptors) {
            int index;
            Method method = null;
            try {
                method = desc.getLifecycleCallbackMethodObject(classLoaderToUse);
            }
            catch (Exception e) {
                throw new IllegalStateException("No callback method of name " + desc.getLifecycleCallbackMethod() + " found on class " + className, e);
            }
            if (interceptor.getFromBeanClass()) {
                interceptors.add(new BeanAroundInvokeInterceptor(method));
                continue;
            }
            Integer bigInt = this.instanceIndexMap.get(className);
            int n = index = bigInt == null ? -1 : bigInt;
            if (index == -1) {
                throw new IllegalStateException(this.getInternalErrorString(className));
            }
            Class clazz = this.interceptorClasses[index];
            this._logger.log(Level.FINE, "*[md.getDeclaredMethod() => " + method + " FOR CLAZZ: " + clazz);
            interceptors.add(new AroundInvokeInterceptor(index, method));
        }
    }

    public boolean hasInterceptors() {
        return this.interceptorsExists;
    }

    public Object intercept(InterceptorChain chain, AroundInvokeContext ctx) throws Throwable {
        return chain.invokeNext(0, ctx);
    }

    public boolean intercept(LifecycleCallbackDescriptor.CallbackType eventType, EJBContextImpl ctx) throws Throwable {
        return this.intercept(eventType, ctx.getEJB(), ctx.getInterceptorInstances());
    }

    public boolean intercept(LifecycleCallbackDescriptor.CallbackType eventType, Object targetObject, Object[] interceptorInstances) throws Throwable {
        CallbackChainImpl chain = null;
        switch (eventType) {
            case POST_CONSTRUCT: 
            case PRE_PASSIVATE: 
            case POST_ACTIVATE: 
            case PRE_DESTROY: {
                chain = this.callbackChain[eventType.ordinal()];
                CallbackInvocationContext invContext = new CallbackInvocationContext(targetObject, interceptorInstances, chain);
                if (chain == null) break;
                chain.invokeNext(0, invContext);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid event type");
            }
        }
        return true;
    }

    private void buildEjbInterceptorChain() throws Exception {
        HashSet<Class> listOfClasses = new HashSet<Class>();
        for (String name : this.ejbDesc.getInterceptorClassNames()) {
            listOfClasses.add(this.loader.loadClass(name));
        }
        for (EjbInterceptor frameworkInterceptor : this.ejbDesc.getFrameworkInterceptors()) {
            Class<?> clazz = frameworkInterceptor.getInterceptorClass();
            if (clazz == null) {
                clazz = this.loader.loadClass(frameworkInterceptor.getInterceptorClassName());
            }
            listOfClasses.add(clazz);
        }
        this.initInterceptorClasses(listOfClasses);
        this.interceptorsExists = listOfClasses.size() > 0 || this.ejbDesc.hasAroundInvokeMethod() || this.ejbDesc.hasAroundTimeoutMethod();
        this.initEjbCallbackIndices();
    }

    private void buildInterceptorChain(InterceptorInfo interceptorInfo) throws Exception {
        HashSet<Class> listOfClasses = new HashSet<Class>();
        for (String name : interceptorInfo.getInterceptorClassNames()) {
            listOfClasses.add(this.loader.loadClass(name));
        }
        this.initInterceptorClasses(listOfClasses);
        this.interceptorsExists = listOfClasses.size() > 0 || interceptorInfo.getHasTargetClassAroundInvoke();
        int size = LifecycleCallbackDescriptor.CallbackType.values().length;
        this.callbackChain = new CallbackChainImpl[size];
        this.initCallbackIndices(interceptorInfo.getPostConstructInterceptors(), LifecycleCallbackDescriptor.CallbackType.POST_CONSTRUCT);
        this.initCallbackIndices(interceptorInfo.getPreDestroyInterceptors(), LifecycleCallbackDescriptor.CallbackType.PRE_DESTROY);
    }

    private void initInterceptorClasses(Set<Class> classes) throws Exception {
        int size = classes.size();
        this.interceptorClasses = new Class[size];
        this.serializableInterceptorClasses = new Class[size];
        int index = 0;
        Iterator<Class> i$ = classes.iterator();
        while (i$.hasNext()) {
            Class interClass;
            this.interceptorClasses[index] = interClass = i$.next();
            this.serializableInterceptorClasses[index] = interClass;
            this.instanceIndexMap.put(interClass.getName(), index);
            if (!Serializable.class.isAssignableFrom(interClass)) {
                this.serializableInterceptorClasses[index] = EJBUtils.loadGeneratedSerializableClass(interClass.getClassLoader(), interClass.getName());
            }
            ++index;
        }
    }

    private void initEjbCallbackIndices() throws ClassNotFoundException, Exception {
        boolean lookForEjbCreateMethod;
        int size = LifecycleCallbackDescriptor.CallbackType.values().length;
        ArrayList[] callbacks = new ArrayList[size];
        boolean scanFor2xLifecycleMethods = true;
        for (LifecycleCallbackDescriptor.CallbackType eventType : LifecycleCallbackDescriptor.CallbackType.values()) {
            int index = eventType.ordinal();
            callbacks[index] = new ArrayList();
            boolean scanForCallbacks = true;
            if (!(this.ejbDesc instanceof EjbSessionDescriptor || eventType != LifecycleCallbackDescriptor.CallbackType.PRE_PASSIVATE && eventType != LifecycleCallbackDescriptor.CallbackType.POST_ACTIVATE)) {
                scanForCallbacks = false;
            }
            if (scanForCallbacks) {
                for (EjbInterceptor callback : this.ejbDesc.getFrameworkInterceptors()) {
                    if (!callback.hasCallbackDescriptor(eventType)) continue;
                    Class interceptorClass = callback.getInterceptorClass();
                    ClassLoader classLoaderToUse = interceptorClass != null ? interceptorClass.getClassLoader() : this.loader;
                    List<CallbackInterceptor> inters = this.createCallbackInterceptors(eventType, (InterceptorDescriptor)callback, classLoaderToUse);
                    for (CallbackInterceptor inter : inters) {
                        callbacks[index].add(inter);
                    }
                }
                List callbackList = this.ejbDesc.getCallbackInterceptors(eventType);
                for (EjbInterceptor callback : callbackList) {
                    List<CallbackInterceptor> inters = this.createCallbackInterceptors(eventType, (InterceptorDescriptor)callback);
                    for (CallbackInterceptor inter : inters) {
                        callbacks[index].add(inter);
                    }
                }
            }
            if (callbacks[index].size() <= 0) continue;
            scanFor2xLifecycleMethods = false;
        }
        if (scanFor2xLifecycleMethods) {
            this.load2xLifecycleMethods(callbacks);
        }
        boolean bl = lookForEjbCreateMethod = this.container instanceof StatelessSessionContainer || this.container instanceof MessageBeanContainer;
        if (lookForEjbCreateMethod) {
            this.loadOnlyEjbCreateMethod(callbacks);
        }
        this.callbackChain = new CallbackChainImpl[size];
        for (LifecycleCallbackDescriptor.CallbackType eventType : LifecycleCallbackDescriptor.CallbackType.values()) {
            int index = eventType.ordinal();
            CallbackInterceptor[] interceptors = callbacks[index].toArray(new CallbackInterceptor[callbacks[index].size()]);
            this.callbackChain[index] = new CallbackChainImpl(interceptors);
        }
    }

    private void initCallbackIndices(List<InterceptorDescriptor> callbackList, LifecycleCallbackDescriptor.CallbackType callbackType) throws Exception {
        int size = LifecycleCallbackDescriptor.CallbackType.values().length;
        ArrayList<CallbackInterceptor> callbacks = new ArrayList<CallbackInterceptor>();
        int index = callbackType.ordinal();
        for (InterceptorDescriptor callback : callbackList) {
            List<CallbackInterceptor> inters = this.createCallbackInterceptors(callbackType, callback);
            for (CallbackInterceptor inter : inters) {
                callbacks.add(inter);
            }
        }
        CallbackInterceptor[] interceptors = callbacks.toArray(new CallbackInterceptor[callbacks.size()]);
        this.callbackChain[index] = new CallbackChainImpl(interceptors);
    }

    private List<CallbackInterceptor> createCallbackInterceptors(LifecycleCallbackDescriptor.CallbackType eventType, InterceptorDescriptor inter) throws Exception {
        return this.createCallbackInterceptors(eventType, inter, this.loader);
    }

    private List<CallbackInterceptor> createCallbackInterceptors(LifecycleCallbackDescriptor.CallbackType eventType, InterceptorDescriptor inter, ClassLoader classLoaderToUse) throws Exception {
        ArrayList<CallbackInterceptor> callbackList = new ArrayList<CallbackInterceptor>();
        List orderedCallbackMethods = inter.getOrderedCallbackDescriptors(eventType, classLoaderToUse);
        String className = inter.getInterceptorClassName();
        for (LifecycleCallbackDescriptor callbackDesc : orderedCallbackMethods) {
            Method method = null;
            try {
                method = callbackDesc.getLifecycleCallbackMethodObject(classLoaderToUse);
            }
            catch (Exception e) {
                throw new IllegalStateException("No callback method of name " + callbackDesc.getLifecycleCallbackMethod() + " found on class " + className, e);
            }
            CallbackInterceptor interceptor = null;
            if (inter.getFromBeanClass()) {
                interceptor = new BeanCallbackInterceptor(method);
            } else {
                int index;
                Integer bigInt = this.instanceIndexMap.get(className);
                int n = index = bigInt == null ? -1 : bigInt;
                if (index == -1) {
                    throw new IllegalStateException(this.getInternalErrorString(className));
                }
                interceptor = new CallbackInterceptor(index, method);
            }
            callbackList.add(interceptor);
        }
        return callbackList;
    }

    private void load2xLifecycleMethods(ArrayList<CallbackInterceptor>[] metaArray) {
        if (EnterpriseBean.class.isAssignableFrom(this.beanClass)) {
            int sz = this.lcAnnotationClasses.length;
            for (int i = 0; i < sz; ++i) {
                if (this.pre30LCMethodNames[i] == null) continue;
                try {
                    Method method = this.beanClass.getMethod(this.pre30LCMethodNames[i], null);
                    if (method == null) continue;
                    BeanCallbackInterceptor meta = new BeanCallbackInterceptor(method);
                    metaArray[i].add(meta);
                    this._logger.log(Level.FINE, "**## bean has 2.x LM: " + meta);
                    continue;
                }
                catch (NoSuchMethodException nsmEx) {
                    // empty catch block
                }
            }
        }
    }

    private void loadOnlyEjbCreateMethod(ArrayList<CallbackInterceptor>[] metaArray) {
        int sz = this.lcAnnotationClasses.length;
        for (int i = 0; i < sz; ++i) {
            if (this.lcAnnotationClasses[i] != PostConstruct.class) continue;
            boolean needToScan = true;
            if (metaArray[i] != null) {
                ArrayList<CallbackInterceptor> al = metaArray[i];
                boolean bl = needToScan = al.size() == 0;
            }
            if (!needToScan) break;
            try {
                Method method = this.beanClass.getMethod(this.pre30LCMethodNames[i], null);
                if (method == null) continue;
                BeanCallbackInterceptor meta = new BeanCallbackInterceptor(method);
                metaArray[i].add(meta);
                this._logger.log(Level.FINE, "**##[ejbCreate] bean has 2.x style ejbCreate: " + meta);
                continue;
            }
            catch (NoSuchMethodException nsmEx) {
                // empty catch block
            }
        }
    }

    public String toString() {
        StringBuilder sbldr = new StringBuilder();
        sbldr.append("##########################################################\n");
        sbldr.append("InterceptorManager<").append(this.beanClassName).append("> has ").append(this.interceptorClasses.length).append(" interceptors");
        sbldr.append("\n\tbeanClassName: ").append(this.beanClassName);
        sbldr.append("\n\tInterceptors: ");
        for (Class clazz : this.interceptorClasses) {
            sbldr.append("\n\t\t").append(clazz.getName());
        }
        sbldr.append("\n\tCallback Interceptors: ");
        for (int i = 0; i < this.lcAnnotationClasses.length; ++i) {
            CallbackChainImpl chain = this.callbackChain[i];
            sbldr.append("\n\t").append(i).append(": ").append(this.lcAnnotationClasses[i]);
            sbldr.append("\n\t\t").append(chain.toString());
        }
        sbldr.append("\n");
        sbldr.append("##########################################################\n");
        return sbldr.toString();
    }

    private String getInternalErrorString(String className) {
        StringBuilder sbldr = new StringBuilder("Internal error: ");
        sbldr.append(" className: ").append(className).append(" is neither a bean class (").append(this.beanClassName).append(") nor an ").append("interceptor class (");
        for (Class cn : this.interceptorClasses) {
            sbldr.append(cn.getName()).append("; ");
        }
        sbldr.append(")");
        this._logger.log(Level.INFO, "++ : " + sbldr.toString());
        return sbldr.toString();
    }

    public static interface InterceptorChain {
        public Object invokeNext(int var1, AroundInvokeContext var2) throws Throwable;
    }

    public static interface AroundInvokeContext
    extends InvocationContext {
        public Object[] getInterceptorInstances();

        public Object invokeBeanMethod() throws Throwable;
    }
}

