/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.codegen;

import com.sun.corba.ee.impl.orbutil.codegen.ClassGenerator;
import com.sun.corba.ee.impl.orbutil.codegen.Identifier;
import com.sun.corba.ee.impl.orbutil.codegen.Node;
import com.sun.corba.ee.impl.orbutil.codegen.NodeBase;
import com.sun.corba.ee.impl.orbutil.codegen.Util;
import com.sun.corba.ee.impl.orbutil.codegen.Visitor;
import com.sun.corba.ee.spi.orbutil.codegen.ClassInfo;
import com.sun.corba.ee.spi.orbutil.codegen.Expression;
import com.sun.corba.ee.spi.orbutil.codegen.FieldInfo;
import com.sun.corba.ee.spi.orbutil.codegen.Signature;
import com.sun.corba.ee.spi.orbutil.codegen.Type;
import com.sun.corba.ee.spi.orbutil.codegen.Variable;
import com.sun.corba.ee.spi.orbutil.copyobject.Copy;
import com.sun.corba.ee.spi.orbutil.copyobject.CopyType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExpressionFactory {
    private final Node efparent;
    private final IdentityHashMap<Expression, Boolean> unusedExpressions;

    public final Node efparent() {
        return this.efparent;
    }

    public final IdentityHashMap<Expression, Boolean> unusedExpressions() {
        return this.unusedExpressions;
    }

    public ExpressionFactory(Node parent) {
        this.efparent = parent;
        this.unusedExpressions = new IdentityHashMap();
    }

    static List<Expression> copyExpressionList(Node newParent, List<Expression> exprs) {
        ArrayList<Expression> result = new ArrayList<Expression>();
        for (Expression expr : exprs) {
            result.add(expr.copy(newParent, Expression.class));
        }
        return result;
    }

    public Expression _null() {
        return new ConstantExpression(this, Type._null(), null);
    }

    public Expression _const(boolean c) {
        return new ConstantExpression(this, Type._boolean(), c);
    }

    public Expression _const(char c) {
        return new ConstantExpression(this, Type._char(), Character.valueOf(c));
    }

    public Expression _const(byte c) {
        return new ConstantExpression(this, Type._byte(), c);
    }

    public Expression _const(short c) {
        return new ConstantExpression(this, Type._short(), c);
    }

    public Expression _const(int c) {
        return new ConstantExpression(this, Type._int(), c);
    }

    public Expression _const(long c) {
        return new ConstantExpression(this, Type._long(), c);
    }

    public Expression _const(float c) {
        return new ConstantExpression(this, Type._float(), Float.valueOf(c));
    }

    public Expression _const(double c) {
        return new ConstantExpression(this, Type._double(), c);
    }

    public Expression _const(String c) {
        return new ConstantExpression(this, Type._String(), c);
    }

    public Expression _const(Type c) {
        return new ConstantExpression(this, Type._Class(), c);
    }

    public Expression _void() {
        return new VoidExpression(this);
    }

    public Expression _this() {
        return new ThisExpression(this);
    }

    public Expression call(Expression target, String ident, Signature signature, List<Expression> exprs) {
        signature.checkCompatibility(target.type(), ident, exprs);
        return new NonStaticCallExpression(this, target, ident, signature, exprs);
    }

    public Expression call(Expression target, String ident, List<Expression> exprs) {
        Signature sig = Signature.fromCall(target.type(), ident, exprs);
        return new NonStaticCallExpression(this, target, ident, sig, exprs);
    }

    public Expression staticCall(Type target, String ident, Signature signature, List<Expression> exprs) {
        signature.checkStaticCompatibility(target, ident, exprs);
        if (target.isPrimitive() || target.isArray()) {
            throw new IllegalArgumentException("The target for a static call must be a reference type");
        }
        return new StaticCallExpression(this, target, ident, signature, exprs);
    }

    public Expression staticCall(Type target, String ident, List<Expression> exprs) {
        if (target.isPrimitive() || target.isArray()) {
            throw new IllegalArgumentException("The target for a static call must be a reference type");
        }
        Signature sig = Signature.fromStaticCall(target, ident, exprs);
        return new StaticCallExpression(this, target, ident, sig, exprs);
    }

    public Expression unaryOp(UnaryOperator op, Expression expr) {
        return new UnaryOperatorExpression(this, op, expr);
    }

    public Expression binaryOperator(Expression left, BinaryOperator op, Expression right) {
        return op.create(this, left, right);
    }

    public Expression cast(Type type, Expression expr) {
        return new CastExpression(this, type, expr);
    }

    public Expression instof(Expression expr, Type type) {
        return new InstofExpression(this, expr, type);
    }

    public Expression newObj(Type type, Signature signature, List<Expression> args) {
        signature.checkConstructorCompatibility(type, args);
        return new NewObjExpression(this, type, signature, args);
    }

    public Expression newObj(Type type, List<Expression> exprs) {
        Signature signature = Signature.fromConstructor(type, exprs);
        return new NewObjExpression(this, type, signature, exprs);
    }

    public Expression newArrInit(Type type, List<Expression> exprs) {
        Expression size = this._const(exprs.size());
        return new NewArrExpression(this, type, size, exprs);
    }

    public Expression newArr(Type type, Expression size) {
        return new NewArrExpression(this, type, size, null);
    }

    public Expression superCall(String ident, Signature signature, List<Expression> exprs) {
        return new SuperCallExpression(this, ident, signature, exprs);
    }

    public Expression superCall(String ident, List<Expression> exprs) {
        ClassGenerator cg = this.efparent().getAncestor(ClassGenerator.class);
        if (cg == null) {
            throw new IllegalStateException("No ClassGenerator found!");
        }
        Type type = cg.superType();
        Signature signature = Signature.fromCall(type, ident, exprs);
        return new SuperCallExpression(this, ident, signature, exprs);
    }

    public Expression superObj(Signature signature, List<Expression> exprs) {
        return new SuperObjExpression(this, signature, exprs);
    }

    public Expression superObj(List<Expression> exprs) {
        ClassGenerator cg = this.efparent().getAncestor(ClassGenerator.class);
        if (cg == null) {
            throw new IllegalStateException("No ClassGenerator found!");
        }
        Type type = cg.superType();
        Signature signature = Signature.fromConstructor(type, exprs);
        return new SuperObjExpression(this, signature, exprs);
    }

    public Expression thisObj(Signature signature, List<Expression> exprs) {
        return new ThisObjExpression(this, signature, exprs);
    }

    public Expression thisObj(List<Expression> exprs) {
        ClassGenerator cg = this.efparent().getAncestor(ClassGenerator.class);
        if (cg == null) {
            throw new IllegalStateException("No ClassGenerator found!");
        }
        Type type = cg.thisType();
        Signature signature = Signature.fromConstructor(type, exprs);
        return new ThisObjExpression(this, signature, exprs);
    }

    public Expression fieldAccess(Expression target, String fieldName) {
        return new NonStaticFieldAccessExpression(this, target, fieldName);
    }

    public Expression fieldAccess(Type target, String fieldName) {
        return new StaticFieldAccessExpression(this, target, fieldName);
    }

    public Expression arrayIndex(Expression expr, Expression index) {
        return new ArrayIndexExpression(this, expr, index);
    }

    public Expression arrayLength(Expression expr) {
        return new ArrayLengthExpression(this, expr);
    }

    public Expression ifExpression(Expression condition, Expression truePart, Expression falsePart) {
        return new IfExpression(this, condition, truePart, falsePart);
    }

    public Variable variable(Type type, String ident) {
        return new VariableImpl(this, type, ident);
    }

    public static final class VariableImpl
    extends ExpressionBase
    implements Variable {
        private Type type;
        private String ident;
        private boolean available = true;

        VariableImpl(ExpressionFactory ef, Type type, String ident) {
            super(ef);
            if (!Identifier.isValidIdentifier(ident)) {
                throw new IllegalArgumentException(ident + " is not a valid Java identifier name");
            }
            this.type = type;
            this.ident = ident;
        }

        public boolean isAssignable() {
            return true;
        }

        public String ident() {
            return this.ident;
        }

        public boolean isAvailable() {
            return this.available;
        }

        public void close() {
            this.available = false;
        }

        public int hashCode() {
            return this.type.hashCode() ^ this.ident.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Variable)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            Variable other = (Variable)Variable.class.cast(obj);
            return this.type.equals(other.type()) && this.ident.equals(other.ident());
        }

        public String toString() {
            return "VariableImpl" + Util.getNodeIdString(this) + "[" + this.type.name() + " " + this.ident + "]";
        }

        public Type type() {
            return this.type;
        }

        public void accept(Visitor visitor) {
            visitor.visitVariable(this);
        }
    }

    public static final class IfExpression
    extends ExpressionBase {
        private Expression condition;
        private Expression truePart;
        private Expression falsePart;
        private Type type;

        IfExpression(ExpressionFactory ef, Expression condition, Expression truePart, Expression falsePart) {
            super(ef);
            this.condition = condition.copy(this, Expression.class);
            this.truePart = truePart.copy(this, Expression.class);
            this.falsePart = falsePart.copy(this, Expression.class);
            Type ttype = truePart.type();
            Type ftype = falsePart.type();
            if (ttype.equals(ftype)) {
                this.type = ttype;
            } else if (ttype.isNumber() && ftype.isNumber()) {
                HashSet<Type> argTypes;
                HashSet<Type> special = new HashSet<Type>(Arrays.asList(Type._byte(), Type._short()));
                if (((Object)special).equals(argTypes = new HashSet<Type>(Arrays.asList(ttype, ftype)))) {
                    this.type = Type._short();
                } else {
                    this.type = ttype.binaryPromotion(ftype);
                    if (!ttype.equals(this.type)) {
                        this.truePart = ef.cast(this.type, this.truePart);
                    }
                    if (!ftype.equals(this.type)) {
                        this.falsePart = ef.cast(this.type, this.falsePart);
                    }
                }
            } else if (ttype.equals(Type._null()) && !ftype.isPrimitive()) {
                this.type = ftype;
            } else if (ftype.equals(Type._null()) && !ttype.isPrimitive()) {
                this.type = ttype;
            } else if (ttype.isAssignmentConvertibleFrom(ftype)) {
                this.type = ttype;
            } else if (ftype.isAssignmentConvertibleFrom(ttype)) {
                this.type = ftype;
            }
        }

        public Expression condition() {
            return this.condition;
        }

        public Expression truePart() {
            return this.truePart;
        }

        public Expression falsePart() {
            return this.falsePart;
        }

        public Type type() {
            return this.type;
        }

        public void accept(Visitor visitor) {
            visitor.visitIfExpression(this);
        }

        public String toString() {
            return "IfExpression" + Util.getNodeIdString(this) + "[type=" + this.type.name() + "]";
        }
    }

    public static final class ArrayLengthExpression
    extends ExpressionBase {
        private Expression expr;

        ArrayLengthExpression(ExpressionFactory ef, Expression expr) {
            super(ef);
            this.expr = expr.copy(this, Expression.class);
        }

        public Expression expr() {
            return this.expr;
        }

        public Type type() {
            return Type._int();
        }

        public void accept(Visitor visitor) {
            visitor.visitArrayLengthExpression(this);
        }

        public String toString() {
            return "ArrayLengthExpression" + Util.getNodeIdString(this) + "[]";
        }
    }

    public static final class ArrayIndexExpression
    extends ExpressionBase {
        private Expression expr;
        private Expression index;

        ArrayIndexExpression(ExpressionFactory ef, Expression expr, Expression index) {
            super(ef);
            this.expr = expr.copy(this, Expression.class);
            this.index = index.copy(this, Expression.class);
        }

        public boolean isAssignable() {
            return true;
        }

        public Expression expr() {
            return this.expr;
        }

        public Expression index() {
            return this.index;
        }

        public Type type() {
            Type atype = this.expr.type().memberType();
            return atype;
        }

        public void accept(Visitor visitor) {
            visitor.visitArrayIndexExpression(this);
        }

        public String toString() {
            return "ArrayIndexExpression" + Util.getNodeIdString(this) + "[]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class StaticFieldAccessExpression
    extends FieldAccessExpressionBase<Type> {
        StaticFieldAccessExpression(ExpressionFactory ef, Type target, String fieldName) {
            super(ef, fieldName);
            this.target(target);
        }

        @Override
        public boolean isStatic() {
            return true;
        }

        @Override
        public Type targetType() {
            return (Type)this.target();
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitStaticFieldAccessExpression(this);
        }

        @Override
        public String toString() {
            return "StaticFieldAccessExpression" + Util.getNodeIdString(this) + "[" + ((Type)this.target()).name() + " " + this.fieldName() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NonStaticFieldAccessExpression
    extends FieldAccessExpressionBase<Expression> {
        NonStaticFieldAccessExpression(ExpressionFactory ef, Expression target, String fieldName) {
            super(ef, fieldName);
            this.target(target.copy(this, Expression.class));
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public Type targetType() {
            return ((Expression)this.target()).type();
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitNonStaticFieldAccessExpression(this);
        }

        @Override
        public String toString() {
            return "NonStaticFieldAccessExpression" + Util.getNodeIdString(this) + "[" + this.fieldName() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class FieldAccessExpressionBase<T>
    extends ExpressionBase {
        private T target;
        private String fieldName;

        FieldAccessExpressionBase(ExpressionFactory ef, String fieldName) {
            super(ef);
            this.fieldName = fieldName;
        }

        @Override
        public boolean isAssignable() {
            return true;
        }

        abstract boolean isStatic();

        abstract Type targetType();

        public T target() {
            return this.target;
        }

        public void target(T arg) {
            this.target = arg;
        }

        public String fieldName() {
            return this.fieldName;
        }

        @Override
        public Type type() {
            ClassInfo cinfo = this.targetType().classInfo();
            FieldInfo fld = cinfo.findFieldInfo(this.fieldName);
            if (fld == null) {
                throw new IllegalStateException("Type " + this.targetType().name() + " does not contain field " + this.fieldName);
            }
            ClassGenerator defClass = this.getAncestor(ClassGenerator.class);
            if (fld.isAccessibleInContext(defClass, cinfo)) {
                return fld.type();
            }
            throw new IllegalStateException("Field " + this.fieldName + " in type " + this.targetType().name() + "is not accessible in context " + defClass.name());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ThisObjExpression
    extends ExpressionBase {
        private Signature signature;
        private List<Expression> exprs;

        ThisObjExpression(ExpressionFactory ef, Signature signature, List<Expression> exprs) {
            super(ef);
            this.signature = signature;
            this.exprs = ExpressionFactory.copyExpressionList(this, exprs);
        }

        public Signature signature() {
            return this.signature;
        }

        public List<Expression> exprs() {
            return this.exprs;
        }

        @Override
        public Type type() {
            return Type._void();
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitThisObjExpression(this);
        }

        @Override
        public String toString() {
            return "ThisObjExpression" + Util.getNodeIdString(this) + "[" + this.signature + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SuperObjExpression
    extends ExpressionBase {
        private Signature signature;
        private List<Expression> exprs;

        SuperObjExpression(ExpressionFactory ef, Signature signature, List<Expression> exprs) {
            super(ef);
            this.signature = signature;
            this.exprs = ExpressionFactory.copyExpressionList(this, exprs);
        }

        public Signature signature() {
            return this.signature;
        }

        public List<Expression> exprs() {
            return this.exprs;
        }

        @Override
        public Type type() {
            return Type._void();
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitSuperObjExpression(this);
        }

        @Override
        public String toString() {
            return "SuperObjExpression" + Util.getNodeIdString(this) + "[" + this.signature + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SuperCallExpression
    extends ExpressionBase {
        private String ident;
        private Signature signature;
        private List<Expression> exprs;

        SuperCallExpression(ExpressionFactory ef, String ident, Signature signature, List<Expression> exprs) {
            super(ef);
            this.ident = ident;
            this.signature = signature;
            this.exprs = ExpressionFactory.copyExpressionList(this, exprs);
        }

        public String ident() {
            return this.ident;
        }

        public Signature signature() {
            return this.signature;
        }

        public List<Expression> exprs() {
            return this.exprs;
        }

        @Override
        public Type type() {
            return this.signature.returnType();
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitSuperCallExpression(this);
        }

        @Override
        public String toString() {
            return "SuperCallExpression" + Util.getNodeIdString(this) + "[" + this.ident + " " + this.signature + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NewArrExpression
    extends ExpressionBase {
        private Type ctype;
        private Expression size;
        private List<Expression> exprs;

        NewArrExpression(ExpressionFactory ef, Type ctype, Expression size, List<Expression> exprs) {
            super(ef);
            this.ctype = ctype;
            this.size = size.copy(this, Expression.class);
            this.exprs = ExpressionFactory.copyExpressionList(this, exprs);
        }

        public Type ctype() {
            return this.ctype;
        }

        public Expression size() {
            return this.size;
        }

        public List<Expression> exprs() {
            return this.exprs;
        }

        @Override
        public Type type() {
            return Type._array(this.ctype);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitNewArrExpression(this);
        }

        @Override
        public String toString() {
            return "NewArrExpression" + Util.getNodeIdString(this) + "[" + this.ctype.name() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NewObjExpression
    extends ExpressionBase {
        private Type type;
        private Signature signature;
        private List<Expression> args;

        NewObjExpression(ExpressionFactory ef, Type type, Signature signature, List<Expression> args) {
            super(ef);
            this.type = type;
            this.signature = signature;
            if (!signature.returnType().equals(Type._void())) {
                throw new IllegalArgumentException("The signature of a new call to a constructor must have a void return type");
            }
            this.args = ExpressionFactory.copyExpressionList(this, args);
        }

        public final Signature signature() {
            return this.signature;
        }

        public final List<Expression> args() {
            return this.args;
        }

        @Override
        public Type type() {
            return this.type;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitNewObjExpression(this);
        }

        @Override
        public String toString() {
            return "NewObjExpression" + Util.getNodeIdString(this) + "[" + this.type.name() + " " + this.signature + "]";
        }
    }

    public static final class InstofExpression
    extends ExpressionBase {
        private Expression expr;
        private Type itype;

        InstofExpression(ExpressionFactory ef, Expression expr, Type type) {
            super(ef);
            this.expr = expr.copy(this, Expression.class);
            this.itype = type;
        }

        public Expression expr() {
            return this.expr;
        }

        public Type itype() {
            return this.itype;
        }

        public Type type() {
            return Type._boolean();
        }

        public void accept(Visitor visitor) {
            visitor.visitInstofExpression(this);
        }

        public String toString() {
            return "InstofExpression" + Util.getNodeIdString(this) + "[" + this.itype.name() + "]";
        }
    }

    public static final class CastExpression
    extends ExpressionBase {
        private Type type;
        private Expression expr;

        CastExpression(ExpressionFactory ef, Type type, Expression expr) {
            super(ef);
            this.type = type;
            this.expr = expr.copy(this, Expression.class);
        }

        public Expression expr() {
            return this.expr;
        }

        public Type type() {
            return this.type;
        }

        public void accept(Visitor visitor) {
            visitor.visitCastExpression(this);
        }

        public String toString() {
            return "CastExpression" + Util.getNodeIdString(this) + "[" + this.type.name() + "]";
        }
    }

    public static final class BinaryOperatorExpression
    extends ExpressionBase {
        private Expression left;
        private BinaryOperator op;
        private Expression right;
        private Type type;

        BinaryOperatorExpression(ExpressionFactory ef, Type type, Expression left, BinaryOperator op, Expression right) {
            super(ef);
            this.type = type;
            this.left = left.copy(this, Expression.class);
            this.op = op;
            this.right = right.copy(this, Expression.class);
        }

        public BinaryOperator operator() {
            return this.op;
        }

        public Expression left() {
            return this.left;
        }

        public Expression right() {
            return this.right;
        }

        public Type type() {
            return this.type;
        }

        public void accept(Visitor visitor) {
            visitor.visitBinaryOperatorExpression(this);
        }

        public String toString() {
            return "BinaryOperatorExpression" + Util.getNodeIdString(this) + "[" + (Object)((Object)this.op) + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BinaryOperator {
        PLUS("+"){

            public Expression create(ExpressionFactory ef, Expression left, Expression right) {
                return BinaryOperator.createNumericExpression((BinaryOperator)this, ef, left, right);
            }

            public BinaryOperatorKind kind() {
                return BinaryOperatorKind.NUMERIC;
            }
        }
        ,
        TIMES("*"){

            public Expression create(ExpressionFactory ef, Expression left, Expression right) {
                return BinaryOperator.createNumericExpression((BinaryOperator)this, ef, left, right);
            }

            public BinaryOperatorKind kind() {
                return BinaryOperatorKind.NUMERIC;
            }
        }
        ,
        DIV("/"){

            public Expression create(ExpressionFactory ef, Expression left, Expression right) {
                return BinaryOperator.createNumericExpression((BinaryOperator)this, ef, left, right);
            }

            public BinaryOperatorKind kind() {
                return BinaryOperatorKind.NUMERIC;
            }
        }
        ,
        MINUS("-"){

            public Expression create(ExpressionFactory ef, Expression left, Expression right) {
                return BinaryOperator.createNumericExpression((BinaryOperator)this, ef, left, right);
            }

            public BinaryOperatorKind kind() {
                return BinaryOperatorKind.NUMERIC;
            }
        }
        ,
        REM("%"){

            public Expression create(ExpressionFactory ef, Expression left, Expression right) {
                return BinaryOperator.createNumericExpression((BinaryOperator)this, ef, left, right);
            }

            public BinaryOperatorKind kind() {
                return BinaryOperatorKind.NUMERIC;
            }
        }
        ,
        GT(">"){

            public Expression create(ExpressionFactory ef, Expression left, Expression right) {
                return BinaryOperator.createNumericExpression((BinaryOperator)this, ef, left, right);
            }
        }
        ,
        GE(">="){

            public Expression create(ExpressionFactory ef, Expression left, Expression right) {
                return BinaryOperator.createNumericExpression((BinaryOperator)this, ef, left, right);
            }
        }
        ,
        LT("<"){

            public Expression create(ExpressionFactory ef, Expression left, Expression right) {
                return BinaryOperator.createNumericExpression((BinaryOperator)this, ef, left, right);
            }
        }
        ,
        LE("<="){

            public Expression create(ExpressionFactory ef, Expression left, Expression right) {
                return BinaryOperator.createNumericExpression((BinaryOperator)this, ef, left, right);
            }
        }
        ,
        EQ("=="){

            public Expression create(ExpressionFactory ef, Expression left, Expression right) {
                return BinaryOperator.createEqualityExpression((BinaryOperator)this, ef, left, right);
            }
        }
        ,
        NE("!="){

            public Expression create(ExpressionFactory ef, Expression left, Expression right) {
                return BinaryOperator.createEqualityExpression((BinaryOperator)this, ef, left, right);
            }
        }
        ,
        AND("&&"){

            public Expression create(ExpressionFactory ef, Expression left, Expression right) {
                if (left != Type._boolean() || right != Type._boolean()) {
                    throw new IllegalArgumentException(this.javaRepresentation() + " requires boolean expressions");
                }
                return new IfExpression(ef, left, right, ef._const(false));
            }

            public BinaryOperatorKind kind() {
                return BinaryOperatorKind.BOOLEAN;
            }
        }
        ,
        OR("||"){

            public Expression create(ExpressionFactory ef, Expression left, Expression right) {
                if (left != Type._boolean() || right != Type._boolean()) {
                    throw new IllegalArgumentException(this.javaRepresentation() + " requires boolean expressions");
                }
                return ef.ifExpression(left, ef._const(true), right);
            }

            public BinaryOperatorKind kind() {
                return BinaryOperatorKind.BOOLEAN;
            }
        };

        private final String javaRepresentation;

        private static Expression createNumericExpression(BinaryOperator op, ExpressionFactory ef, Expression left, Expression right) {
            Expression lb = left;
            Expression rb = right;
            Type ctype = left.type().binaryPromotion(right.type());
            if (!ctype.equals(left.type())) {
                lb = ef.cast(ctype, lb);
            }
            if (!ctype.equals(right.type())) {
                rb = ef.cast(ctype, rb);
            }
            return new BinaryOperatorExpression(ef, ctype, lb, op, rb);
        }

        private static Expression createEqualityExpression(BinaryOperator op, ExpressionFactory ef, Expression left, Expression right) {
            boolean rok;
            Type ltype = left.type();
            Type rtype = right.type();
            if (rtype.equals(Type._boolean()) && ltype.equals(Type._boolean())) {
                return new BinaryOperatorExpression(ef, Type._boolean(), left, op, right);
            }
            if (ltype.isNumber() && rtype.isNumber()) {
                Expression lb = left;
                Expression rb = right;
                Type ctype = left.type().binaryPromotion(right.type());
                if (!ctype.equals(left.type())) {
                    lb = ef.cast(ctype, lb);
                }
                if (!ctype.equals(right.type())) {
                    rb = ef.cast(ctype, rb);
                }
                return new BinaryOperatorExpression(ef, Type._boolean(), lb, op, rb);
            }
            boolean lok = !ltype.isPrimitive() || ltype.equals(Type._null());
            boolean bl = rok = !rtype.isPrimitive() || rtype.equals(Type._null());
            if (lok && rok) {
                return new BinaryOperatorExpression(ef, Type._boolean(), left, op, right);
            }
            throw new IllegalArgumentException("Both arguments to " + op.javaRepresentation() + " must be of reference or null type.  left type = " + ltype.name() + " right type = " + rtype.name());
        }

        public String javaRepresentation() {
            return this.javaRepresentation;
        }

        public abstract Expression create(ExpressionFactory var1, Expression var2, Expression var3);

        public BinaryOperatorKind kind() {
            return BinaryOperatorKind.RELATIONAL;
        }

        private BinaryOperator(String javaRepresentation) {
            this.javaRepresentation = javaRepresentation;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BinaryOperatorKind {
        RELATIONAL,
        NUMERIC,
        BOOLEAN;

    }

    public static final class UnaryOperatorExpression
    extends ExpressionBase {
        private UnaryOperator op;
        private Expression expr;

        UnaryOperatorExpression(ExpressionFactory ef, UnaryOperator op, Expression expr) {
            super(ef);
            this.op = op;
            this.expr = expr.copy(this, Expression.class);
        }

        public UnaryOperator operator() {
            return this.op;
        }

        public Expression expr() {
            return this.expr;
        }

        public Type type() {
            return Type._boolean();
        }

        public void accept(Visitor visitor) {
            visitor.visitUnaryOperatorExpression(this);
        }

        public String toString() {
            return "UnaryOperatorExpression" + Util.getNodeIdString(this) + "[" + (Object)((Object)this.op) + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UnaryOperator {
        NOT("!"){

            public void checkType(Expression arg) {
                if (arg.type() != Type._boolean()) {
                    throw new IllegalArgumentException("! expects a boolean type, found " + arg.type());
                }
            }
        };

        private final String javaRepresentation;

        public String javaRepresentation() {
            return this.javaRepresentation;
        }

        public abstract void checkType(Expression var1);

        private UnaryOperator(String javaRepresentation) {
            this.javaRepresentation = javaRepresentation;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NonStaticCallExpression
    extends CallExpression<Expression> {
        NonStaticCallExpression(ExpressionFactory ef, Expression target, String ident, Signature signature, List<Expression> args) {
            super(ef, ident, signature, args);
            this.target(target.copy(this, Expression.class));
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitNonStaticCallExpression(this);
        }

        @Override
        public String toString() {
            return "NonStaticCallExpression" + Util.getNodeIdString(this) + "[ident=" + this.ident() + " " + "signature=" + this.signature() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class StaticCallExpression
    extends CallExpression<Type> {
        StaticCallExpression(ExpressionFactory ef, Type target, String ident, Signature signature, List<Expression> args) {
            super(ef, ident, signature, args);
            this.target(target);
        }

        @Override
        public boolean isStatic() {
            return true;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitStaticCallExpression(this);
        }

        @Override
        public String toString() {
            return "StaticCallExpression" + Util.getNodeIdString(this) + "[target=" + this.target() + " " + "ident=" + this.ident() + " " + "signature=" + this.signature() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class CallExpression<T>
    extends ExpressionBase {
        private T target;
        private String ident;
        private Signature signature;
        private List<Expression> args;

        public abstract boolean isStatic();

        CallExpression(ExpressionFactory ef, String ident, Signature signature, List<Expression> args) {
            super(ef);
            this.ident = ident;
            this.signature = signature;
            this.args = ExpressionFactory.copyExpressionList(this, args);
        }

        public final T target() {
            return this.target;
        }

        public final void target(T arg) {
            this.target = arg;
        }

        public final String ident() {
            return this.ident;
        }

        public final Signature signature() {
            return this.signature;
        }

        public final List<Expression> args() {
            return this.args;
        }

        @Override
        public final Type type() {
            return this.signature.returnType();
        }
    }

    public static final class ThisExpression
    extends ExpressionBase {
        ThisExpression(ExpressionFactory ef) {
            super(ef);
        }

        public Type type() {
            ClassGenerator cg = this.getAncestor(ClassGenerator.class);
            if (cg == null) {
                throw new IllegalStateException("No ClassGenerator found!");
            }
            Type cgType = Type._classGenerator(cg);
            return cgType;
        }

        public void accept(Visitor visitor) {
            visitor.visitThisExpression(this);
        }

        public String toString() {
            return "ThisExpression" + Util.getNodeIdString(this) + "[]";
        }
    }

    public static final class VoidExpression
    extends ExpressionBase {
        VoidExpression(ExpressionFactory ef) {
            super(ef);
        }

        public Type type() {
            return Type._void();
        }

        public void accept(Visitor visitor) {
            visitor.visitVoidExpression(this);
        }

        public String toString() {
            return "VoidExpression" + Util.getNodeIdString(this) + "[]";
        }
    }

    public static final class ConstantExpression
    extends ExpressionBase {
        private Type type;
        private Object value;

        ConstantExpression(ExpressionFactory ef, Type type, Object value) {
            super(ef);
            this.type = type;
            this.value = value;
        }

        public Object value() {
            return this.value;
        }

        public String toString() {
            String valueStr = this.value == null ? "null" : this.value.toString();
            return "ConstantExpression" + Util.getNodeIdString(this) + "[" + this.type.name() + ":" + valueStr + "]";
        }

        public Type type() {
            return this.type;
        }

        public void accept(Visitor visitor) {
            visitor.visitConstantExpression(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ExpressionBase
    extends NodeBase
    implements Expression {
        @Copy(value=CopyType.IDENTITY)
        private ExpressionFactory expressionFactory;

        public ExpressionBase(ExpressionFactory ef) {
            super(ef.efparent());
            this.expressionFactory = ef;
            ef.unusedExpressions().put(this, true);
        }

        @Override
        public boolean isAssignable() {
            return false;
        }

        @Override
        public <T extends Node> T copy(Class<T> cls) {
            throw new IllegalArgumentException("Need to use copy(Node,Class) to copy an expression");
        }

        @Override
        public <T extends Node> T copy(Node newParent, Class<T> cls) {
            if (this.expressionFactory.unusedExpressions().containsKey(this)) {
                this.expressionFactory.unusedExpressions().remove(this);
            }
            Util.checkScope(this);
            return super.copy(newParent, cls);
        }

        @Override
        public abstract void accept(Visitor var1);
    }
}

