/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMainHelper;
import com.sun.enterprise.module.bootstrap.PlatformMain;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.bootstrap.Which;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractMain
extends PlatformMain {
    final File bootstrapFile = this.findBootstrapFile();
    protected ASMainHelper helper;
    protected final File glassfishDir;
    protected File domainDir;

    abstract Logger getLogger();

    abstract long getSettingsLastModification();

    protected abstract String getPreferedCacheDir();

    abstract boolean createCache(File var1) throws IOException;

    AbstractMain() {
        System.setProperty("hk2.startup.context.root", this.bootstrapFile.getParent());
        this.glassfishDir = this.bootstrapFile.getParentFile().getParentFile();
        System.setProperty("com.sun.aas.installRoot", this.glassfishDir.getAbsolutePath());
    }

    public void start(String[] args) throws Exception {
        this.helper = new ASMainHelper(this.logger);
        this.helper.parseAsEnv(this.glassfishDir);
        this.run(this.logger, args);
    }

    protected void run(Logger logger, String ... args) throws Exception {
        this.logger = logger;
        this.domainDir = this.helper.getDomainRoot(new StartupContext(this.bootstrapFile, args));
        this.helper.verifyAndSetDomainRoot(this.domainDir);
        File cacheProfileDir = new File(this.domainDir, this.getPreferedCacheDir());
        this.setUpCache(this.bootstrapFile.getParentFile(), cacheProfileDir);
    }

    protected void setSystemProperties() throws Exception {
        String installRoot = System.getProperty("com.sun.aas.installRoot");
        URI installRootURI = new File(installRoot).toURI();
        System.setProperty("com.sun.aas.installRootURI", installRootURI.toString());
        String instanceRoot = System.getProperty("com.sun.aas.instanceRoot");
        URI instanceRootURI = new File(instanceRoot).toURI();
        System.setProperty("com.sun.aas.instanceRootURI", instanceRootURI.toString());
    }

    boolean isCacheOutdated(long lastModified, File cacheDir) {
        Properties persistedInfo = this.loadCacheInformation(cacheDir);
        long recordedLastModified = this.parse(persistedInfo, "LastModified");
        String location = persistedInfo.getProperty("Location");
        try {
            if (!cacheDir.toURI().toURL().toString().equals(location)) {
                recordedLastModified = 0L;
            }
        }
        catch (MalformedURLException e) {
            this.getLogger().log(Level.SEVERE, "Could not load cache metadata, cache will be reset", e);
            recordedLastModified = 0L;
        }
        return recordedLastModified != lastModified;
    }

    protected void setUpCache(File sourceDir, File cacheDir) throws IOException {
        long lastModified = this.getLastModified(sourceDir, 0L);
        long settingsLastModified = this.getSettingsLastModification();
        if (settingsLastModified > lastModified) {
            lastModified = settingsLastModified;
        }
        if (this.isCacheOutdated(lastModified, cacheDir)) {
            this.flushAndCreate(cacheDir, lastModified);
        }
        System.setProperty("com.sun.hk2.cacheDir", cacheDir.getAbsolutePath());
    }

    protected void flushAndCreate(File cacheDir, long lastModified) throws IOException {
        if (cacheDir.exists() && cacheDir.isDirectory()) {
            this.getLogger().info("Removing cache dir " + cacheDir + " left from a previous run");
            if (!this.deleteRecursive(cacheDir)) {
                this.getLogger().warning("Not able to delete " + cacheDir);
            }
        }
        if (!this.createCache(cacheDir)) {
            throw new IOException("Could not create cache");
        }
        try {
            this.saveCacheInformation(cacheDir, cacheDir.toURI().toURL().toString(), lastModified);
        }
        catch (MalformedURLException e) {
            this.getLogger().log(Level.SEVERE, "Could not save cache metadata, cache will be reset at next startup", e);
        }
    }

    public long getLastModified(File directory, long current) {
        for (File file : directory.listFiles()) {
            long lastModified = file.isDirectory() ? this.getLastModified(file, current) : file.lastModified();
            if (lastModified <= current) continue;
            current = lastModified;
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadCacheInformation(File cacheDir) {
        long recordedLastModified = 0L;
        Properties persistedInfo = new Properties();
        File lastModifiedFile = new File(cacheDir.getParentFile(), cacheDir.getName() + ".lastmodified");
        if (lastModifiedFile.exists()) {
            InputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(lastModifiedFile));
                persistedInfo.load(is);
                try {
                    recordedLastModified = Long.parseLong(persistedInfo.getProperty("LastModified"));
                    String location = persistedInfo.getProperty("Location");
                    if (!cacheDir.toURI().toURL().toString().equals(location)) {
                        recordedLastModified = 0L;
                    }
                }
                catch (NumberFormatException e) {
                    recordedLastModified = 0L;
                }
            }
            catch (IOException e) {
                this.getLogger().info("Cannot read recorded lastModified, OSGi cache will be flushed");
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return persistedInfo;
    }

    public long parse(Properties info, String name) {
        try {
            return Long.parseLong(info.getProperty(name));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCacheInformation(File cacheDir, String location, long lastModified) {
        ObjectOutputStream os = null;
        File lastModifiedFile = new File(cacheDir.getParentFile(), cacheDir.getName() + ".lastmodified");
        try {
            lastModifiedFile.delete();
            if (!lastModifiedFile.createNewFile()) {
                this.getLogger().warning("Cannot create new lastModified file");
                return;
            }
            os = new ObjectOutputStream(new FileOutputStream(lastModifiedFile));
            Properties persistedInfo = new Properties();
            persistedInfo.put("LastModified", new Long(lastModified).toString());
            persistedInfo.put("Location", cacheDir.toURI().toURL().toString());
            persistedInfo.store(os, null);
        }
        catch (IOException e) {
            this.getLogger().info("Cannot create record of lastModified file");
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public File findBootstrapFile() {
        try {
            return Which.jarFile(this.getClass());
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot get bootstrap path from " + this.getClass() + " class location, aborting");
        }
    }

    boolean deleteRecursive(File dir) {
        for (File f : dir.listFiles()) {
            if (f.isFile()) {
                f.delete();
                continue;
            }
            this.deleteRecursive(f);
        }
        return dir.delete();
    }

    public static void copyFile(File fin, File fout) throws IOException {
        BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(fin));
        FileOutputStream fos = new FileOutputStream(fout);
        AbstractMain.copy(inStream, fos, fin.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, FileOutputStream out, long size) throws IOException {
        try {
            AbstractMain.copyWithoutClose(in, out, size);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static void copyWithoutClose(InputStream in, FileOutputStream out, long size) throws IOException {
        ReadableByteChannel inChannel = Channels.newChannel(in);
        FileChannel outChannel = out.getChannel();
        outChannel.transferFrom(inChannel, 0L, size);
    }
}

