/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl.managedbean;

import com.sun.enterprise.container.common.impl.managedbean.ManagedBeanNamingProxy;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.interceptor.InterceptorInfo;
import org.glassfish.api.interceptor.InterceptorInvoker;
import org.glassfish.api.interceptor.JavaEEInterceptorBuilder;
import org.glassfish.api.interceptor.JavaEEInterceptorBuilderFactory;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.managedbean.ManagedBeanManager;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

@Service
public class ManagedBeanManagerImpl
implements ManagedBeanManager,
PostConstruct,
EventListener {
    private static Logger _logger = LogDomains.getLogger(ManagedBeanManagerImpl.class, (String)"javax.enterprise.system.core");
    @Inject
    private ComponentEnvManager compEnvManager;
    @Inject
    private InvocationManager invocationMgr;
    @Inject
    private GlassfishNamingManager namingManager;
    @Inject
    private Habitat habitat;
    @Inject
    private Events events;
    @Inject
    private ProcessEnvironment processEnv;
    private ProcessEnvironment.ProcessType processType;

    public void postConstruct() {
        this.events.register((EventListener)this);
        this.processType = this.processEnv.getProcessType();
    }

    public void event(EventListener.Event event) {
        if (event.is(Deployment.APPLICATION_PREPARED)) {
            DeploymentContext dc = (DeploymentContext)Deployment.APPLICATION_PREPARED.getHook(event);
            this.loadManagedBeans(dc);
            this.registerAppLevelDependencies(dc);
        } else if (event.is(Deployment.APPLICATION_UNLOADED)) {
            ApplicationInfo info = (ApplicationInfo)Deployment.APPLICATION_UNLOADED.getHook(event);
            this.unloadManagedBeans(info);
            this.unregisterAppLevelDependencies(info);
        }
    }

    private void registerAppLevelDependencies(DeploymentContext dc) {
        Application app = (Application)dc.getModuleMetaData(Application.class);
        if (app == null) {
            return;
        }
        try {
            this.compEnvManager.bindToComponentNamespace((JndiNameEnvironment)app);
        }
        catch (Exception e) {
            throw new RuntimeException("Error binding app-level env dependencies " + app.getAppName(), e);
        }
    }

    private void unregisterAppLevelDependencies(ApplicationInfo appInfo) {
        Application app = (Application)appInfo.getMetaData(Application.class);
        if (app != null) {
            try {
                this.compEnvManager.unbindFromComponentNamespace((JndiNameEnvironment)app);
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "Exception unbinding app objects", e);
            }
        }
    }

    private void loadManagedBeans(DeploymentContext dc) {
        Application app = (Application)dc.getModuleMetaData(Application.class);
        if (app == null) {
            return;
        }
        for (BundleDescriptor bundle : app.getBundleDescriptors()) {
            if (!this.bundleEligible(bundle)) continue;
            for (ManagedBeanDescriptor next : bundle.getManagedBeans()) {
                try {
                    next.validate();
                    Set interceptorClasses = next.getAllInterceptorClasses();
                    if (!interceptorClasses.isEmpty() || next.hasAroundInvokeMethod()) {
                        Class<?> targetClass = bundle.getClassLoader().loadClass(next.getBeanClassName());
                        InterceptorInfo interceptorInfo = new InterceptorInfo();
                        interceptorInfo.setTargetClass(targetClass);
                        interceptorInfo.setInterceptorClassNames(next.getAllInterceptorClasses());
                        interceptorInfo.setPostConstructInterceptors(next.getCallbackInterceptors(LifecycleCallbackDescriptor.CallbackType.POST_CONSTRUCT));
                        interceptorInfo.setPreDestroyInterceptors(next.getCallbackInterceptors(LifecycleCallbackDescriptor.CallbackType.PRE_DESTROY));
                        if (next.hasAroundInvokeMethod()) {
                            interceptorInfo.setHasTargetClassAroundInvoke(true);
                        }
                        HashMap<Method, List> interceptorChains = new HashMap<Method, List>();
                        for (Method m : targetClass.getMethods()) {
                            interceptorChains.put(m, next.getAroundInvokeInterceptors(m));
                        }
                        interceptorInfo.setAroundInvokeInterceptorChains(interceptorChains);
                        JavaEEInterceptorBuilderFactory interceptorBuilderFactory = (JavaEEInterceptorBuilderFactory)this.habitat.getByContract(JavaEEInterceptorBuilderFactory.class);
                        JavaEEInterceptorBuilder builder = interceptorBuilderFactory.createBuilder(interceptorInfo);
                        next.setInterceptorBuilder((Object)builder);
                    }
                    this.compEnvManager.bindToComponentNamespace((JndiNameEnvironment)next);
                    String jndiName = next.getGlobalJndiName();
                    ManagedBeanNamingProxy namingProxy = new ManagedBeanNamingProxy(next, this.habitat);
                    this.namingManager.publishObject(jndiName, (Object)namingProxy, true);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error binding ManagedBean " + next.getBeanClassName() + " with name = " + next.getName(), e);
                }
            }
        }
    }

    private void unloadManagedBeans(ApplicationInfo appInfo) {
        Application app = (Application)appInfo.getMetaData(Application.class);
        if (app == null) {
            return;
        }
        for (BundleDescriptor bundle : app.getBundleDescriptors()) {
            if (!this.bundleEligible(bundle)) continue;
            for (ManagedBeanDescriptor next : bundle.getManagedBeans()) {
                InjectionManager injectionMgr = (InjectionManager)this.habitat.getByContract(InjectionManager.class);
                for (Object instance : next.getBeanInstances()) {
                    InterceptorInvoker invoker = (InterceptorInvoker)next.getInterceptorInfoForBeanInstance(instance);
                    if (invoker == null) {
                        try {
                            injectionMgr.invokeInstancePreDestroy(instance, (JndiNameEnvironment)next);
                        }
                        catch (Exception e) {
                            _logger.log(Level.FINE, "Managed bean " + next.getBeanClassName() + " PreDestroy", e);
                        }
                        continue;
                    }
                    try {
                        invoker.invokePreDestroy();
                    }
                    catch (Exception e) {
                        _logger.log(Level.FINE, "Managed bean " + next.getBeanClassName() + " PreDestroy", e);
                    }
                }
                ComponentEnvManager compEnvManager = (ComponentEnvManager)this.habitat.getByContract(ComponentEnvManager.class);
                try {
                    compEnvManager.unbindFromComponentNamespace((JndiNameEnvironment)next);
                }
                catch (NamingException ne) {
                    _logger.log(Level.FINE, "Managed bean " + next.getBeanClassName() + " unbind", ne);
                }
                GlassfishNamingManager namingManager = (GlassfishNamingManager)this.habitat.getByContract(GlassfishNamingManager.class);
                String jndiName = next.getGlobalJndiName();
                try {
                    namingManager.unpublishObject(jndiName);
                }
                catch (NamingException ne) {
                    _logger.log(Level.FINE, "Error unpubishing managed bean " + next.getBeanClassName() + " with jndi name " + jndiName, ne);
                }
                next.clearBeanInstanceInfo();
            }
        }
    }

    private boolean bundleEligible(BundleDescriptor bundle) {
        boolean eligible = false;
        if (this.processType == ProcessEnvironment.ProcessType.Server) {
            eligible = bundle instanceof WebBundleDescriptor || bundle instanceof EjbBundleDescriptor;
        }
        return eligible;
    }
}

