/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.amx;

import java.util.concurrent.CountDownLatch;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.glassfish.api.amx.AMXValues;
import org.glassfish.api.amx.BootAMXMBean;
import org.glassfish.api.amx.MBeanListener;

public final class AMXBooter {
    private AMXBooter() {
    }

    public static ObjectName bootAMX(MBeanServerConnection conn) {
        ObjectName domainRootObjectName = AMXBooter.findDomainRoot(conn);
        if (domainRootObjectName == null) {
            BootAMXCallback callback = new BootAMXCallback(conn);
            MBeanListener.listenForBootAMX(conn, callback);
            callback.await();
            try {
                conn.invoke(BootAMXMBean.OBJECT_NAME, "bootAMX", null, null);
                MBeanListener.waitAMXReady(conn);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return domainRootObjectName;
    }

    public static ObjectName findDomainRoot(MBeanServerConnection conn) {
        ObjectName objectName = AMXValues.domainRoot();
        try {
            if (!conn.isRegistered(objectName)) {
                return null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return objectName;
    }

    private static final class BootAMXCallback
    extends MBeanListener.CallbackImpl {
        private final MBeanServerConnection mConn;
        private final CountDownLatch mLatch = new CountDownLatch(1);

        public BootAMXCallback(MBeanServerConnection conn) {
            this.mConn = conn;
        }

        public void mbeanRegistered(ObjectName objectName, MBeanListener listener) {
            super.mbeanRegistered(objectName, listener);
            this.mLatch.countDown();
        }

        public void await() {
            try {
                this.mLatch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

