/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.embedded;

import java.io.File;

public class EmbeddedFileSystem {
    public final boolean autoDelete;
    public final File installRoot;
    public final File instanceRoot;
    public final File configFile;

    private EmbeddedFileSystem(Builder builder) {
        this.autoDelete = builder.autoDelete;
        this.installRoot = builder.installRoot;
        this.instanceRoot = builder.instanceRoot;
        this.configFile = builder.configFile;
    }

    public static class Builder {
        boolean autoDelete = false;
        File configFile = null;
        File installRoot = null;
        File instanceRoot = null;

        public Builder setAutoDelete(boolean b) {
            this.autoDelete = b;
            return this;
        }

        public Builder setConfigurationFile(File f) {
            this.configFile = f;
            return this;
        }

        public Builder setInstallRoot(File f) {
            this.installRoot = f;
            return this;
        }

        public Builder setInstanceRoot(File f) {
            this.instanceRoot = f;
            return this;
        }

        public EmbeddedFileSystem build() {
            return new EmbeddedFileSystem(this);
        }
    }
}

