/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.AuthorizationConstraintImpl;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.annotation.handlers.AbstractAuthAnnotationHandler;
import com.sun.enterprise.deployment.web.SecurityConstraint;
import java.lang.annotation.Annotation;
import javax.annotation.security.RolesAllowed;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class RolesAllowedHandler
extends AbstractAuthAnnotationHandler {
    public Class<? extends Annotation> getAnnotationType() {
        return RolesAllowed.class;
    }

    @Override
    protected void processEjbMethodSecurity(Annotation authAnnotation, MethodDescriptor md, EjbDescriptor ejbDesc) {
        RolesAllowed rolesAllowedAn = (RolesAllowed)authAnnotation;
        for (String roleName : rolesAllowedAn.value()) {
            Role role = new Role(roleName);
            ejbDesc.getEjbBundleDescriptor().addRole(role);
            ejbDesc.addPermissionedMethod(new MethodPermission(role), md);
        }
    }

    @Override
    protected void processSecurityConstraint(Annotation authAnnotation, SecurityConstraint securityConstraint, WebComponentDescriptor webCompDesc) {
        WebBundleDescriptor webBundleDesc = webCompDesc.getWebBundleDescriptor();
        RolesAllowed rolesAllowedAn = (RolesAllowed)authAnnotation;
        AuthorizationConstraintImpl ac = new AuthorizationConstraintImpl();
        for (String roleName : rolesAllowedAn.value()) {
            Role role = new Role(roleName);
            webBundleDesc.addRole(role);
            ac.addSecurityRole(roleName);
        }
        securityConstraint.setAuthorizationConstraint(ac);
    }

    @Override
    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getEjbAndWebAnnotationTypes();
    }
}

