/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@ManagedObject
@Description(value="JVM Memory Statistics")
public class JVMMemoryStatsProvider {
    private MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
    private MemoryUsage memUsageHeap = this.memBean.getHeapMemoryUsage();
    private MemoryUsage memUsageNonHeap = this.memBean.getNonHeapMemoryUsage();

    @ManagedAttribute(id="committedheapsize-count")
    @Description(value="amount of memory in bytes that is committed for the Java virtual machine to use")
    public long getCommittedHeap() {
        return this.memUsageHeap.getCommitted();
    }

    @ManagedAttribute(id="initheapsize-count")
    @Description(value="amount of memory in bytes that the Java virtual machine initially requests from the operating system for memory management")
    public long getInitHeap() {
        return this.memUsageHeap.getInit();
    }

    @ManagedAttribute(id="maxheapsize-count")
    @Description(value="maximum amount of memory in bytes that can be used for memory management")
    public long getMaxHeap() {
        return this.memUsageHeap.getMax();
    }

    @ManagedAttribute(id="usedheapsize-count")
    @Description(value="amount of used memory in bytes")
    public long getUsedHeap() {
        return this.memUsageHeap.getUsed();
    }

    @ManagedAttribute(id="committednonheapsize-count")
    @Description(value="amount of memory in bytes that is committed for the Java virtual machine to use")
    public long getCommittedNonHeap() {
        return this.memUsageNonHeap.getCommitted();
    }

    @ManagedAttribute(id="initnonheapsize-count")
    @Description(value="amount of memory in bytes that the Java virtual machine initially requests from the operating system for memory management")
    public long getInitNonHeap() {
        return this.memUsageNonHeap.getInit();
    }

    @ManagedAttribute(id="maxnonheapsize-count")
    @Description(value="maximum amount of memory in bytes that can be used for memory management")
    public long getMaxNonHeap() {
        return this.memUsageNonHeap.getMax();
    }

    @ManagedAttribute(id="usednonheapsize-count")
    @Description(value="amount of used memory in bytes")
    public long getUsedNonHeap() {
        return this.memUsageNonHeap.getUsed();
    }

    @ManagedAttribute(id="objectpendingfinalizationcount-count")
    @Description(value="approximate number of objects for which finalization is pending")
    public int getObjectPendingFinalizationCount() {
        return this.memBean.getObjectPendingFinalizationCount();
    }
}

