/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor.jvm;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.admin.monitor.jvm.JVMClassLoadingStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMCompilationStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMGCStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMMemoryStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMOSStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMRuntimeStatsProvider;
import org.glassfish.api.Startup;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.probe.provider.PluginPoint;
import org.glassfish.probe.provider.StatsProviderManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

@Service
public class JVMStatsProviderBootstrap
implements Startup,
PostConstruct,
EventListener {
    @Inject
    Events events;
    private JVMClassLoadingStatsProvider clStatsProvider = new JVMClassLoadingStatsProvider();
    private JVMCompilationStatsProvider compileStatsProvider = new JVMCompilationStatsProvider();
    private JVMMemoryStatsProvider memoryStatsProvider = new JVMMemoryStatsProvider();
    private JVMOSStatsProvider osStatsProvider = new JVMOSStatsProvider();
    private JVMRuntimeStatsProvider runtimeStatsProvider = new JVMRuntimeStatsProvider();
    private List<JVMGCStatsProvider> jvmStatsProviderList = new ArrayList<JVMGCStatsProvider>();

    public void postConstruct() {
        StatsProviderManager.register("jvm", PluginPoint.SERVER, "jvm/class-loading-system", this.clStatsProvider);
        StatsProviderManager.register("jvm", PluginPoint.SERVER, "jvm/compilation-system", this.compileStatsProvider);
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            JVMGCStatsProvider jvmStatsProvider = new JVMGCStatsProvider(gc.getName());
            this.jvmStatsProviderList.add(jvmStatsProvider);
            StatsProviderManager.register("jvm", PluginPoint.SERVER, "jvm/garbage-collectors/" + gc.getName(), jvmStatsProvider);
        }
        StatsProviderManager.register("jvm", PluginPoint.SERVER, "jvm/memory", this.memoryStatsProvider);
        StatsProviderManager.register("jvm", PluginPoint.SERVER, "jvm/operating-system", this.osStatsProvider);
        StatsProviderManager.register("jvm", PluginPoint.SERVER, "jvm/runtime", this.runtimeStatsProvider);
        this.events.register((EventListener)this);
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    public void event(EventListener.Event event) {
        if (event.name().equals("prepare_shutdown")) {
            StatsProviderManager.unregister(this.clStatsProvider);
            StatsProviderManager.unregister(this.compileStatsProvider);
            StatsProviderManager.unregister(this.memoryStatsProvider);
            StatsProviderManager.unregister(this.osStatsProvider);
            StatsProviderManager.unregister(this.runtimeStatsProvider);
            for (JVMGCStatsProvider gc : this.jvmStatsProviderList) {
                StatsProviderManager.unregister(gc);
            }
        }
    }
}

