/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.mc.runtime;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.commons.Logger;
import com.sun.xml.ws.rx.RxConfiguration;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.mc.protocol.wsmc200702.MessagePendingElement;
import com.sun.xml.ws.rx.mc.runtime.MakeConnectionSenderTask;
import com.sun.xml.ws.rx.util.AbstractResponseHandler;
import com.sun.xml.ws.rx.util.SuspendedFiberStorage;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class McResponseHandlerBase
extends AbstractResponseHandler
implements Fiber.CompletionCallback {
    private static final Logger LOGGER = Logger.getLogger(McResponseHandlerBase.class);
    protected final RxConfiguration configuration;
    protected final MakeConnectionSenderTask mcSenderTask;

    protected McResponseHandlerBase(RxConfiguration configuration, MakeConnectionSenderTask mcSenderTask, SuspendedFiberStorage suspendedFiberStorage, String correlationId) {
        super(suspendedFiberStorage, correlationId);
        this.configuration = configuration;
        this.mcSenderTask = mcSenderTask;
    }

    protected McResponseHandlerBase(RxConfiguration configuration, MakeConnectionSenderTask mcSenderTask, SuspendedFiberStorage suspendedFiberStorage) {
        super(suspendedFiberStorage, null);
        this.configuration = configuration;
        this.mcSenderTask = mcSenderTask;
    }

    protected final void processMakeConnectionHeaders(@NotNull Message responseMessage) throws RxRuntimeException {
        MessagePendingElement messagePendingHeader;
        assert (responseMessage != null);
        if (responseMessage.hasHeaders() && (messagePendingHeader = (MessagePendingElement)this.readHeaderAsUnderstood(responseMessage, this.configuration.getMcVersion().messagePendingHeaderName)) != null && messagePendingHeader.isPending().booleanValue()) {
            this.mcSenderTask.scheduleMcRequest();
        }
    }

    private final <T> T readHeaderAsUnderstood(Message message, QName headerName) throws RxRuntimeException {
        Header header = message.getHeaders().get(headerName, true);
        if (header == null) {
            return null;
        }
        try {
            Object result = header.readAsJAXB(this.configuration.getMcVersion().getUnmarshaller(this.configuration.getAddressingVersion()));
            return result;
        }
        catch (JAXBException ex) {
            throw LOGGER.logSevereException(new RxRuntimeException(String.format("Error unmarshalling header %s", headerName), ex));
        }
    }
}

