/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.invm;

import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceData;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

final class InVmSequenceData
implements SequenceData {
    private final ReadWriteLock messageIdLock = new ReentrantReadWriteLock();
    private final String sequenceId;
    private final String boundSecurityTokenReferenceId;
    private final long expirationTime;
    private volatile Sequence.State state;
    private volatile boolean ackRequestedFlag;
    private volatile long lastMessageId;
    private volatile long lastActivityTime;
    private volatile long lastAcknowledgementRequestTime;
    private final Map<String, ApplicationMessage> weakMessageStorage;
    private final Map<Long, String> weakUnackedNumberToCorrelationIdMap;

    public InVmSequenceData(String sequenceId, String securityContextTokenId, long expirationTime, long lastMessageId, long lastActivityTime) {
        this(sequenceId, securityContextTokenId, expirationTime, Sequence.State.CREATED, false, lastMessageId, lastActivityTime, 0L);
    }

    public InVmSequenceData(String sequenceId, String securityContextTokenId, long expirationTime, Sequence.State state, boolean ackRequestedFlag, long lastMessageId, long lastActivityTime, long lastAcknowledgementRequestTime) {
        this.sequenceId = sequenceId;
        this.boundSecurityTokenReferenceId = securityContextTokenId;
        this.expirationTime = expirationTime;
        this.state = state;
        this.ackRequestedFlag = ackRequestedFlag;
        this.lastMessageId = lastMessageId;
        this.lastActivityTime = lastActivityTime;
        this.lastAcknowledgementRequestTime = lastAcknowledgementRequestTime;
        this.weakMessageStorage = new WeakHashMap<String, ApplicationMessage>();
        this.weakUnackedNumberToCorrelationIdMap = new WeakHashMap<Long, String>();
    }

    public void lockRead() {
        this.messageIdLock.readLock().lock();
    }

    public void unlockRead() {
        this.messageIdLock.readLock().unlock();
    }

    public void lockWrite() {
        this.messageIdLock.writeLock().lock();
    }

    public void unlockWrite() {
        this.messageIdLock.writeLock().unlock();
    }

    public String getSequenceId() {
        return this.sequenceId;
    }

    public String getBoundSecurityTokenReferenceId() {
        return this.boundSecurityTokenReferenceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastMessageId() {
        try {
            this.lockRead();
            long l = this.lastMessageId;
            return l;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastMessageId(long newLastMessageId) {
        try {
            this.lockWrite();
            this.lastMessageId = newLastMessageId;
        }
        finally {
            this.unlockWrite();
        }
    }

    public Sequence.State getState() {
        return this.state;
    }

    public void setState(Sequence.State newState) {
        this.state = newState;
    }

    public boolean getAckRequestedFlag() {
        return this.ackRequestedFlag;
    }

    public void setAckRequestedFlag(boolean newValue) {
        this.ackRequestedFlag = newValue;
    }

    public long getLastAcknowledgementRequestTime() {
        return this.lastAcknowledgementRequestTime;
    }

    public void setLastAcknowledgementRequestTime(long newTime) {
        this.lastAcknowledgementRequestTime = newTime;
    }

    public long getLastActivityTime() {
        return this.lastActivityTime;
    }

    public void setLastActivityTime(long newTime) {
        this.lastActivityTime = newTime;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void storeMessage(ApplicationMessage message, Long msgNumberKey) throws UnsupportedOperationException {
        assert (msgNumberKey != null);
        try {
            this.lockWrite();
            String correlationKey = new String(message.getCorrelationId());
            this.weakUnackedNumberToCorrelationIdMap.put(msgNumberKey, correlationKey);
            this.weakMessageStorage.put(correlationKey, message);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationMessage retrieveMessage(String correlationId) {
        try {
            this.lockRead();
            ApplicationMessage applicationMessage = this.weakMessageStorage.get(correlationId);
            return applicationMessage;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationMessage retrieveUnackedMessage(long messageNumber) {
        try {
            this.lockRead();
            String correlationKey = this.weakUnackedNumberToCorrelationIdMap.get(messageNumber);
            ApplicationMessage applicationMessage = correlationKey != null ? this.weakMessageStorage.get(correlationKey) : null;
            return applicationMessage;
        }
        finally {
            this.unlockRead();
        }
    }
}

