/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.persistent;

import com.sun.xml.ws.commons.Logger;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateSequenceException;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceData;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

final class PersistentSequenceData
implements SequenceData {
    private static final Logger LOGGER = Logger.getLogger(PersistentSequenceData.class);
    private final ReadWriteLock dataLock = new ReentrantReadWriteLock();
    private final String sequenceId;
    private final SequenceType type;
    private final String boundSecurityTokenReferenceId;
    private final long expirationTime;
    private volatile Sequence.State state;
    private volatile boolean ackRequestedFlag;
    private volatile long lastMessageId;
    private volatile long lastActivityTime;
    private volatile long lastAcknowledgementRequestTime;
    private final Map<String, ApplicationMessage> weakMessageStorage;
    private final Map<Long, String> weakUnackedNumberToCorrelationIdMap;

    PersistentSequenceData(String sequenceId, SequenceType type, String securityContextTokenId, long expirationTime, long lastMessageId, long lastActivityTime) {
        this(sequenceId, type, securityContextTokenId, expirationTime, Sequence.State.CREATED, false, lastMessageId, lastActivityTime, 0L);
    }

    PersistentSequenceData(String sequenceId, SequenceType type, String securityContextTokenId, long expirationTime, Sequence.State state, boolean ackRequestedFlag, long lastMessageId, long lastActivityTime, long lastAcknowledgementRequestTime) {
        this.sequenceId = sequenceId;
        this.type = type;
        this.boundSecurityTokenReferenceId = securityContextTokenId;
        this.expirationTime = expirationTime;
        this.state = state;
        this.ackRequestedFlag = ackRequestedFlag;
        this.lastMessageId = lastMessageId;
        this.lastActivityTime = lastActivityTime;
        this.lastAcknowledgementRequestTime = lastAcknowledgementRequestTime;
        this.weakMessageStorage = new WeakHashMap<String, ApplicationMessage>();
        this.weakUnackedNumberToCorrelationIdMap = new WeakHashMap<Long, String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PersistentSequenceData insert(Connection sqlConnection, PersistentSequenceData data) throws DuplicateSequenceException {
        try {
            data.lockRead();
            PreparedStatement ps = sqlConnection.prepareStatement("INSERT INTO RM_SEQUENCES VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            int i = 0;
            ps.setString(++i, data.sequenceId);
            ps.setString(++i, data.type.id);
            ps.setTimestamp(++i, new Timestamp(data.expirationTime));
            ps.setNull(++i, 1);
            ps.setString(++i, data.boundSecurityTokenReferenceId);
            ps.setString(++i, data.state.name());
            ps.setString(++i, Boolean.toString(data.ackRequestedFlag));
            ps.setLong(++i, data.lastMessageId);
            ps.setTimestamp(++i, new Timestamp(data.lastActivityTime));
            ps.setTimestamp(++i, new Timestamp(data.lastAcknowledgementRequestTime));
            if (ps.executeUpdate() != 1) {
                // empty if block
            }
        }
        catch (SQLException ex) {
            LOGGER.logSevereException(ex);
        }
        finally {
            data.unlockRead();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PersistentSequenceData save(Connection sqlConnection, PersistentSequenceData data) {
        try {
            data.lockRead();
            PersistentSequenceData persistentSequenceData = data;
            return persistentSequenceData;
        }
        finally {
            data.unlockRead();
        }
    }

    static PersistentSequenceData load(Connection sqlConnection, String sequenceId, SequenceType type) {
        PersistentSequenceData data = null;
        return data;
    }

    static PersistentSequenceData remove(Connection sqlConnection, PersistentSequenceData data) {
        return data;
    }

    public void lockRead() {
        this.dataLock.readLock().lock();
    }

    public void unlockRead() {
        this.dataLock.readLock().unlock();
    }

    public void lockWrite() {
        this.dataLock.writeLock().lock();
    }

    public void unlockWrite() {
        this.dataLock.writeLock().unlock();
    }

    public String getSequenceId() {
        return this.sequenceId;
    }

    public String getBoundSecurityTokenReferenceId() {
        return this.boundSecurityTokenReferenceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastMessageId() {
        try {
            this.lockRead();
            long l = this.lastMessageId;
            return l;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastMessageId(long newLastMessageId) {
        try {
            this.lockWrite();
            this.lastMessageId = newLastMessageId;
        }
        finally {
            this.unlockWrite();
        }
    }

    public Sequence.State getState() {
        return this.state;
    }

    public void setState(Sequence.State newState) {
        this.state = newState;
    }

    public boolean getAckRequestedFlag() {
        return this.ackRequestedFlag;
    }

    public void setAckRequestedFlag(boolean newValue) {
        this.ackRequestedFlag = newValue;
    }

    public long getLastAcknowledgementRequestTime() {
        return this.lastAcknowledgementRequestTime;
    }

    public void setLastAcknowledgementRequestTime(long newTime) {
        this.lastAcknowledgementRequestTime = newTime;
    }

    public long getLastActivityTime() {
        return this.lastActivityTime;
    }

    public void setLastActivityTime(long newTime) {
        this.lastActivityTime = newTime;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void storeMessage(ApplicationMessage message, Long msgNumberKey) throws UnsupportedOperationException {
        assert (msgNumberKey != null);
        try {
            this.lockWrite();
            String correlationKey = new String(message.getCorrelationId());
            this.weakUnackedNumberToCorrelationIdMap.put(msgNumberKey, correlationKey);
            this.weakMessageStorage.put(correlationKey, message);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationMessage retrieveMessage(String correlationId) {
        try {
            this.lockRead();
            ApplicationMessage applicationMessage = this.weakMessageStorage.get(correlationId);
            return applicationMessage;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationMessage retrieveUnackedMessage(long messageNumber) {
        try {
            this.lockRead();
            String correlationKey = this.weakUnackedNumberToCorrelationIdMap.get(messageNumber);
            ApplicationMessage applicationMessage = correlationKey != null ? this.weakMessageStorage.get(correlationKey) : null;
            return applicationMessage;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SequenceType {
        INBOUND("IN"),
        OUTBOUND("OUT");

        private final String id;

        private SequenceType(String id) {
            this.id = id;
        }

        private static SequenceType toSequenceType(String id) {
            for (SequenceType st : SequenceType.values()) {
                if (!st.id.equals(id)) continue;
                return st;
            }
            return null;
        }
    }
}

