/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.ClientPipeAssemblerContext;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.ws.api.pipe.TransportTubeFactory;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;

public final class DeferredTransportPipe
extends AbstractTubeImpl {
    private Tube transport;
    private EndpointAddress address;
    private final ClassLoader classLoader;
    private final ClientTubeAssemblerContext context;

    public DeferredTransportPipe(ClassLoader classLoader, ClientPipeAssemblerContext context) {
        this(classLoader, new ClientTubeAssemblerContext(context.getAddress(), context.getWsdlModel(), context.getPortInfo(), context.getBinding(), context.getContainer(), context.getCodec(), context.getSEIModel()));
    }

    public DeferredTransportPipe(ClassLoader classLoader, ClientTubeAssemblerContext context) {
        this.classLoader = classLoader;
        this.context = context;
        try {
            this.transport = TransportTubeFactory.create(classLoader, context);
            this.address = context.getAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DeferredTransportPipe(DeferredTransportPipe that, TubeCloner cloner) {
        super(that, cloner);
        this.classLoader = that.classLoader;
        this.context = that.context;
        if (that.transport != null) {
            this.transport = ((PipeCloner)cloner).copy(that.transport);
            this.address = that.address;
        }
    }

    public NextAction processException(@NotNull Throwable t) {
        return this.transport.processException(t);
    }

    public NextAction processRequest(@NotNull Packet request) {
        if (request.endpointAddress == this.address) {
            return this.transport.processRequest(request);
        }
        if (this.transport != null) {
            this.transport.preDestroy();
            this.transport = null;
            this.address = null;
        }
        ClientTubeAssemblerContext newContext = new ClientTubeAssemblerContext(request.endpointAddress, this.context.getWsdlModel(), this.context.getPortInfo(), this.context.getBinding(), this.context.getContainer(), this.context.getCodec().copy(), this.context.getSEIModel());
        this.address = request.endpointAddress;
        this.transport = TransportTubeFactory.create(this.classLoader, newContext);
        assert (this.transport != null);
        return this.transport.processRequest(request);
    }

    public NextAction processResponse(@NotNull Packet response) {
        return this.transport.processResponse(response);
    }

    public void preDestroy() {
        if (this.transport != null) {
            this.transport.preDestroy();
            this.transport = null;
            this.address = null;
        }
    }

    public DeferredTransportPipe copy(TubeCloner cloner) {
        return new DeferredTransportPipe(this, cloner);
    }
}

