/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.threadpool;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.threadpool.ThreadPoolImpl;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.threadpool.NoSuchThreadPoolException;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPool;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPoolChooser;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPoolManager;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadPoolManagerImpl
implements ThreadPoolManager {
    private ThreadPool threadPool;
    private ThreadGroup threadGroup = this.getThreadGroup();
    private static final ORBUtilSystemException wrapper = ORB.getStaticLogWrapperTable().get_RPC_TRANSPORT_ORBUtil();
    private static AtomicInteger tgCount = new AtomicInteger();

    public ThreadPoolManagerImpl() {
        this.threadPool = new ThreadPoolImpl(this.threadGroup, "default-threadpool");
    }

    private ThreadGroup getThreadGroup() {
        ThreadGroup tg;
        try {
            tg = AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){

                @Override
                public ThreadGroup run() {
                    ThreadGroup tg;
                    ThreadGroup ptg = tg = Thread.currentThread().getThreadGroup();
                    try {
                        while (ptg != null) {
                            tg = ptg;
                            ptg = tg.getParent();
                        }
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    return new ThreadGroup(tg, "ORB ThreadGroup " + tgCount.getAndIncrement());
                }
            });
        }
        catch (SecurityException e) {
            tg = Thread.currentThread().getThreadGroup();
        }
        return tg;
    }

    public void close() {
        try {
            this.threadPool.close();
        }
        catch (IOException exc) {
            wrapper.threadPoolCloseError();
        }
        try {
            boolean isDestroyed = this.threadGroup.isDestroyed();
            int numThreads = this.threadGroup.activeCount();
            int numGroups = this.threadGroup.activeGroupCount();
            if (isDestroyed) {
                wrapper.threadGroupIsDestroyed(this.threadGroup);
            } else {
                if (numThreads > 0) {
                    wrapper.threadGroupHasActiveThreadsInClose(this.threadGroup, numThreads);
                }
                if (numGroups > 0) {
                    wrapper.threadGroupHasSubGroupsInClose(this.threadGroup, numGroups);
                }
                this.threadGroup.destroy();
            }
        }
        catch (IllegalThreadStateException exc) {
            wrapper.threadGroupDestroyFailed(exc, (Object)this.threadGroup);
        }
        this.threadGroup = null;
    }

    public ThreadPool getThreadPool(String threadpoolId) throws NoSuchThreadPoolException {
        return this.threadPool;
    }

    public ThreadPool getThreadPool(int numericIdForThreadpool) throws NoSuchThreadPoolException {
        return this.threadPool;
    }

    public int getThreadPoolNumericId(String threadpoolId) {
        return 0;
    }

    public String getThreadPoolStringId(int numericIdForThreadpool) {
        return "";
    }

    public ThreadPool getDefaultThreadPool() {
        return this.threadPool;
    }

    public ThreadPoolChooser getThreadPoolChooser(String componentId) {
        return null;
    }

    public ThreadPoolChooser getThreadPoolChooser(int componentIndex) {
        return null;
    }

    public void setThreadPoolChooser(String componentId, ThreadPoolChooser aThreadPoolChooser) {
    }

    public int getThreadPoolChooserNumericId(String componentId) {
        return 0;
    }
}

