/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.config.management.policy;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.config.management.ManagementMessages;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.policy.spi.AssertionCreationException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedServiceAssertion
extends PolicyAssertion {
    private static final Logger LOGGER = Logger.getLogger(ManagedServiceAssertion.class);
    private static final QName MANAGED_SERVICE_QNAME = new QName("http://java.sun.com/xml/ns/metro/management", "ManagedService");
    private static final QName ID_ATTRIBUTE_QNAME = new QName("", "id");
    private static final QName START_ATTRIBUTE_QNAME = new QName("", "start");
    private static final QName JMX_CONNECTOR_SERVER_ENVIRONMENT_PARAMETER_QNAME = new QName("http://java.sun.com/xml/ns/metro/management", "JMXConnectorServerEnvironment");
    private static final QName JMX_CONNECTOR_SERVER_ENVIRONMENT_ENTRY_PARAMETER_QNAME = new QName("http://java.sun.com/xml/ns/metro/management", "Entry");
    private static final QName JMX_CONNECTOR_SERVER_ENVIRONMENT_ENTRY_KEY_ATTRIBUTE_QNAME = new QName("", "key");
    private static final QName JMX_CONNECTOR_SERVER_ENVIRONMENT_ENTRY_VALUE_ATTRIBUTE_QNAME = new QName("", "value");
    private static final QName COMMUNICATION_SERVER_IMPLEMENTATIONS_PARAMETER_QNAME = new QName("http://java.sun.com/xml/ns/metro/management", "CommunicationServerImplementations");
    private static final QName COMMUNICATION_SERVER_IMPLEMENTATION_PARAMETER_QNAME = new QName("http://java.sun.com/xml/ns/metro/management", "CommunicationServerImplementation");
    private static final QName CONFIGURATOR_IMPLEMENTATION_PARAMETER_QNAME = new QName("http://java.sun.com/xml/ns/metro/management", "ConfiguratorImplementation");
    private static final QName CONFIG_SAVER_IMPLEMENTATION_PARAMETER_QNAME = new QName("http://java.sun.com/xml/ns/metro/management", "ConfigSaverImplementation");
    private static final QName CONFIG_READER_IMPLEMENTATION_PARAMETER_QNAME = new QName("http://java.sun.com/xml/ns/metro/management", "ConfigReaderImplementation");

    public ManagedServiceAssertion(AssertionData data, Collection<PolicyAssertion> assertionParameters, AssertionSet nestedAlternative) throws AssertionCreationException {
        super(data, assertionParameters, nestedAlternative);
        if (!MANAGED_SERVICE_QNAME.equals(data.getName())) {
            throw new AssertionCreationException(data, ManagementMessages.WSM_5011_EXPECTED_MANAGED_SERVICE_ASSERTION());
        }
        if (!data.containsAttribute(ID_ATTRIBUTE_QNAME)) {
            throw new AssertionCreationException(data, ManagementMessages.WSM_5012_MANAGED_SERVICE_MISSING_ID());
        }
    }

    public String getID() {
        return this.getAttributeValue(ID_ATTRIBUTE_QNAME);
    }

    public String getStart() {
        return this.getAttributeValue(START_ATTRIBUTE_QNAME);
    }

    public Map<String, String> getJMXConnectorServerEnvironment() {
        HashMap<String, String> result = new HashMap<String, String>();
        Iterator<PolicyAssertion> parameters = this.getParametersIterator();
        while (parameters.hasNext()) {
            PolicyAssertion parameter = parameters.next();
            if (!JMX_CONNECTOR_SERVER_ENVIRONMENT_PARAMETER_QNAME.equals(parameter.getName())) continue;
            Iterator<PolicyAssertion> entries = parameter.getParametersIterator();
            while (entries.hasNext()) {
                PolicyAssertion entry = entries.next();
                if (!JMX_CONNECTOR_SERVER_ENVIRONMENT_ENTRY_PARAMETER_QNAME.equals(entry.getName())) {
                    throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5006_UNEXPECTED_ENTRY(entry)));
                }
                String key = entry.getAttributeValue(JMX_CONNECTOR_SERVER_ENVIRONMENT_ENTRY_KEY_ATTRIBUTE_QNAME);
                String value = entry.getAttributeValue(JMX_CONNECTOR_SERVER_ENVIRONMENT_ENTRY_VALUE_ATTRIBUTE_QNAME);
                result.put(key, value);
            }
        }
        return result;
    }

    public Collection<String> getCommunicationServerImplementations() {
        LinkedList<String> result = new LinkedList<String>();
        Iterator<PolicyAssertion> parameters = this.getParametersIterator();
        while (parameters.hasNext()) {
            PolicyAssertion parameter = parameters.next();
            if (!COMMUNICATION_SERVER_IMPLEMENTATIONS_PARAMETER_QNAME.equals(parameter.getName())) continue;
            Iterator<PolicyAssertion> implementations = parameter.getParametersIterator();
            while (implementations.hasNext()) {
                PolicyAssertion implementation = implementations.next();
                if (!COMMUNICATION_SERVER_IMPLEMENTATION_PARAMETER_QNAME.equals(implementation.getName())) {
                    throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5013_EXPECTED_XML_TAG(COMMUNICATION_SERVER_IMPLEMENTATION_PARAMETER_QNAME, implementation.getName())));
                }
                String value = parameter.getValue();
                if (value != null) {
                    result.add(value.trim());
                    continue;
                }
                throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5014_XML_VALUE_EMPTY(COMMUNICATION_SERVER_IMPLEMENTATION_PARAMETER_QNAME)));
            }
        }
        return result;
    }

    public String getConfiguratorImplementation() {
        return this.getParameterValue(CONFIGURATOR_IMPLEMENTATION_PARAMETER_QNAME);
    }

    public String getConfigSaverImplementation() {
        return this.getParameterValue(CONFIG_SAVER_IMPLEMENTATION_PARAMETER_QNAME);
    }

    public String getConfigReaderImplementation() {
        return this.getParameterValue(CONFIG_READER_IMPLEMENTATION_PARAMETER_QNAME);
    }

    private String getParameterValue(QName name) {
        Iterator<PolicyAssertion> parameters = this.getParametersIterator();
        while (parameters.hasNext()) {
            PolicyAssertion parameter = parameters.next();
            if (!name.equals(parameter.getName())) continue;
            String value = parameter.getValue();
            if (value != null) {
                return value.trim();
            }
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5014_XML_VALUE_EMPTY(name)));
        }
        return null;
    }
}

