/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.mc.runtime;

import com.sun.istack.NotNull;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.rx.RxConfiguration;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.mc.protocol.wsmc200702.MakeConnectionElement;
import com.sun.xml.ws.rx.mc.protocol.wsmc200702.MessagePendingElement;
import com.sun.xml.ws.rx.util.FiberExecutor;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;

public class McServerTube
extends AbstractFilterTubeImpl {
    private static final Logger LOGGER = Logger.getLogger(McServerTube.class);
    private final RxConfiguration configuration;
    private final FiberExecutor fiberExecutor;
    private final ResponseStorage responseStorage;

    McServerTube(RxConfiguration configuration, Tube tubelineHead) {
        super(tubelineHead);
        this.configuration = configuration;
        this.fiberExecutor = new FiberExecutor("McServerTubeCommunicator", tubelineHead);
        this.responseStorage = new ResponseStorage();
    }

    McServerTube(McServerTube original, TubeCloner cloner) {
        super(original, cloner);
        this.configuration = original.configuration;
        this.fiberExecutor = original.fiberExecutor;
        this.responseStorage = original.responseStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractTubeImpl copy(TubeCloner cloner) {
        LOGGER.entering();
        try {
            McServerTube mcServerTube = new McServerTube(this, cloner);
            return mcServerTube;
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction processRequest(Packet request) {
        try {
            LOGGER.entering();
            assert (request.getMessage() != null) : "Unexpected [null] message in the server-side Tube.processRequest()";
            String clientUID = this.getClientUID(request);
            if (this.isMakeConnectionRequest(request)) {
                NextAction nextAction = this.handleMakeConnectionRequest(request, clientUID);
                return nextAction;
            }
            if (clientUID == null) {
                NextAction nextAction = super.processRequest(request);
                return nextAction;
            }
            request.getMessage().getHeaders().remove(this.configuration.getAddressingVersion().replyToTag);
            request.getMessage().getHeaders().remove(this.configuration.getAddressingVersion().faultToTag);
            Packet requestCopy = request.copy(true);
            this.fiberExecutor.start(request, new AppRequestProcessingCallback(this.responseStorage, clientUID, this.configuration));
            NextAction nextAction = super.doReturnWith(this.createEmptyResponse(requestCopy));
            return nextAction;
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction processResponse(Packet response) {
        try {
            LOGGER.entering();
            NextAction nextAction = super.processResponse(response);
            return nextAction;
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NextAction handleMakeConnectionRequest(Packet request, String clientUID) {
        try {
            String selectionUID;
            LOGGER.entering();
            try {
                MakeConnectionElement mcElement = (MakeConnectionElement)request.getMessage().readPayloadAsJAXB(this.configuration.getMcVersion().getUnmarshaller(this.configuration.getAddressingVersion()));
                selectionUID = this.configuration.getMcVersion().getClientId(mcElement.getAddress().getValue());
            }
            catch (JAXBException ex) {
                throw (RxRuntimeException)((Object)LOGGER.logSevereException((Throwable)((Object)new RxRuntimeException("Error unmarshalling content of a MakeConnection message", ex))));
            }
            if (selectionUID == null) {
                throw (RxRuntimeException)((Object)LOGGER.logSevereException((Throwable)((Object)new RxRuntimeException("Selection address is [null]."))));
            }
            if (!selectionUID.equals(clientUID)) {
                throw (RxRuntimeException)((Object)LOGGER.logSevereException((Throwable)((Object)new RxRuntimeException("Selection address does not match ReplyTo address."))));
            }
            Packet response = null;
            if (selectionUID != null && this.responseStorage.hasPendingResponse(selectionUID)) {
                LOGGER.finer(String.format("A pending message found for selection UUID [ %s ]", selectionUID));
                response = this.responseStorage.getPendingResponsePacket(selectionUID);
            }
            if (response == null) {
                LOGGER.finer(String.format("No pending message found for selection UUID [ %s ]", selectionUID));
                response = this.createEmptyResponse(request);
            } else {
                Message message = response.getMessage();
                if (message != null) {
                    HeaderList headers = message.getHeaders();
                    headers.add(Headers.create(this.configuration.getMcVersion().getJaxbContext(this.configuration.getAddressingVersion()), (Object)new MessagePendingElement(selectionUID != null && this.responseStorage.hasPendingResponse(selectionUID))));
                }
            }
            NextAction nextAction = super.doReturnWith(response);
            return nextAction;
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction processException(Throwable t) {
        try {
            LOGGER.entering();
            NextAction nextAction = super.processException(t);
            return nextAction;
        }
        finally {
            LOGGER.exiting();
        }
    }

    public void preDestroy() {
        super.preDestroy();
    }

    private String getClientUID(Packet request) {
        Header replyToHeader = request.getMessage().getHeaders().get(this.configuration.getAddressingVersion().replyToTag, false);
        if (replyToHeader != null) {
            try {
                String replyToAddress = replyToHeader.readAsEPR(this.configuration.getAddressingVersion()).getAddress();
                return this.configuration.getMcVersion().getClientId(replyToAddress);
            }
            catch (XMLStreamException ex) {
                throw (RxRuntimeException)((Object)LOGGER.logSevereException((Throwable)((Object)new RxRuntimeException("Error unmarshalling content of WS-A ReplyTo header", ex))));
            }
        }
        return null;
    }

    private boolean isMakeConnectionRequest(Packet request) {
        return this.configuration.getMcVersion().wsmcAction.equals(request.getMessage().getHeaders().getAction(this.configuration.getAddressingVersion(), this.configuration.getSoapVersion()));
    }

    private Packet createEmptyResponse(Packet request) {
        return request.createServerResponse(null, null, null, "");
    }

    private static final class AppRequestProcessingCallback
    implements Fiber.CompletionCallback {
        private static final Logger LOGGER = Logger.getLogger(AppRequestProcessingCallback.class);
        private final ResponseStorage responseStorage;
        private final String clientUID;
        private final RxConfiguration configuration;

        public AppRequestProcessingCallback(@NotNull ResponseStorage responseStorage, @NotNull String clientUID, @NotNull RxConfiguration configuration) {
            this.responseStorage = responseStorage;
            this.clientUID = clientUID;
            this.configuration = configuration;
        }

        public void onCompletion(Packet response) {
            LOGGER.finer(String.format("Request processing finished. Storing a response for client UUID [ %s ]", this.clientUID));
            if (response.getMessage() != null) {
                HeaderList headers = response.getMessage().getHeaders();
                headers.remove(this.configuration.getAddressingVersion().toTag);
                headers.add(Headers.create(this.configuration.getAddressingVersion().toTag, this.configuration.getMcVersion().getWsmcAnonymousAddress(this.clientUID)));
            }
            this.responseStorage.store(response, this.clientUID);
        }

        public void onCompletion(Throwable error) {
            LOGGER.severe(String.format("An exception has been thrown during a request processing for the client UID [ %s ]", this.clientUID), error);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ResponseStorage {
        final Map<String, Queue<Packet>> storage = new HashMap<String, Queue<Packet>>();
        final ReentrantReadWriteLock storageLock = new ReentrantReadWriteLock();

        private ResponseStorage() {
        }

        void store(@NotNull Packet response, @NotNull String clientUID) {
            if (!this.getClientQueue(clientUID).offer(response)) {
                LOGGER.severe(String.format("Storing response fo client UUID [ %s ] has failed.", clientUID));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Packet getPendingResponsePacket(@NotNull String clientUID) {
            try {
                this.storageLock.readLock().lock();
                Queue<Packet> clientQueue = this.storage.get(clientUID);
                Packet packet = clientQueue == null ? null : clientQueue.poll();
                return packet;
            }
            finally {
                this.storageLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean hasPendingResponse(@NotNull String clientUID) {
            try {
                this.storageLock.readLock().lock();
                Queue<Packet> clientQueue = this.storage.get(clientUID);
                boolean bl = clientQueue != null && !clientQueue.isEmpty();
                return bl;
            }
            finally {
                this.storageLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Queue<Packet> getClientQueue(@NotNull String clientUID) {
            try {
                this.storageLock.readLock().lock();
                Queue<Packet> clientQueue = this.storage.get(clientUID);
                if (clientQueue == null) {
                    this.storageLock.readLock().unlock();
                    try {
                        this.storageLock.writeLock().lock();
                        clientQueue = this.storage.get(clientUID);
                        if (clientQueue == null) {
                            clientQueue = new ConcurrentLinkedQueue<Packet>();
                            this.storage.put(clientUID, clientQueue);
                        }
                        this.storageLock.readLock().lock();
                    }
                    finally {
                        this.storageLock.writeLock().unlock();
                    }
                }
                Queue<Packet> queue = clientQueue;
                return queue;
            }
            finally {
                this.storageLock.readLock().unlock();
            }
        }
    }
}

