/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.persistent;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueueBuilder;
import com.sun.xml.ws.rx.rm.runtime.sequence.AbstractSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateSequenceException;
import com.sun.xml.ws.rx.rm.runtime.sequence.InboundSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.OutboundSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.UnknownSequenceException;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.ConnectionManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.PersistentSequenceData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.glassfish.gmbal.ManagedObjectManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PersistentSequenceManager
implements SequenceManager {
    private static final Logger LOGGER = Logger.getLogger(PersistentSequenceManager.class);
    private ConnectionManager cm;
    private final ReadWriteLock dataLock = new ReentrantReadWriteLock();
    private final Map<String, AbstractSequence> sequences = new HashMap<String, AbstractSequence>();
    private final Map<String, String> boundSequences = new HashMap<String, String>();
    private final ManagedObjectManager managedObjectManager;
    private final DeliveryQueueBuilder inboundQueueBuilder;
    private final DeliveryQueueBuilder outboundQueueBuilder;
    private final String uniqueEndpointId;

    public PersistentSequenceManager(String uniqueEndpointId, DeliveryQueueBuilder inboundQueueBuilder, DeliveryQueueBuilder outboundQueueBuilder, ManagedObjectManager managedObjectManager) {
        this.managedObjectManager = managedObjectManager;
        if (managedObjectManager != null) {
            managedObjectManager.registerAtRoot((Object)this, "RMSequenceManager");
        }
        this.uniqueEndpointId = uniqueEndpointId;
        this.inboundQueueBuilder = inboundQueueBuilder;
        this.outboundQueueBuilder = outboundQueueBuilder;
        this.cm = ConnectionManager.getInstance();
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public String uniqueEndpointId() {
        return this.uniqueEndpointId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Sequence> sequences() {
        try {
            this.dataLock.readLock().lock();
            HashMap<String, Sequence> hashMap = new HashMap<String, Sequence>(this.sequences);
            return hashMap;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> boundSequences() {
        try {
            this.dataLock.readLock().lock();
            HashMap<String, String> hashMap = new HashMap<String, String>(this.boundSequences);
            return hashMap;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    @Override
    public Sequence createOutboundSequence(String sequenceId, String strId, long expirationTime) throws DuplicateSequenceException {
        PersistentSequenceData data = PersistentSequenceData.newInstance(this.cm, this.uniqueEndpointId, sequenceId, PersistentSequenceData.SequenceType.Outbound, strId, expirationTime, Sequence.State.CREATED, false, 0L, this.currentTimeInMillis(), 0L);
        return this.registerSequence(new OutboundSequence(data, this.outboundQueueBuilder, this), data.getBoundSequenceId());
    }

    @Override
    public Sequence createInboundSequence(String sequenceId, String strId, long expirationTime) throws DuplicateSequenceException {
        PersistentSequenceData data = PersistentSequenceData.newInstance(this.cm, this.uniqueEndpointId, sequenceId, PersistentSequenceData.SequenceType.Inbound, strId, expirationTime, Sequence.State.CREATED, false, 0L, this.currentTimeInMillis(), 0L);
        return this.registerSequence(new InboundSequence(data, this.inboundQueueBuilder, this), data.getBoundSequenceId());
    }

    @Override
    public String generateSequenceUID() {
        return "uuid:" + UUID.randomUUID();
    }

    @Override
    public Sequence closeSequence(String sequenceId) throws UnknownSequenceException {
        Sequence sequence = this.getSequence(sequenceId);
        sequence.close();
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence getSequence(String sequenceId) throws UnknownSequenceException {
        this.checkIfExist(sequenceId);
        try {
            this.dataLock.readLock().lock();
            Sequence sequence = this.sequences.get(sequenceId);
            return sequence;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(String sequenceId) {
        Sequence s;
        try {
            this.dataLock.readLock().lock();
            s = this.sequences.get(sequenceId);
        }
        finally {
            this.dataLock.readLock().unlock();
        }
        if (s == null) {
            s = this.fetch(sequenceId);
        }
        return s != null && s.getState() != Sequence.State.TERMINATING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfExist(String ... sequenceIds) throws UnknownSequenceException {
        for (String sequenceId : sequenceIds) {
            Sequence s;
            try {
                this.dataLock.readLock().lock();
                s = this.sequences.get(sequenceId);
            }
            finally {
                this.dataLock.readLock().unlock();
            }
            if (s == null) {
                s = this.fetch(sequenceId);
            }
            if (s != null) continue;
            throw new UnknownSequenceException(sequenceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence fetch(String sequenceId) {
        this.dataLock.writeLock().lock();
        try {
            if (this.sequences.containsKey(sequenceId)) {
                Sequence sequence = this.sequences.get(sequenceId);
                return sequence;
            }
            PersistentSequenceData sequenceData = PersistentSequenceData.loadInstance(this.cm, this.uniqueEndpointId, sequenceId);
            if (sequenceData != null) {
                switch (sequenceData.getType()) {
                    case Inbound: {
                        AbstractSequence abstractSequence = this.registerSequence(new InboundSequence(sequenceData, this.inboundQueueBuilder, this), sequenceData.getBoundSequenceId());
                        return abstractSequence;
                    }
                    case Outbound: {
                        AbstractSequence abstractSequence = this.registerSequence(new OutboundSequence(sequenceData, this.outboundQueueBuilder, this), sequenceData.getBoundSequenceId());
                        return abstractSequence;
                    }
                }
            }
            Sequence sequence = null;
            return sequence;
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence terminateSequence(String sequenceId) throws UnknownSequenceException {
        try {
            this.dataLock.writeLock().lock();
            this.checkIfExist(sequenceId);
            AbstractSequence sequence = this.sequences.remove(sequenceId);
            sequence.setState(Sequence.State.TERMINATING);
            if (this.boundSequences.containsKey(sequenceId)) {
                this.boundSequences.remove(sequenceId);
            }
            if (this.managedObjectManager != null) {
                this.managedObjectManager.unregister((Object)sequence);
            }
            PersistentSequenceData.remove(this.cm, this.uniqueEndpointId, sequenceId);
            sequence.preDestroy();
            AbstractSequence abstractSequence = sequence;
            return abstractSequence;
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindSequences(String referenceSequenceId, String boundSequenceId) throws UnknownSequenceException {
        try {
            this.dataLock.writeLock().lock();
            this.checkIfExist(referenceSequenceId, boundSequenceId);
            PersistentSequenceData.bind(this.cm, this.uniqueEndpointId, referenceSequenceId, boundSequenceId);
            this.boundSequences.put(referenceSequenceId, boundSequenceId);
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence getBoundSequence(String referenceSequenceId) throws UnknownSequenceException {
        this.checkIfExist(referenceSequenceId);
        try {
            this.dataLock.readLock().lock();
            AbstractSequence abstractSequence = this.boundSequences.containsKey(referenceSequenceId) ? this.sequences.get(this.boundSequences.get(referenceSequenceId)) : null;
            return abstractSequence;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractSequence registerSequence(AbstractSequence sequence, String boundSequenceId) {
        try {
            this.dataLock.writeLock().lock();
            this.sequences.put(sequence.getId(), sequence);
            if (this.managedObjectManager != null) {
                this.managedObjectManager.register((Object)this, (Object)sequence, sequence.getId().replace(':', '-'));
            }
            if (boundSequenceId != null) {
                this.checkIfExist(boundSequenceId);
                this.boundSequences.put(sequence.getId(), boundSequenceId);
            }
            AbstractSequence abstractSequence = sequence;
            return abstractSequence;
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    @Override
    public long currentTimeInMillis() {
        return System.currentTimeMillis();
    }
}

