/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider.wsit;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.security.core.ai.IdentityType;
import com.sun.xml.stream.buffer.XMLStreamBufferResult;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.server.EndpointComponent;
import com.sun.xml.ws.api.server.EndpointReferenceExtensionContributor;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.opt.impl.util.JAXBUtil;
import com.sun.xml.ws.security.secext10.BinarySecurityTokenType;
import com.sun.xml.ws.security.secext10.ObjectFactory;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.jaxws.impl.ServerTubeConfiguration;
import com.sun.xml.wss.jaxws.impl.TubeConfiguration;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityComponent
implements EndpointComponent {
    protected TubeConfiguration pipeConfig = null;
    protected PolicyMap pm = null;
    protected WSEndpoint e = null;
    protected Map props = null;
    private Certificate cs = null;
    protected SOAPVersion sp = null;
    protected static final Logger log = Logger.getLogger("com.sun.xml.wss.provider.wsit", "com.sun.xml.wss.provider.wsit.logging.LogStrings");

    public IdentityComponent(WSEndpoint e, PolicyMap pm, Map props) {
        this.pm = pm;
        this.e = e;
        this.props = props;
        this.sp = e.getBinding().getSOAPVersion();
        URL url = null;
        try {
            url = SecurityUtil.loadFromClasspath("META-INF/ServerCertificate.cert");
            if (url == null) {
                this.getServerKeyStore();
            } else {
                CertificateFactory certFact = CertificateFactory.getInstance("X.509");
                InputStream is = url.openStream();
                this.cs = certFact.generateCertificate(is);
                is.close();
            }
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        catch (CertificateException ex) {
            log.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public <T> T getSPI(@NotNull Class<T> spiType) {
        if (spiType.isAssignableFrom(EndpointReferenceExtensionContributor.class)) {
            return (T)new IdentityEPRExtnContributor();
        }
        return null;
    }

    public void getServerKeyStore() throws IOException {
        String alias = null;
        String password = null;
        String location = null;
        FileInputStream fis = null;
        WSDLPort port = (WSDLPort)this.props.get("WSDL_MODEL");
        this.pipeConfig = new ServerTubeConfiguration(this.pm, port, this.e);
        QName serviceName = this.pipeConfig.getWSDLPort().getOwner().getName();
        QName portName = this.pipeConfig.getWSDLPort().getName();
        QName keyStoreQName = new QName("http://schemas.sun.com/2006/03/wss/server", "KeyStore");
        PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey(serviceName, portName);
        try {
            Policy ep = this.pm.getEndpointEffectivePolicy(endpointKey);
            block11: for (AssertionSet assertionSet : ep) {
                for (PolicyAssertion pa : assertionSet) {
                    if (!PolicyUtil.isConfigPolicyAssertion(pa) || !pa.getName().equals(keyStoreQName)) continue;
                    HashMap atts = (HashMap)pa.getAttributes();
                    Set ks = atts.keySet();
                    for (QName name : ks) {
                        if (name.getLocalPart().equals("storepass")) {
                            password = (String)atts.get(name);
                            continue;
                        }
                        if (name.getLocalPart().equals("location")) {
                            location = (String)atts.get(name);
                            if (!location.startsWith("$WSIT")) continue;
                            String path = System.getProperty("WSIT_HOME");
                            StringBuffer sb = new StringBuffer(location);
                            sb.replace(0, 10, path);
                            location = sb.toString();
                            continue;
                        }
                        if (!name.getLocalPart().equals("alias")) continue;
                        alias = (String)atts.get(name);
                    }
                    if (password == null || location == null || alias == null) {
                        return;
                    }
                    KeyStore keyStore = null;
                    try {
                        keyStore = KeyStore.getInstance("JKS");
                        fis = new FileInputStream(location);
                        keyStore.load(fis, password.toCharArray());
                        this.cs = keyStore.getCertificate(alias);
                    }
                    catch (FileNotFoundException ex) {
                        log.log(Level.SEVERE, null, ex);
                        throw new XWSSecurityException(ex);
                    }
                    catch (IOException ex) {
                        log.log(Level.SEVERE, null, ex);
                        throw new RuntimeException(ex);
                    }
                    catch (NoSuchAlgorithmException ex) {
                        log.log(Level.SEVERE, null, ex);
                        throw new XWSSecurityException(ex);
                    }
                    catch (CertificateException ex) {
                        log.log(Level.SEVERE, null, ex);
                        throw new XWSSecurityException(ex);
                    }
                    catch (KeyStoreException ex) {
                        log.log(Level.SEVERE, null, ex);
                        throw new XWSSecurityException(ex);
                    }
                    finally {
                        keyStore = null;
                        fis.close();
                        continue block11;
                    }
                }
            }
        }
        catch (PolicyException ex) {
            log.log(Level.SEVERE, null, ex);
        }
    }

    public XMLStreamReader readHeader(IdentityType identityElem) throws XMLStreamException {
        XMLStreamBufferResult xbr = new XMLStreamBufferResult();
        JAXBElement<IdentityType> idElem = new com.sun.xml.security.core.ai.ObjectFactory().createIdentity(identityElem);
        try {
            JAXBContext context = JAXBUtil.getJAXBContext();
            Marshaller m = context.createMarshaller();
            m.setProperty("com.sun.xml.bind.xmlDeclaration", (Object)false);
            m.marshal(idElem, (Result)xbr);
        }
        catch (JAXBException je) {
            log.log(Level.SEVERE, null, je);
            throw new XMLStreamException(je);
        }
        return xbr.getXMLStreamBuffer().readAsXMLStreamReader();
    }

    class IdentityEPRExtnContributor
    extends EndpointReferenceExtensionContributor {
        QName ID_QNAME = new QName("http://schemas.xmlsoap.org/ws/2006/02/addressingidentity", "Identity");

        IdentityEPRExtnContributor() {
        }

        public WSEndpointReference.EPRExtension getEPRExtension(@Nullable WSEndpointReference.EPRExtension extension) {
            return new WSEndpointReference.EPRExtension(){

                public XMLStreamReader readAsXMLStreamReader() throws XMLStreamException {
                    XMLStreamReader reader = null;
                    try {
                        String id = PolicyUtil.randomUUID();
                        BinarySecurityTokenType bst = new BinarySecurityTokenType();
                        bst.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
                        bst.setId(id);
                        bst.setEncodingType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
                        if (IdentityComponent.this.cs != null) {
                            bst.setValue(IdentityComponent.this.cs.getEncoded());
                        }
                        JAXBElement<BinarySecurityTokenType> bstElem = new ObjectFactory().createBinarySecurityToken(bst);
                        IdentityType identityElement = new IdentityType();
                        identityElement.getDnsOrSpnOrUpn().add(bstElem);
                        reader = IdentityComponent.this.readHeader(identityElement);
                    }
                    catch (CertificateEncodingException ex) {
                        log.log(Level.SEVERE, null, ex);
                    }
                    return reader;
                }

                public QName getQName() {
                    return IdentityEPRExtnContributor.this.ID_QNAME;
                }
            };
        }

        public QName getQName() {
            return this.ID_QNAME;
        }
    }
}

