/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.recovery;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsClassLoaderUtil;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.service.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.util.ConnectionPoolObjectsUtils;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.ResourcePrincipal;
import com.sun.enterprise.resource.deployer.ConnectorResourceDeployer;
import com.sun.enterprise.resource.recovery.ResourcesHelper;
import com.sun.enterprise.transaction.spi.RecoveryResourceHandler;
import com.sun.logging.LogDomains;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.glassfish.api.Startup;
import org.glassfish.api.admin.config.Property;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ConnectorsRecoveryResourceHandler
implements RecoveryResourceHandler {
    @Inject
    private ResourcesHelper resourcesHelper;
    @Inject
    private ConnectorsClassLoaderUtil cclUtil;
    @Inject
    private Habitat connectorRuntimeHabitat;
    @Inject
    private Habitat connectorResourceDeployerHabitat;
    @Inject
    private Habitat applicationLoaderServiceHabitat;
    private static Logger _logger = LogDomains.getLogger(ConnectorsRecoveryResourceHandler.class, (String)"javax.enterprise.resource.resourceadapter");

    private void loadAllConnectorResources() {
        block9: {
            try {
                List<Resource> connResources = this.getConnectorResources();
                InitialContext ic = new InitialContext();
                for (Resource resource : connResources) {
                    ConnectorResource connResource = (ConnectorResource)resource;
                    if (!this.isEnabled(connResource)) continue;
                    try {
                        ic.lookup(connResource.getJndiName());
                    }
                    catch (NamingException ne) {
                        try {
                            ConnectorConnectionPool connConnectionPool = this.getConnectorConnectionPoolByName(connResource.getPoolName());
                            this.createActiveResourceAdapter(connConnectionPool.getResourceAdapterName());
                            this.getConnectorResourceDeployer().deployResource(connResource);
                        }
                        catch (Exception ex) {
                            _logger.log(Level.SEVERE, "error.loading.connector.resources.during.recovery", connResource.getJndiName());
                            if (_logger.isLoggable(Level.FINE)) {
                                _logger.log(Level.FINE, ne.toString(), ne);
                            }
                            _logger.log(Level.SEVERE, "error.loading.connector.resources.during.recovery", connResource.getJndiName());
                            if (!_logger.isLoggable(Level.FINE)) continue;
                            _logger.log(Level.FINE, ex.toString(), ex);
                        }
                    }
                    catch (Exception ex) {
                        _logger.log(Level.SEVERE, "error.loading.connector.resources.during.recovery", connResource.getJndiName());
                        if (!_logger.isLoggable(Level.FINE)) continue;
                        _logger.log(Level.FINE, ex.toString(), ex);
                    }
                }
            }
            catch (NamingException ne) {
                _logger.log(Level.SEVERE, "error.loading.connector.resources.during.recovery", ne.getMessage());
                if (!_logger.isLoggable(Level.FINE)) break block9;
                _logger.log(Level.FINE, ne.toString(), ne);
            }
        }
    }

    private ConnectorResourceDeployer getConnectorResourceDeployer() {
        return (ConnectorResourceDeployer)this.connectorResourceDeployerHabitat.getComponent(ConnectorResourceDeployer.class);
    }

    private ConnectorConnectionPool getConnectorConnectionPoolByName(String poolName) {
        ConnectorConnectionPool result = null;
        List<Resource> ccPools = this.resourcesHelper.getAllResourcesOfType(ConnectorConnectionPool.class);
        for (Resource resource : ccPools) {
            ConnectorConnectionPool ccp = (ConnectorConnectionPool)resource;
            if (!ccp.getName().equals(poolName)) continue;
            result = ccp;
            break;
        }
        return result;
    }

    private List<Resource> getConnectorResources() {
        return this.resourcesHelper.getAllResourcesOfType(ConnectorResource.class);
    }

    public void loadXAResourcesAndItsConnections(List xaresList, List connList) {
        List<Resource> connectorResources = this.getConnectorResources();
        if (connectorResources == null || connectorResources.size() == 0) {
            return;
        }
        ConnectorRuntime crt = (ConnectorRuntime)this.connectorRuntimeHabitat.getComponent(ConnectorRuntime.class);
        this.applicationLoaderServiceHabitat.getComponent(Startup.class, "ApplicationLoaderService");
        ArrayList<ConnectorConnectionPool> connPools = new ArrayList<ConnectorConnectionPool>();
        for (Resource resource : connectorResources) {
            ConnectorConnectionPool pool;
            ConnectorResource connResource = (ConnectorResource)resource;
            if (!this.isEnabled(connResource) || (pool = this.getConnectorConnectionPoolByName(connResource.getPoolName())) == null || !"XATransaction".equals(this.getTransactionSupport(pool))) continue;
            connPools.add(pool);
            if (!_logger.isLoggable(Level.FINE)) continue;
            _logger.fine("ConnectorsRecoveryResourceHandler loadXAResourcesAndItsConnections :: adding : " + connResource.getPoolName());
        }
        this.loadAllConnectorResources();
        _logger.log(Level.FINE, "Recovering pools : " + connPools.size());
        for (ConnectorConnectionPool connPool : connPools) {
            String poolName = connPool.getName();
            try {
                String rarName;
                String[] dbUserPassword = this.getdbUserPasswordOfConnectorConnectionPool(connPool);
                if (dbUserPassword == null) continue;
                String dbUser = dbUserPassword[0];
                String dbPassword = dbUserPassword[1];
                Subject subject = new Subject();
                if (dbPassword == null) {
                    dbPassword = "";
                    _logger.log(Level.WARNING, "datasource.xadatasource_nullpassword_error", poolName);
                }
                if (dbUser == null) {
                    dbUser = "";
                    _logger.log(Level.WARNING, "datasource.xadatasource_nulluser_error", poolName);
                }
                if (ConnectorAdminServiceUtils.isJMSRA(rarName = connPool.getResourceAdapterName())) {
                    _logger.log(Level.FINE, "Performing recovery for JMS RA, poolName  " + poolName);
                    ManagedConnectionFactory[] mcfs = crt.obtainManagedConnectionFactories(poolName);
                    _logger.log(Level.INFO, "JMS resource recovery has created CFs = " + mcfs.length);
                    for (int i = 0; i < mcfs.length; ++i) {
                        PasswordCredential pc = new PasswordCredential(dbUser, dbPassword.toCharArray());
                        pc.setManagedConnectionFactory(mcfs[i]);
                        ResourcePrincipal prin = new ResourcePrincipal(dbUser, dbPassword);
                        subject.getPrincipals().add((Principal)prin);
                        subject.getPrivateCredentials().add(pc);
                        ManagedConnection mc = mcfs[i].createManagedConnection(subject, null);
                        connList.add(mc);
                        try {
                            XAResource xares = mc.getXAResource();
                            if (xares == null) continue;
                            xaresList.add(xares);
                            continue;
                        }
                        catch (ResourceException ex) {
                            // empty catch block
                        }
                    }
                    continue;
                }
                ManagedConnectionFactory mcf = crt.obtainManagedConnectionFactory(poolName);
                PasswordCredential pc = new PasswordCredential(dbUser, dbPassword.toCharArray());
                pc.setManagedConnectionFactory(mcf);
                ResourcePrincipal prin = new ResourcePrincipal(dbUser, dbPassword);
                subject.getPrincipals().add((Principal)prin);
                subject.getPrivateCredentials().add(pc);
                ManagedConnection mc = mcf.createManagedConnection(subject, null);
                connList.add(mc);
                try {
                    XAResource xares = mc.getXAResource();
                    if (xares == null) continue;
                    xaresList.add(xares);
                }
                catch (ResourceException ex) {
                }
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "datasource.xadatasource_error", poolName);
                _logger.log(Level.FINE, "datasource.xadatasource_error_excp", ex);
            }
        }
        _logger.log(Level.FINE, "Total XAResources identified for recovery is " + xaresList.size());
        _logger.log(Level.FINE, "Total connections identified for recovery is " + connList.size());
    }

    private String getTransactionSupport(ConnectorConnectionPool pool) {
        String txSupport = pool.getTransactionSupport();
        if (txSupport != null) {
            return txSupport;
        }
        try {
            txSupport = ConnectorRuntime.getRuntime().getConnectorDescriptor(pool.getResourceAdapterName()).getOutboundResourceAdapter().getTransSupport();
        }
        catch (ConnectorRuntimeException cre) {
            _logger.log(Level.WARNING, cre.getMessage());
            _logger.finest("setting no-tx-support as tx-support-level for pool : " + pool.getName());
            txSupport = "NoTransaction";
        }
        return txSupport;
    }

    public void closeConnections(List connList) {
        for (Object obj : connList) {
            try {
                ((ManagedConnection)obj).destroy();
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "Connector Resource could not be closed", ex);
            }
        }
    }

    private boolean isEnabled(ConnectorResource resource) {
        return Boolean.valueOf(resource.getEnabled());
    }

    private String[] getdbUserPasswordOfConnectorConnectionPool(ConnectorConnectionPool connectorConnectionPool) {
        String[] userPassword = new String[]{null, null};
        List properties = connectorConnectionPool.getProperty();
        if (properties != null) {
            boolean foundUserPassword = false;
            for (Property elementProperty : properties) {
                String prop = elementProperty.getName().toUpperCase();
                if ("USERNAME".equals(prop) || "USER".equals(prop)) {
                    userPassword[0] = elementProperty.getValue();
                    foundUserPassword = true;
                    continue;
                }
                if (!"PASSWORD".equals(prop)) continue;
                userPassword[1] = elementProperty.getValue();
                foundUserPassword = true;
            }
            if (foundUserPassword) {
                return userPassword;
            }
        }
        String poolName = connectorConnectionPool.getName();
        String rarName = connectorConnectionPool.getResourceAdapterName();
        String connectionDefName = connectorConnectionPool.getConnectionDefinitionName();
        ConnectorRegistry connectorRegistry = ConnectorRegistry.getInstance();
        ConnectorDescriptor connectorDescriptor = connectorRegistry.getDescriptor(rarName);
        ConnectionDefDescriptor cdd = connectorDescriptor.getConnectionDefinitionByCFType(connectionDefName);
        Set configProps = cdd.getConfigProperties();
        for (ConnectorConfigProperty envProp : configProps) {
            String prop = envProp.getName().toUpperCase();
            if ("USER".equals(prop) || "USERNAME".equals(prop)) {
                userPassword[0] = envProp.getValue();
                continue;
            }
            if (!"PASSWORD".equals(prop)) continue;
            userPassword[1] = envProp.getValue();
        }
        if (userPassword[0] != null && !"".equals(userPassword[0].trim())) {
            return userPassword;
        }
        ManagedConnectionFactory mcf = connectorRegistry.getManagedConnectionFactory(poolName);
        userPassword[0] = ConnectionPoolObjectsUtils.getValueFromMCF("UserName", poolName, mcf);
        userPassword[1] = ConnectionPoolObjectsUtils.getValueFromMCF("Password", poolName, mcf);
        return userPassword;
    }

    private void createActiveResourceAdapter(String rarModuleName) throws ConnectorRuntimeException {
        ConnectorRuntime cr = ConnectorRuntime.getRuntime();
        ConnectorRegistry creg = ConnectorRegistry.getInstance();
        if (creg.isRegistered(rarModuleName)) {
            return;
        }
        if (ConnectorAdminServiceUtils.isEmbeddedConnectorModule(rarModuleName)) {
            cr.createActiveResourceAdapterForEmbeddedRar(rarModuleName);
        } else {
            String moduleDir = ConfigBeansUtilities.getLocation((String)rarModuleName);
            ClassLoader loader = cr.createConnectorClassLoader(moduleDir, null);
            cr.createActiveResourceAdapter(moduleDir, rarModuleName, loader);
        }
    }
}

