/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.org.objectweb.asm.xml;

import com.sun.corba.ee.org.objectweb.asm.AnnotationVisitor;
import com.sun.corba.ee.org.objectweb.asm.Attribute;
import com.sun.corba.ee.org.objectweb.asm.Label;
import com.sun.corba.ee.org.objectweb.asm.MethodVisitor;
import com.sun.corba.ee.org.objectweb.asm.Type;
import com.sun.corba.ee.org.objectweb.asm.util.AbstractVisitor;
import com.sun.corba.ee.org.objectweb.asm.xml.SAXAdapter;
import com.sun.corba.ee.org.objectweb.asm.xml.SAXAnnotationAdapter;
import com.sun.corba.ee.org.objectweb.asm.xml.SAXClassAdapter;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public final class SAXCodeAdapter
extends SAXAdapter
implements MethodVisitor {
    private Map labelNames = new HashMap();

    public SAXCodeAdapter(ContentHandler h, int access) {
        super(h);
        if ((access & 0x700) == 0) {
            this.addStart("code", new AttributesImpl());
        }
    }

    public final void visitCode() {
    }

    public final void visitInsn(int opcode) {
        this.addElement(AbstractVisitor.OPCODES[opcode], new AttributesImpl());
    }

    public final void visitIntInsn(int opcode, int operand) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "value", "value", "", Integer.toString(operand));
        this.addElement(AbstractVisitor.OPCODES[opcode], attrs);
    }

    public final void visitVarInsn(int opcode, int var) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "var", "var", "", Integer.toString(var));
        this.addElement(AbstractVisitor.OPCODES[opcode], attrs);
    }

    public final void visitTypeInsn(int opcode, String desc) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "desc", "desc", "", desc);
        this.addElement(AbstractVisitor.OPCODES[opcode], attrs);
    }

    public final void visitFieldInsn(int opcode, String owner, String name, String desc) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "owner", "owner", "", owner);
        attrs.addAttribute("", "name", "name", "", name);
        attrs.addAttribute("", "desc", "desc", "", desc);
        this.addElement(AbstractVisitor.OPCODES[opcode], attrs);
    }

    public final void visitMethodInsn(int opcode, String owner, String name, String desc) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "owner", "owner", "", owner);
        attrs.addAttribute("", "name", "name", "", name);
        attrs.addAttribute("", "desc", "desc", "", desc);
        this.addElement(AbstractVisitor.OPCODES[opcode], attrs);
    }

    public final void visitJumpInsn(int opcode, Label label) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "label", "label", "", this.getLabel(label));
        this.addElement(AbstractVisitor.OPCODES[opcode], attrs);
    }

    public final void visitLabel(Label label) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "name", "name", "", this.getLabel(label));
        this.addElement("Label", attrs);
    }

    public final void visitLdcInsn(Object cst) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "cst", "cst", "", SAXClassAdapter.encode(cst.toString()));
        attrs.addAttribute("", "desc", "desc", "", Type.getDescriptor(cst.getClass()));
        this.addElement(AbstractVisitor.OPCODES[18], attrs);
    }

    public final void visitIincInsn(int var, int increment) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "var", "var", "", Integer.toString(var));
        attrs.addAttribute("", "inc", "inc", "", Integer.toString(increment));
        this.addElement(AbstractVisitor.OPCODES[132], attrs);
    }

    public final void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "min", "min", "", Integer.toString(min));
        attrs.addAttribute("", "max", "max", "", Integer.toString(max));
        attrs.addAttribute("", "dflt", "dflt", "", this.getLabel(dflt));
        String o = AbstractVisitor.OPCODES[170];
        this.addStart(o, attrs);
        for (int i = 0; i < labels.length; ++i) {
            AttributesImpl att2 = new AttributesImpl();
            att2.addAttribute("", "name", "name", "", this.getLabel(labels[i]));
            this.addElement("label", att2);
        }
        this.addEnd(o);
    }

    public final void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        AttributesImpl att = new AttributesImpl();
        att.addAttribute("", "dflt", "dflt", "", this.getLabel(dflt));
        String o = AbstractVisitor.OPCODES[171];
        this.addStart(o, att);
        for (int i = 0; i < labels.length; ++i) {
            AttributesImpl att2 = new AttributesImpl();
            att2.addAttribute("", "name", "name", "", this.getLabel(labels[i]));
            att2.addAttribute("", "key", "key", "", Integer.toString(keys[i]));
            this.addElement("label", att2);
        }
        this.addEnd(o);
    }

    public final void visitMultiANewArrayInsn(String desc, int dims) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "desc", "desc", "", desc);
        attrs.addAttribute("", "dims", "dims", "", Integer.toString(dims));
        this.addElement(AbstractVisitor.OPCODES[197], attrs);
    }

    public final void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "start", "start", "", this.getLabel(start));
        attrs.addAttribute("", "end", "end", "", this.getLabel(end));
        attrs.addAttribute("", "handler", "handler", "", this.getLabel(handler));
        if (type != null) {
            attrs.addAttribute("", "type", "type", "", type);
        }
        this.addElement("TryCatch", attrs);
    }

    public final void visitMaxs(int maxStack, int maxLocals) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "maxStack", "maxStack", "", Integer.toString(maxStack));
        attrs.addAttribute("", "maxLocals", "maxLocals", "", Integer.toString(maxLocals));
        this.addElement("Max", attrs);
        this.addEnd("code");
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "name", "name", "", name);
        attrs.addAttribute("", "desc", "desc", "", desc);
        if (signature != null) {
            attrs.addAttribute("", "signature", "signature", "", SAXClassAdapter.encode(signature));
        }
        attrs.addAttribute("", "start", "start", "", this.getLabel(start));
        attrs.addAttribute("", "end", "end", "", this.getLabel(end));
        attrs.addAttribute("", "var", "var", "", Integer.toString(index));
        this.addElement("LocalVar", attrs);
    }

    public final void visitLineNumber(int line, Label start) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "line", "line", "", Integer.toString(line));
        attrs.addAttribute("", "start", "start", "", this.getLabel(start));
        this.addElement("LineNumber", attrs);
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return new SAXAnnotationAdapter(this.getContentHandler(), "annotationDefault", 0, null, null);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return new SAXAnnotationAdapter(this.getContentHandler(), "annotation", visible ? 1 : -1, null, desc);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        return new SAXAnnotationAdapter(this.getContentHandler(), "parameterAnnotation", visible ? 1 : -1, parameter, desc);
    }

    public void visitEnd() {
        this.addEnd("method");
    }

    public final void visitAttribute(Attribute attr) {
    }

    private final String getLabel(Label label) {
        String name = (String)this.labelNames.get(label);
        if (name == null) {
            name = Integer.toString(this.labelNames.size());
            this.labelNames.put(label, name);
        }
        return name;
    }
}

