/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.MetadataColumn;

public abstract class RelationalColumnMetadata
extends MetadataColumn {
    private String m_referencedColumnName;

    public RelationalColumnMetadata(MetadataAnnotation relationalColumn, MetadataAccessibleObject accessibleObject) {
        super(relationalColumn, accessibleObject);
        if (relationalColumn != null) {
            this.m_referencedColumnName = (String)relationalColumn.getAttribute("referencedColumnName");
        }
    }

    protected RelationalColumnMetadata(String xmlElement) {
        super(xmlElement);
    }

    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof RelationalColumnMetadata) {
            RelationalColumnMetadata relationalColumn = (RelationalColumnMetadata)objectToCompare;
            return this.valuesMatch(this.m_referencedColumnName, relationalColumn.getReferencedColumnName());
        }
        return false;
    }

    public DatabaseField getForeignKeyField() {
        return super.getDatabaseField();
    }

    public DatabaseField getPrimaryKeyField() {
        DatabaseField pkField = new DatabaseField();
        pkField.setName(this.m_referencedColumnName == null ? "" : this.m_referencedColumnName);
        return pkField;
    }

    public String getReferencedColumnName() {
        return this.m_referencedColumnName;
    }

    public boolean isForeignKeyFieldNotSpecified() {
        return this.getName() == null || this.getName().equals("");
    }

    public boolean isPrimaryKeyFieldNotSpecified() {
        return this.m_referencedColumnName == null || this.m_referencedColumnName.equals("");
    }

    public void setReferencedColumnName(String referencedColumnName) {
        this.m_referencedColumnName = referencedColumnName;
    }
}

