/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl.managedbean;

import com.sun.enterprise.container.common.impl.managedbean.ManagedBeanNamingProxy;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.logging.LogDomains;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.interceptor.InterceptorInfo;
import org.glassfish.api.interceptor.InterceptorInvoker;
import org.glassfish.api.interceptor.JavaEEInterceptorBuilder;
import org.glassfish.api.interceptor.JavaEEInterceptorBuilderFactory;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.managedbean.ManagedBeanManager;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

@Service
public class ManagedBeanManagerImpl
implements ManagedBeanManager,
PostConstruct,
EventListener {
    private static Logger _logger = LogDomains.getLogger(ManagedBeanManagerImpl.class, (String)"javax.enterprise.system.core");
    @Inject
    private ComponentEnvManager compEnvManager;
    @Inject
    private InvocationManager invocationMgr;
    @Inject
    private GlassfishNamingManager namingManager;
    @Inject
    private Habitat habitat;
    @Inject
    private Events events;
    @Inject
    private ProcessEnvironment processEnv;
    private ProcessEnvironment.ProcessType processType;

    public void postConstruct() {
        this.events.register((EventListener)this);
        this.processType = this.processEnv.getProcessType();
    }

    public void event(EventListener.Event event) {
        if (event.is(Deployment.APPLICATION_PREPARED)) {
            DeploymentContext dc = (DeploymentContext)Deployment.APPLICATION_PREPARED.getHook(event);
            this.loadManagedBeans(dc);
            this.registerAppLevelDependencies(dc);
        } else if (event.is(Deployment.APPLICATION_UNLOADED)) {
            ApplicationInfo info = (ApplicationInfo)Deployment.APPLICATION_UNLOADED.getHook(event);
            this.unloadManagedBeans(info);
            this.unregisterAppLevelDependencies(info);
        }
    }

    private void registerAppLevelDependencies(DeploymentContext dc) {
        Application app = (Application)dc.getModuleMetaData(Application.class);
        if (app == null) {
            return;
        }
        try {
            this.compEnvManager.bindToComponentNamespace((JndiNameEnvironment)app);
        }
        catch (Exception e) {
            throw new RuntimeException("Error binding app-level env dependencies " + app.getAppName(), e);
        }
    }

    private void unregisterAppLevelDependencies(ApplicationInfo appInfo) {
        Application app = (Application)appInfo.getMetaData(Application.class);
        if (app != null) {
            try {
                this.compEnvManager.unbindFromComponentNamespace((JndiNameEnvironment)app);
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "Exception unbinding app objects", e);
            }
        }
    }

    private void loadManagedBeans(DeploymentContext dc) {
        Application app = (Application)dc.getModuleMetaData(Application.class);
        if (app == null) {
            return;
        }
        for (BundleDescriptor bundle : app.getBundleDescriptors()) {
            if (!this.bundleEligible(bundle)) continue;
            for (ManagedBeanDescriptor next : bundle.getManagedBeans()) {
                try {
                    next.validate();
                    Set interceptorClasses = next.getAllInterceptorClasses();
                    Class<?> targetClass = bundle.getClassLoader().loadClass(next.getBeanClassName());
                    InterceptorInfo interceptorInfo = new InterceptorInfo();
                    interceptorInfo.setTargetClass(targetClass);
                    interceptorInfo.setInterceptorClassNames(interceptorClasses);
                    interceptorInfo.setPostConstructInterceptors(next.getCallbackInterceptors(LifecycleCallbackDescriptor.CallbackType.POST_CONSTRUCT));
                    interceptorInfo.setPreDestroyInterceptors(next.getCallbackInterceptors(LifecycleCallbackDescriptor.CallbackType.PRE_DESTROY));
                    if (next.hasAroundInvokeMethod()) {
                        interceptorInfo.setHasTargetClassAroundInvoke(true);
                    }
                    HashMap<Method, List> interceptorChains = new HashMap<Method, List>();
                    for (Method m : targetClass.getMethods()) {
                        interceptorChains.put(m, next.getAroundInvokeInterceptors(m));
                    }
                    interceptorInfo.setAroundInvokeInterceptorChains(interceptorChains);
                    JavaEEInterceptorBuilderFactory interceptorBuilderFactory = (JavaEEInterceptorBuilderFactory)this.habitat.getByContract(JavaEEInterceptorBuilderFactory.class);
                    JavaEEInterceptorBuilder builder = interceptorBuilderFactory.createBuilder(interceptorInfo);
                    next.setInterceptorBuilder((Object)builder);
                    this.compEnvManager.bindToComponentNamespace((JndiNameEnvironment)next);
                    String jndiName = next.getGlobalJndiName();
                    ManagedBeanNamingProxy namingProxy = new ManagedBeanNamingProxy(next, this.habitat);
                    this.namingManager.publishObject(jndiName, (Object)namingProxy, true);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error binding ManagedBean " + next.getBeanClassName() + " with name = " + next.getName(), e);
                }
            }
        }
    }

    public void registerRuntimeInterceptor(Object interceptorInstance, Object bundle) {
        for (ManagedBeanDescriptor next : ((BundleDescriptor)bundle).getManagedBeans()) {
            JavaEEInterceptorBuilder interceptorBuilder = (JavaEEInterceptorBuilder)next.getInterceptorBuilder();
            interceptorBuilder.addRuntimeInterceptor(interceptorInstance);
        }
    }

    private void unloadManagedBeans(ApplicationInfo appInfo) {
        Application app = (Application)appInfo.getMetaData(Application.class);
        if (app == null) {
            return;
        }
        for (BundleDescriptor bundle : app.getBundleDescriptors()) {
            if (!this.bundleEligible(bundle)) continue;
            for (ManagedBeanDescriptor next : bundle.getManagedBeans()) {
                for (Object instance : next.getBeanInstances()) {
                    InterceptorInvoker invoker = (InterceptorInvoker)next.getInterceptorInfoForBeanInstance(instance);
                    try {
                        invoker.invokePreDestroy();
                    }
                    catch (Exception e) {
                        _logger.log(Level.FINE, "Managed bean " + next.getBeanClassName() + " PreDestroy", e);
                    }
                }
                ComponentEnvManager compEnvManager = (ComponentEnvManager)this.habitat.getByContract(ComponentEnvManager.class);
                try {
                    compEnvManager.unbindFromComponentNamespace((JndiNameEnvironment)next);
                }
                catch (NamingException ne) {
                    _logger.log(Level.FINE, "Managed bean " + next.getBeanClassName() + " unbind", ne);
                }
                GlassfishNamingManager namingManager = (GlassfishNamingManager)this.habitat.getByContract(GlassfishNamingManager.class);
                String jndiName = next.getGlobalJndiName();
                try {
                    namingManager.unpublishObject(jndiName);
                }
                catch (NamingException ne) {
                    _logger.log(Level.FINE, "Error unpubishing managed bean " + next.getBeanClassName() + " with jndi name " + jndiName, ne);
                }
                next.clearBeanInstanceInfo();
            }
        }
    }

    private boolean bundleEligible(BundleDescriptor bundle) {
        boolean eligible = false;
        if (this.processType == ProcessEnvironment.ProcessType.Server) {
            eligible = bundle instanceof WebBundleDescriptor || bundle instanceof EjbBundleDescriptor;
        }
        return eligible;
    }

    public Object resolveInjectionPoint(Member member, Application app) throws NamingException {
        Annotation[] annotations;
        Object result = null;
        Field field = null;
        Method method = null;
        if (member instanceof Field) {
            field = (Field)member;
            annotations = field.getDeclaredAnnotations();
        } else if (member instanceof Method) {
            method = (Method)member;
            annotations = method.getDeclaredAnnotations();
        } else {
            throw new IllegalArgumentException("Member must be Field or Method");
        }
        Annotation envAnnotation = this.getEnvAnnotation(annotations);
        if (envAnnotation == null) {
            throw new IllegalArgumentException("No Java EE env dependency annotation found on " + member);
        }
        String envAnnotationName = null;
        try {
            Method m = envAnnotation.annotationType().getDeclaredMethod("name", new Class[0]);
            envAnnotationName = (String)m.invoke((Object)envAnnotation, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid annotation : must have name() attribute " + ((Object)envAnnotation).toString(), e);
        }
        String envDependencyName = envAnnotationName;
        Class<?> declaringClass = member.getDeclaringClass();
        if (envAnnotationName == null || envAnnotationName.equals("")) {
            envDependencyName = field != null ? declaringClass.getName() + "/" + field.getName() : declaringClass.getName() + "/" + this.getInjectionMethodPropertyName(method);
        }
        if (envAnnotationName.startsWith("java:global/")) {
            Context ic = this.namingManager.getInitialContext();
            result = ic.lookup(envAnnotationName);
        } else {
            BundleDescriptor matchingBundle = null;
            for (BundleDescriptor bundle : app.getBundleDescriptors()) {
                if (bundle instanceof EjbBundleDescriptor || bundle instanceof WebBundleDescriptor) {
                    JndiNameEnvironment jndiEnv = (JndiNameEnvironment)bundle;
                    for (InjectionCapable next : jndiEnv.getInjectableResourcesByClass(declaringClass.getName())) {
                        if (!next.getComponentEnvName().equals(envDependencyName)) continue;
                        matchingBundle = bundle;
                        break;
                    }
                }
                if (matchingBundle == null) continue;
                break;
            }
            if (matchingBundle == null) {
                throw new IllegalArgumentException("Cannot find matching env dependency for " + member + " in Application " + app.getAppName());
            }
            String componentId = this.compEnvManager.getComponentEnvId((JndiNameEnvironment)matchingBundle);
            String lookupName = envDependencyName.startsWith("java:") ? envDependencyName : "java:comp/env/" + envDependencyName;
            result = this.namingManager.lookup(componentId, lookupName);
        }
        return result;
    }

    private String getInjectionMethodPropertyName(Method method) {
        String methodName;
        String propertyName = methodName = method.getName();
        if (methodName.length() <= 3 || !methodName.startsWith("set")) {
            throw new IllegalArgumentException("Illegal env dependency setter name" + method.getName());
        }
        propertyName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
        return propertyName;
    }

    private Annotation getEnvAnnotation(Annotation[] annotations) {
        Annotation envAnnotation = null;
        for (Annotation next : annotations) {
            String className = next.annotationType().getName();
            if (!className.equals("javax.ejb.EJB") && !className.equals("javax.annotation.Resource") && !className.equals("javax.persistence.PersistenceContext") && !className.equals("javax.persistence.PersistenceUnit") && !className.equals("javax.xml.ws.WebServiceRef")) continue;
            envAnnotation = next;
            break;
        }
        return envAnnotation;
    }
}

