/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.monitoring;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.probe.provider.annotations.ProbeListener;
import org.glassfish.probe.provider.annotations.ProbeParam;
import org.glassfish.webservices.monitoring.Deployment109EndpointData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedObject
@Description(value="Stats for  Web Services deployed using 109 deployment")
public class Deployment109StatsProvider {
    private final ConcurrentHashMap<String, Deployment109EndpointData> endpoints = new ConcurrentHashMap();
    private final Logger logger = Logger.getLogger(Deployment109StatsProvider.class.getName());

    public Deployment109StatsProvider() {
        this.endpoints.put("name1", new Deployment109EndpointData("namespace1", "serviceName1", "portName1", "implClass1", "address1", "address1?wsdl"));
        this.endpoints.put("name2", new Deployment109EndpointData("namespace2", "serviceName2", "portName2", "implClass2", "address2", "address2?wsdl"));
    }

    @ProbeListener(value="glassfish:webservices:109:deploy")
    public void deploy(@ProbeParam(value="name") String name, @ProbeParam(value="address") String address, @ProbeParam(value="serviceName") String serviceName, @ProbeParam(value="portName") String portName, @ProbeParam(value="namespace") String namespace, @ProbeParam(value="implClass") String implClass, @ProbeParam(value="wsdl") String wsdl) {
        this.endpoints.put(name, new Deployment109EndpointData(namespace, serviceName, portName, implClass, address, wsdl));
    }

    @ProbeListener(value="glassfish:webservices:109:undeploy")
    public void undeploy(@ProbeParam(value="name") String appName) {
        this.endpoints.remove(appName);
    }

    @ManagedAttribute
    @Description(value="Endpoints with 109 deployment")
    public Collection<Deployment109EndpointData> getEndpoints() {
        return Collections.unmodifiableCollection(this.endpoints.values());
    }

    Deployment109EndpointData getEndpoint(String appName) {
        return this.endpoints.get(appName);
    }
}

