/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import com.sun.enterprise.config.serverbeans.Server;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import org.glassfish.admin.monitor.StatsProviderRegistry;
import org.glassfish.api.amx.AMXValues;
import org.glassfish.api.amx.MBeanListener;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.client.ProbeClientMediator;
import org.glassfish.flashlight.client.ProbeClientMethodHandle;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.datatree.factory.TreeNodeFactory;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObjectManager;
import org.glassfish.gmbal.ManagedObjectManagerFactory;
import org.glassfish.probe.provider.PluginPoint;
import org.glassfish.probe.provider.StatsProviderManagerDelegate;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.component.Singleton;

@Scoped(value=Singleton.class)
public class StatsProviderManagerDelegateImpl
extends MBeanListener.CallbackImpl
implements StatsProviderManagerDelegate {
    protected ProbeClientMediator pcm;
    ModuleMonitoringLevels config = null;
    private final MonitoringRuntimeDataRegistry mrdr;
    private final Domain domain;
    private final TreeNode serverNode;
    private static final ObjectName MONITORING_ROOT = AMXValues.monitoringRoot();
    static final ObjectName MONITORING_SERVER = AMXValues.serverMon((String)AMXValues.dasName());
    private boolean AMXReady = false;
    private StatsProviderRegistry statsProviderRegistry;

    StatsProviderManagerDelegateImpl(ProbeClientMediator pcm, MonitoringRuntimeDataRegistry mrdr, Domain domain, ModuleMonitoringLevels config) {
        this.pcm = pcm;
        this.mrdr = mrdr;
        this.domain = domain;
        this.config = config;
        this.serverNode = this.constructServerPP();
        this.statsProviderRegistry = new StatsProviderRegistry(mrdr);
    }

    public void register(String configElement, PluginPoint pp, String subTreePath, Object statsProvider) {
        TreeNode ppNode = this.getPluginPointNode(pp, this.serverNode);
        TreeNode parentNode = this.createSubTree(ppNode, subTreePath);
        ArrayList<String> childNodeNames = new ArrayList<String>();
        for (Method m : statsProvider.getClass().getDeclaredMethods()) {
            String methodNameLower;
            ManagedAttribute ma = m.getAnnotation(ManagedAttribute.class);
            if (ma == null) continue;
            String methodName = m.getName();
            String id = ma.id();
            if ((id == null || id.isEmpty()) && (methodNameLower = methodName.toLowerCase()).startsWith("get") && methodNameLower.length() > 3) {
                id = methodNameLower.substring(3);
            }
            TreeNode attrNode = TreeNodeFactory.createMethodInvoker(id, statsProvider, id, m);
            parentNode.addChild(attrNode);
            childNodeNames.add(attrNode.getName());
        }
        ArrayList<ProbeClientMethodHandle> handles = new ArrayList();
        try {
            handles = this.pcm.registerListener(statsProvider);
        }
        catch (Exception e) {
            Logger.getLogger(StatsProviderManagerDelegateImpl.class.getName()).log(Level.SEVERE, "flashlight registration failed", e);
        }
        if (this.getEnabledValue(configElement)) {
            if (this.AMXReady) {
                ManagedObjectManager mom = this.registerGmbal(statsProvider, subTreePath);
                this.statsProviderRegistry.registerStatsProvider(configElement, parentNode.getCompletePathName(), childNodeNames, handles, statsProvider, subTreePath, mom);
            } else {
                this.statsProviderRegistry.registerStatsProvider(configElement, parentNode.getCompletePathName(), childNodeNames, handles, statsProvider, subTreePath, null);
            }
            this.statsProviderRegistry.setConfigEnabled(configElement, true);
        } else {
            this.statsProviderRegistry.registerStatsProvider(configElement, parentNode.getCompletePathName(), childNodeNames, handles, statsProvider, subTreePath, null);
            this.statsProviderRegistry.setConfigEnabled(configElement, false);
            this.statsProviderRegistry.disableStatsProvider(configElement);
        }
    }

    public void unRegister(Object statsProvider) {
        try {
            this.statsProviderRegistry.unregisterStatsProvider(statsProvider);
        }
        catch (Exception ex) {
            Logger.getLogger(StatsProviderManagerDelegateImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void mbeanRegistered(ObjectName objectName, MBeanListener listener) {
        super.mbeanRegistered(objectName, listener);
        this.AMXReady = true;
        this.statsProviderRegistry.setAMXReady(true);
        for (StatsProviderRegistry.StatsProviderRegistryElement spre : this.statsProviderRegistry.getSpreList()) {
            if (!this.statsProviderRegistry.getConfigEnabled(spre.getConfigStr())) continue;
            ManagedObjectManager mom = this.registerGmbal(spre.getStatsProvider(), spre.getMBeanName());
            spre.setManagedObjectManager(mom);
        }
    }

    StatsProviderRegistry getStatsProviderRegistry() {
        return this.statsProviderRegistry;
    }

    private ManagedObjectManager registerGmbal(Object statsProvider, String mbeanName) {
        ManagedObjectManager mom = null;
        try {
            mom = ManagedObjectManagerFactory.createFederated(MONITORING_SERVER);
            if (mom != null) {
                mom.stripPackagePrefix();
                if (mbeanName != null && !mbeanName.isEmpty()) {
                    mom.createRoot(statsProvider, mbeanName);
                } else {
                    mom.createRoot(statsProvider);
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(StatsProviderManagerDelegateImpl.class.getName()).log(Level.SEVERE, "gmbal registration failed", e);
        }
        return mom;
    }

    private TreeNode createSubTreeNode(TreeNode parent, String child) {
        TreeNode childNode = parent.getNode(child);
        if (childNode == null) {
            childNode = TreeNodeFactory.createTreeNode(child, null, child);
            parent.addChild(childNode);
        }
        return childNode;
    }

    private TreeNode getPluginPointNode(PluginPoint pp, TreeNode serverNode) {
        if (pp.getName().equals(serverNode.getName())) {
            return serverNode;
        }
        return this.createSubTree(serverNode, pp.getPath());
    }

    private TreeNode createSubTree(TreeNode parent, String subTreePath) {
        StringTokenizer st = new StringTokenizer(subTreePath, "/");
        TreeNode parentNode = parent;
        while (st.hasMoreTokens()) {
            TreeNode subTreeNode;
            parentNode = subTreeNode = this.createSubTreeNode(parentNode, st.nextToken());
        }
        return parentNode;
    }

    private TreeNode constructServerPP() {
        TreeNode srvrNode = this.mrdr.get("server");
        if (srvrNode != null) {
            return srvrNode;
        }
        Server srvr = null;
        List ls = this.domain.getServers().getServer();
        for (Server sr : ls) {
            if (!"server".equals(sr.getName())) continue;
            srvr = sr;
            break;
        }
        srvrNode = TreeNodeFactory.createTreeNode("server", null, "server");
        this.mrdr.add("server", srvrNode);
        return srvrNode;
    }

    private boolean getEnabledValue(String configElement) {
        boolean enabled = false;
        if (this.config != null) {
            enabled = configElement.equals("connector-service") ? !this.config.getConnectorService().equals("OFF") : (configElement.equals("ejb-container") ? !this.config.getEjbContainer().equals("OFF") : (configElement.equals("http-service") ? !this.config.getHttpService().equals("OFF") : (configElement.equals("jdbc-connection-pool") ? !this.config.getJdbcConnectionPool().equals("OFF") : (configElement.equals("jms-service") ? !this.config.getJmsService().equals("OFF") : (configElement.equals("jvm") ? !this.config.getJvm().equals("OFF") : (configElement.equals("orb") ? !this.config.getOrb().equals("OFF") : (configElement.equals("thread-pool") ? !this.config.getThreadPool().equals("OFF") : (configElement.equals("transaction-service") ? !this.config.getTransactionService().equals("OFF") : (configElement.equals("web-container") ? !this.config.getWebContainer().equals("OFF") : true)))))))));
        }
        return enabled;
    }
}

