/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction.monitoring;

import org.glassfish.api.statistics.CountStatistic;
import org.glassfish.api.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.probe.provider.annotations.ProbeListener;
import org.glassfish.probe.provider.annotations.ProbeParam;

@ManagedObject
@Description(value="Transaction Service Statistics")
public class TransactionServiceStatsProvider {
    private CountStatisticImpl activeCount = new CountStatisticImpl("ActiveCount", "count", "Provides the number of transactions that are currently active.");
    private CountStatisticImpl committedCount = new CountStatisticImpl("CommittedCount", "count", "Provides the number of transactions that have been committed.");
    private CountStatisticImpl rolledbackCount = new CountStatisticImpl("RolledbackCount", "count", "Provides the number of transactions that have been rolled back.");
    private boolean isFrozen = false;

    @ManagedAttribute(id="activecount")
    @Description(value="Provides the number of transactions that are currently active.")
    public CountStatistic getActiveCount() {
        return this.activeCount.getStatistic();
    }

    @ManagedAttribute(id="committedcount")
    @Description(value="Provides the number of transactions that have been committed.")
    public CountStatistic getCommittedCount() {
        return this.committedCount.getStatistic();
    }

    @ManagedAttribute(id="rolledbackcount")
    @Description(value="Provides the number of transactions that have been rolled back.")
    public CountStatistic getRolledbackCount() {
        return this.rolledbackCount.getStatistic();
    }

    @ManagedAttribute(id="state")
    @Description(value="Indicates if the transaction service has been frozen.")
    public String getState() {
        return this.isFrozen ? "True" : "False";
    }

    @ProbeListener(value="glassfish:transaction:transaction-service:activated")
    public void transactionActivatedEvent() {
        this.activeCount.increment();
    }

    @ProbeListener(value="glassfish:transaction:transaction-service:deactivated")
    public void transactionDeactivatedEvent() {
        this.activeCount.decrement();
    }

    @ProbeListener(value="glassfish:transaction:transaction-service:committed")
    public void transactionCommittedEvent() {
        this.committedCount.increment();
        this.activeCount.decrement();
    }

    @ProbeListener(value="glassfish:transaction:transaction-service:rolledback")
    public void transactionRolledbackEvent() {
        this.rolledbackCount.increment();
        this.activeCount.decrement();
    }

    @ProbeListener(value="glassfish:transaction:transaction-service:freeze")
    public void freezeEvent(@ProbeParam(value="isFrozen") boolean b) {
        this.isFrozen = b;
    }
}

