/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.AdminObject;
import com.sun.enterprise.deployment.AuthMechanism;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.InboundResourceAdapter;
import com.sun.enterprise.deployment.LicenseDescriptor;
import com.sun.enterprise.deployment.MessageListener;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.deployment.SecurityPermission;
import com.sun.enterprise.deployment.runtime.connector.SunConnector;
import com.sun.enterprise.deployment.util.ConnectorVisitor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.DescriptorVisitor;
import com.sun.enterprise.deployment.util.XModuleType;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.zip.ZipEntry;

public class ConnectorDescriptor
extends BundleDescriptor {
    private String displayName = "";
    private String connectorDescription = "";
    private String largeIcon = "";
    private String smallIcon = "";
    private String vendorName = "";
    private String eisType = "";
    private String version = "";
    private String resourceAdapterVersion = "";
    private LicenseDescriptor licenseDescriptor = null;
    private Set configProperties = new OrderedSet();
    private Set authMechanisms = new OrderedSet();
    private Set securityPermissions = new OrderedSet();
    private String managedConnectionFactoryImpl = "";
    private int transactionSupport = 1;
    private boolean reauthenticationSupport = false;
    private String connectionInterface;
    private String connectionClass;
    private String connectionFactoryInterface;
    private String connectionFactoryClass;
    private String resourceAdapterClass = "";
    private ConnectorConfigProperty configProperty = null;
    private OutboundResourceAdapter outboundRA = null;
    private InboundResourceAdapter inboundRA = null;
    private Set adminObjects = new OrderedSet();
    private String inboundResourceAdapterClass = "";
    private Set messageListeners;
    private Set requiredWorkContexts = new OrderedSet();
    private boolean specVersionSet = false;
    private SunConnector sunConnector = null;

    public ConnectorDescriptor() {
        this.messageListeners = new OrderedSet();
    }

    public Set getRequiredWorkContexts() {
        return this.requiredWorkContexts;
    }

    public void addRequiredWorkContext(String workContextClass) {
        this.requiredWorkContexts.add(workContextClass);
    }

    public void removeRequiredWorkContext(String workContextClass) {
        this.requiredWorkContexts.remove(workContextClass);
    }

    public String getDefaultSpecVersion() {
        return "1.6";
    }

    public String getConnectionFactoryInterface() {
        throw new UnsupportedOperationException();
    }

    public void setConnectionFactoryInterface(String connectionFactoryInterface) {
        throw new UnsupportedOperationException();
    }

    public String getConnectionFactoryImpl() {
        throw new UnsupportedOperationException();
    }

    public void setConnectionFactoryImpl(String connectionFactoryImpl) {
        throw new UnsupportedOperationException();
    }

    public String getConnectionInterface() {
        throw new UnsupportedOperationException();
    }

    public void setConnectionInterface(String connectionInterface) {
        throw new UnsupportedOperationException();
    }

    public String getConnectionImpl() {
        throw new UnsupportedOperationException();
    }

    public void setConnectionImpl(String connectionImpl) {
        throw new UnsupportedOperationException();
    }

    public String getManagedConnectionFactoryImpl() {
        throw new UnsupportedOperationException();
    }

    public void setManagedConnectionFactoryImpl(String managedConnectionFactoryImpl) {
        throw new UnsupportedOperationException();
    }

    public boolean supportsReauthentication() {
        throw new UnsupportedOperationException();
    }

    public String getReauthenticationSupport() {
        throw new UnsupportedOperationException();
    }

    public void setReauthenticationSupport(boolean reauthenticationSupport) {
        throw new UnsupportedOperationException();
    }

    public void setReauthenticationSupport(String reauthSupport) {
        throw new UnsupportedOperationException();
    }

    public String getTransSupport() {
        throw new UnsupportedOperationException();
    }

    public int getTransactionSupport() {
        throw new UnsupportedOperationException();
    }

    public void setTransactionSupport(int transactionSupport) {
        throw new UnsupportedOperationException();
    }

    public void setTransactionSupport(String support) {
        throw new UnsupportedOperationException();
    }

    public Set getAuthMechanisms() {
        throw new UnsupportedOperationException();
    }

    public Set getServiceReferenceDescriptors() {
        return new OrderedSet();
    }

    public Set getSecurityPermissions() {
        if (this.securityPermissions == null) {
            this.securityPermissions = new OrderedSet();
        }
        return this.securityPermissions;
    }

    public boolean addAuthMechanism(AuthMechanism mech) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAuthMechanism(AuthMechanism mech) {
        throw new UnsupportedOperationException();
    }

    public boolean addAuthMechanism(int mech) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAuthMechanism(int mech) {
        throw new UnsupportedOperationException();
    }

    public void addSecurityPermission(SecurityPermission permission) {
        this.securityPermissions.add(permission);
    }

    public void removeSecurityPermission(SecurityPermission permission) {
        this.securityPermissions.remove(permission);
    }

    public String getResourceAdapterClass() {
        return this.resourceAdapterClass;
    }

    public void setResourceAdapterClass(String raClass) {
        this.resourceAdapterClass = raClass;
    }

    public Set getConfigProperties() {
        return this.configProperties;
    }

    public void addConfigProperty(ConnectorConfigProperty configProperty) {
        this.configProperties.add(configProperty);
    }

    public void removeConfigProperty(ConnectorConfigProperty configProperty) {
        this.configProperties.remove(configProperty);
    }

    public LicenseDescriptor getLicenseDescriptor() {
        return this.licenseDescriptor;
    }

    public void setLicenseDescriptor(LicenseDescriptor licenseDescriptor) {
        this.licenseDescriptor = licenseDescriptor;
    }

    public OutboundResourceAdapter getOutboundResourceAdapter() {
        return this.outboundRA;
    }

    public void setOutboundResourceAdapter(OutboundResourceAdapter outboundRA) {
        this.outboundRA = outboundRA;
    }

    public InboundResourceAdapter getInboundResourceAdapter() {
        return this.inboundRA;
    }

    public void setInboundResourceAdapter(InboundResourceAdapter inboundRA) {
        this.inboundRA = inboundRA;
    }

    public Set getAdminObjects() {
        return this.adminObjects;
    }

    public void addAdminObject(AdminObject admin) {
        boolean duplicate = false;
        if (duplicate) {
            throw new IllegalStateException("Cannot add duplicate admin object with interface [ " + admin.getAdminObjectInterface() + " ], class [ " + admin.getAdminObjectClass() + " ]");
        }
        this.adminObjects.add(admin);
    }

    private boolean hasAdminObject(String intfClass, String implClass, Set adminObjects) {
        boolean found = false;
        for (AdminObject ao : adminObjects) {
            if (!ao.getAdminObjectClass().equals(implClass) || !ao.getAdminObjectInterface().equals(intfClass)) continue;
            found = true;
            break;
        }
        return found;
    }

    public void removeAdminObject(AdminObject admin) {
        this.adminObjects.remove(admin);
    }

    public boolean hasAdminObjects() {
        return this.adminObjects.size() > 0;
    }

    public boolean getOutBoundDefined() {
        return this.outboundRA != null;
    }

    public boolean getInBoundDefined() {
        return this.inboundRA != null;
    }

    public String getConnectorDescription() {
        return this.connectorDescription;
    }

    public void setConnectorDescription(String description) {
        this.connectorDescription = description;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public String getEisType() {
        return this.eisType;
    }

    public void setEisType(String eisType) {
        this.eisType = eisType;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getResourceAdapterVersion() {
        return this.resourceAdapterVersion;
    }

    public void setResourceAdapterVersion(String resourceAdapterVersion) {
        this.resourceAdapterVersion = resourceAdapterVersion;
    }

    public String getDeployName() {
        return this.getModuleDescriptor().getArchiveUri();
    }

    public void visit(DescriptorVisitor aVisitor) {
        if (aVisitor instanceof ConnectorVisitor) {
            this.visit((ConnectorVisitor)((Object)aVisitor));
        } else {
            super.visit(aVisitor);
        }
    }

    public void visit(ConnectorVisitor aVisitor) {
        aVisitor.accept(this);
    }

    private static void printEntry(ZipEntry e) throws IOException {
        DOLUtils.getDefaultLogger().log(Level.FINE, e.getName());
    }

    public ConnectionDefDescriptor getConnectionDefinitionByCFType(String type) {
        return this.getConnectionDefinitionByCFType(type, true);
    }

    public ConnectionDefDescriptor getConnectionDefinitionByCFType(String type, boolean useDefault) {
        for (ConnectionDefDescriptor desc : this.outboundRA.getConnectionDefs()) {
            if (type == null) {
                if (useDefault && this.outboundRA.getConnectionDefs().size() == 1) {
                    return desc;
                }
                return null;
            }
            if (!desc.getConnectionFactoryIntf().equals(type)) continue;
            return desc;
        }
        return null;
    }

    public int getNumOfSupportedCFs() {
        return this.outboundRA.getConnectionDefs().size();
    }

    public AdminObject getAdminObject(String adminObjectInterface, String adminObjectClass) {
        for (AdminObject ao : this.getAdminObjects()) {
            if (!adminObjectInterface.equals(ao.getAdminObjectInterface()) || !adminObjectClass.equals(ao.getAdminObjectClass())) continue;
            return ao;
        }
        return null;
    }

    public AdminObject getAdminObjectByType(String type) {
        for (AdminObject ao : this.getAdminObjects()) {
            if (!type.equals(ao.getAdminObjectInterface())) continue;
            return ao;
        }
        return null;
    }

    public void print(StringBuffer toStringBuffer) {
        Iterator i;
        StringBuffer buf = toStringBuffer;
        super.print(buf);
        buf.append("\n displayName : " + super.getName());
        buf.append("\n connector_description : " + this.connectorDescription);
        buf.append("\n smallIcon : " + super.getSmallIconUri());
        buf.append("\n largeIcon : " + super.getLargeIconUri());
        buf.append("\n vendorName : " + this.vendorName);
        buf.append("\n eisType : " + this.eisType);
        buf.append("\n resourceadapter version : " + this.resourceAdapterVersion);
        if (this.getLicenseDescriptor() != null) {
            buf.append("\n license_description : " + this.getLicenseDescriptor().getDescription());
            buf.append("\n licenseRequired : " + this.getLicenseDescriptor().getLicenseRequiredValue());
        }
        buf.append("\n resourceAdapterClass : " + this.resourceAdapterClass);
        buf.append("\n resourceAdapterClass [" + this.resourceAdapterClass + "] config properties :");
        this.appendConfigProperties(this.configProperties, buf);
        if (this.outboundRA == null) {
            buf.append("\n Outbound Resource Adapter NOT available");
        } else {
            buf.append("\n Outbound Resource Adapter Info : ");
            buf.append("\n connection-definitions: ");
            i = this.outboundRA.getConnectionDefs().iterator();
            while (i.hasNext()) {
                buf.append("\n------------\n");
                ConnectionDefDescriptor conDef = (ConnectionDefDescriptor)i.next();
                buf.append("MCF : " + conDef.getManagedConnectionFactoryImpl() + ", ");
                buf.append("\n MCF [" + conDef.getManagedConnectionFactoryImpl() + "] config properties :");
                this.appendConfigProperties(conDef.getConfigProperties(), buf);
                buf.append("[CF Interface : " + conDef.getConnectionFactoryIntf() + "], ");
                buf.append("[CF Class : " + conDef.getConnectionFactoryImpl() + "], ");
                buf.append("[Connection Interface : " + conDef.getConnectionIntf() + "], ");
                buf.append("[Connection Class : " + conDef.getConnectionImpl() + "] ");
                buf.append("\n------------\n");
            }
            buf.append("\n transaction-support : " + this.outboundRA.getTransSupport());
            buf.append("\n authentication-mechanism: ");
            for (Descriptor conf : this.outboundRA.getAuthMechanisms()) {
                buf.append("\n------------\n");
                buf.append("[Type : " + ((AuthMechanism)conf).getAuthMechType() + "], ");
                buf.append("[Interface : " + ((AuthMechanism)conf).getCredentialInterface() + "]");
                buf.append("\n------------");
            }
            buf.append("\n reauthenticate-support : " + this.outboundRA.getReauthenticationSupport());
            buf.append("\n security-permission : ");
            for (Descriptor conf : this.getSecurityPermissions()) {
                buf.append("\n------------\n");
                buf.append("[persmission : " + ((SecurityPermission)conf).getPermission() + "], ");
                buf.append("[discription : " + conf.getDescription() + "]");
                buf.append("\n------------");
            }
        }
        if (this.inboundRA == null) {
            buf.append("\n Inbound Resource Adapter NOT available");
        } else {
            buf.append("\n Inbound Resource Adapter Info : ");
            buf.append("\n Message Listeners Info : ");
            i = this.inboundRA.getMessageListeners().iterator();
            while (i.hasNext()) {
                buf.append("\n------------\n");
                MessageListener l = (MessageListener)i.next();
                buf.append("[Type : " + l.getMessageListenerType() + "], ");
                buf.append("[AS Class : " + l.getActivationSpecClass() + "]");
                buf.append("\n------------ ");
            }
        }
        if (this.adminObjects.size() == 0) {
            buf.append("\n Admin Objects NOT available");
        } else {
            buf.append("\n Admin Objects Info : ");
            i = this.adminObjects.iterator();
            while (i.hasNext()) {
                buf.append("\n------------\n");
                AdminObject a = (AdminObject)i.next();
                buf.append("[Type : " + a.getAdminObjectInterface() + "], ");
                buf.append("[Class : " + a.getAdminObjectClass() + "]");
                this.appendConfigProperties(a.getConfigProperties(), buf);
                buf.append("\n------------ ");
            }
        }
    }

    private StringBuffer appendConfigProperties(Set props, StringBuffer buf) {
        buf.append("\n------------");
        for (ConnectorConfigProperty config : props) {
            buf.append("[Name : " + config.getName() + "], ");
            buf.append("[Value: " + config.getValue() + "], ");
            buf.append("[Type : " + config.getType() + "]");
            buf.append("[Confidential : " + config.isConfidential() + "]");
            buf.append("[Ignore : " + config.isIgnore() + "]");
            buf.append("[SupportsDynamicUpdates : " + config.isSupportsDynamicUpdates() + "]");
        }
        buf.append("\n------------");
        return buf;
    }

    public XModuleType getModuleType() {
        return XModuleType.RAR;
    }

    public MessageListener getSupportedMessageListener(String type) {
        if (this.inboundRA == null) {
            return null;
        }
        for (MessageListener l : this.inboundRA.getMessageListeners()) {
            if (!l.getMessageListenerType().equals(type)) continue;
            return l;
        }
        return null;
    }

    public boolean isMessageListenerSupported(String type) {
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() {
        return false;
    }

    public SunConnector getSunDescriptor() {
        return this.sunConnector;
    }

    public void setSunDescriptor(SunConnector connector) {
        this.sunConnector = connector;
    }

    public boolean isSpecVersionSet() {
        return this.specVersionSet;
    }
}

