/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.DataSourceDefinitionDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.DummyEjbDescriptor;
import com.sun.enterprise.deployment.EjbApplicationExceptionInfo;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.InjectionInfo;
import com.sun.enterprise.deployment.InterceptorBindingDescriptor;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MessageDestinationDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.NamedReferencePair;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import com.sun.enterprise.deployment.runtime.IASPersistenceManagerDescriptor;
import com.sun.enterprise.deployment.runtime.PersistenceManagerInUse;
import com.sun.enterprise.deployment.runtime.common.SecurityRoleMapping;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.types.EjbReferenceContainer;
import com.sun.enterprise.deployment.types.MessageDestinationReferenceContainer;
import com.sun.enterprise.deployment.types.MessageDestinationReferencer;
import com.sun.enterprise.deployment.types.ResourceEnvReferenceContainer;
import com.sun.enterprise.deployment.types.ResourceReferenceContainer;
import com.sun.enterprise.deployment.types.ServiceReferenceContainer;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.DescriptorVisitor;
import com.sun.enterprise.deployment.util.EjbBundleVisitor;
import com.sun.enterprise.deployment.util.EjbVisitor;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbBundleDescriptor
extends BundleDescriptor
implements WritableJndiNameEnvironment,
EjbReferenceContainer,
ResourceEnvReferenceContainer,
ResourceReferenceContainer,
ServiceReferenceContainer,
MessageDestinationReferenceContainer {
    public static final String SPEC_VERSION = "2.1";
    private long uniqueId;
    private Set<EjbDescriptor> ejbs = new HashSet<EjbDescriptor>();
    private Set<RelationshipDescriptor> relationships = new HashSet<RelationshipDescriptor>();
    private String relationshipsDescription;
    private String ejbClientJarUri;
    private Vector configured_pms = null;
    private PersistenceManagerInUse pm_inuse = null;
    private ResourceReferenceDescriptor cmpResourceReference;
    private Map<String, EjbApplicationExceptionInfo> applicationExceptions = new HashMap<String, EjbApplicationExceptionInfo>();
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbBundleDescriptor.class);
    static Logger _logger = DOLUtils.getDefaultLogger();
    private List<SecurityRoleMapping> roleMaps = new ArrayList<SecurityRoleMapping>();
    private Map<String, EjbInterceptor> interceptors = new HashMap<String, EjbInterceptor>();
    private LinkedList<InterceptorBindingDescriptor> interceptorBindings = new LinkedList();
    private Set<EnvironmentProperty> environmentProperties = new HashSet<EnvironmentProperty>();
    private Set<EjbReference> ejbReferences = new HashSet<EjbReference>();
    private Set<JmsDestinationReferenceDescriptor> jmsDestReferences = new HashSet<JmsDestinationReferenceDescriptor>();
    private Set<MessageDestinationReferenceDescriptor> messageDestReferences = new HashSet<MessageDestinationReferenceDescriptor>();
    private Set<ResourceReferenceDescriptor> resourceReferences = new HashSet<ResourceReferenceDescriptor>();
    private Set<ServiceReferenceDescriptor> serviceReferences = new HashSet<ServiceReferenceDescriptor>();
    private Set<EntityManagerFactoryReferenceDescriptor> entityManagerFactoryReferences = new HashSet<EntityManagerFactoryReferenceDescriptor>();
    private Set<EntityManagerReferenceDescriptor> entityManagerReferences = new HashSet<EntityManagerReferenceDescriptor>();
    private Set<DataSourceDefinitionDescriptor> datasourceDefinitionDescs = new HashSet<DataSourceDefinitionDescriptor>();

    public boolean isEJB20() {
        return !this.isEJB11();
    }

    public boolean isEJB11() {
        return this.getSpecVersion().startsWith("1");
    }

    @Override
    public String getDefaultSpecVersion() {
        return "3.1";
    }

    public String getEjbClientJarUri() {
        if (this.ejbClientJarUri == null) {
            this.ejbClientJarUri = "";
        }
        return this.ejbClientJarUri;
    }

    @Override
    public boolean isEmpty() {
        return this.ejbs.isEmpty();
    }

    public void setEjbClientJarUri(String ejbClientJarUri) {
        this.ejbClientJarUri = ejbClientJarUri;
    }

    public void addApplicationException(EjbApplicationExceptionInfo appExc) {
        this.applicationExceptions.put(appExc.getExceptionClassName(), appExc);
    }

    public Map<String, EjbApplicationExceptionInfo> getApplicationExceptions() {
        return new HashMap<String, EjbApplicationExceptionInfo>(this.applicationExceptions);
    }

    public Collection getNamedDescriptors() {
        Vector<EjbDescriptor> namedDescriptors = new Vector<EjbDescriptor>();
        for (EjbDescriptor ejbDescriptor : this.getEjbs()) {
            namedDescriptors.add(ejbDescriptor);
            namedDescriptors.addAll(super.getNamedDescriptorsFrom(ejbDescriptor));
        }
        return namedDescriptors;
    }

    public Vector<NamedReferencePair> getNamedReferencePairs() {
        Vector<NamedReferencePair> pairs = new Vector<NamedReferencePair>();
        for (EjbDescriptor ejbDescriptor : this.getEjbs()) {
            pairs.add(NamedReferencePair.createEjbPair(ejbDescriptor, ejbDescriptor));
            pairs.addAll(super.getNamedReferencePairsFrom(ejbDescriptor));
        }
        return pairs;
    }

    public Set<ResourceReferenceDescriptor> getEjbResourceReferenceDescriptors() {
        HashSet<ResourceReferenceDescriptor> resourceReferences = new HashSet<ResourceReferenceDescriptor>();
        for (EjbDescriptor ejbDescriptor : this.getEjbs()) {
            resourceReferences.addAll(ejbDescriptor.getResourceReferenceDescriptors());
        }
        return resourceReferences;
    }

    public boolean hasEjbReferences() {
        for (EjbDescriptor nextEjbDescriptor : this.getEjbs()) {
            if (nextEjbDescriptor.getEjbReferenceDescriptors().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Set<EjbDescriptor> getEjbs() {
        return this.ejbs;
    }

    public boolean hasEjbByName(String name) {
        for (Descriptor descriptor : this.getEjbs()) {
            if (!descriptor.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public EjbDescriptor getEjbByName(String name) {
        return this.getEjbByName(name, false);
    }

    public EjbDescriptor getEjbByName(String name, boolean isCreateDummy) {
        for (EjbDescriptor next : this.getEjbs()) {
            if (!next.getName().equals(name)) continue;
            return next;
        }
        if (!isCreateDummy) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionbeanbundle", "Referencing error: this bundle has no bean of name: {0}", new Object[]{name}));
        }
        _logger.log(Level.FINE, "enterprise.deployment_dummy_ejb_descriptor", new Object[]{name});
        DummyEjbDescriptor dummyEjbDesc = new DummyEjbDescriptor();
        dummyEjbDesc.setName(name);
        this.addEjb(dummyEjbDesc);
        return dummyEjbDesc;
    }

    public EjbDescriptor[] getEjbByClassName(String className) {
        ArrayList<EjbDescriptor> ejbList = new ArrayList<EjbDescriptor>();
        for (EjbDescriptor ejb : this.getEjbs()) {
            EjbDescriptor ejbDesc;
            if (!(ejb instanceof EjbDescriptor) || !className.equals((ejbDesc = ejb).getEjbClassName())) continue;
            ejbList.add(ejbDesc);
        }
        return ejbList.toArray(new EjbDescriptor[ejbList.size()]);
    }

    public EjbDescriptor[] getEjbBySEIName(String className) {
        ArrayList<EjbDescriptor> ejbList = new ArrayList<EjbDescriptor>();
        for (EjbDescriptor ejb : this.getEjbs()) {
            EjbDescriptor ejbDesc;
            if (!(ejb instanceof EjbDescriptor) || !className.equals((ejbDesc = ejb).getWebServiceEndpointInterfaceName())) continue;
            ejbList.add(ejbDesc);
        }
        return ejbList.toArray(new EjbDescriptor[ejbList.size()]);
    }

    public void addEjb(EjbDescriptor ejbDescriptor) {
        ejbDescriptor.setEjbBundleDescriptor(this);
        this.getEjbs().add(ejbDescriptor);
    }

    public void removeEjb(EjbDescriptor ejbDescriptor) {
        ejbDescriptor.setEjbBundleDescriptor(null);
        this.getEjbs().remove(ejbDescriptor);
    }

    void replaceEjb(EjbDescriptor oldEjbDescriptor, EjbDescriptor newEjbDescriptor) {
        oldEjbDescriptor.setEjbBundleDescriptor(null);
        this.getEjbs().remove(oldEjbDescriptor);
        newEjbDescriptor.setEjbBundleDescriptor(this);
        this.getEjbs().add(newEjbDescriptor);
    }

    public boolean containsCMPEntity() {
        Set<EjbDescriptor> ejbs = this.getEjbs();
        if (ejbs == null) {
            return false;
        }
        Iterator<EjbDescriptor> ejbsItr = ejbs.iterator();
        while (ejbsItr.hasNext()) {
            if (!(ejbsItr.next() instanceof EjbCMPEntityDescriptor)) continue;
            return true;
        }
        return false;
    }

    public void addInterceptor(EjbInterceptor interceptor) {
        EjbInterceptor ic = this.getInterceptorByClassName(interceptor.getInterceptorClassName());
        if (ic == null) {
            interceptor.setEjbBundleDescriptor(this);
            this.interceptors.put(interceptor.getInterceptorClassName(), interceptor);
        }
    }

    public EjbInterceptor getInterceptorByClassName(String className) {
        return this.interceptors.get(className);
    }

    public boolean hasInterceptors() {
        return this.interceptors.size() > 0;
    }

    public Set<EjbInterceptor> getInterceptors() {
        return new HashSet<EjbInterceptor>(this.interceptors.values());
    }

    public void prependInterceptorBinding(InterceptorBindingDescriptor binding) {
        this.interceptorBindings.addFirst(binding);
    }

    public void appendInterceptorBinding(InterceptorBindingDescriptor binding) {
        this.interceptorBindings.addLast(binding);
    }

    public List<InterceptorBindingDescriptor> getInterceptorBindings() {
        return new LinkedList<InterceptorBindingDescriptor>(this.interceptorBindings);
    }

    public void setInterceptorBindings(List<InterceptorBindingDescriptor> bindings) {
        this.interceptorBindings = new LinkedList();
        this.interceptorBindings.addAll(bindings);
    }

    public boolean areResourceReferencesValid() {
        for (EjbDescriptor ejbDescriptor : this.getEjbs()) {
            for (RoleReference roleReference : ejbDescriptor.getRoleReferences()) {
                Role referredRole = roleReference.getRole();
                if (referredRole.getName().equals("") || super.getRoles().contains((Object)referredRole)) continue;
                _logger.log(Level.FINE, localStrings.getLocalString("enterprise.deployment.badrolereference", "Warning: Bad role reference to {0}", new Object[]{referredRole}));
                _logger.log(Level.FINE, "Roles:  " + this.getRoles());
                return false;
            }
        }
        return true;
    }

    @Override
    public void removeRole(Role role) {
        if (super.getRoles().contains((Object)role)) {
            for (EjbDescriptor ejbDescriptor : this.getEjbs()) {
                ejbDescriptor.removeRole(role);
            }
            super.removeRole(role);
        }
    }

    public boolean hasPermissionedRoles() {
        for (EjbDescriptor nextEjbDescriptor : this.getEjbs()) {
            if (nextEjbDescriptor.getPermissionedMethodsByPermission().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasContainerTransactions() {
        for (EjbDescriptor nextEjbDescriptor : this.getEjbs()) {
            if (nextEjbDescriptor.getMethodContainerTransactions().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasAssemblyInformation() {
        return !this.getRoles().isEmpty() || this.hasPermissionedRoles() || this.hasContainerTransactions();
    }

    public void addRelationship(RelationshipDescriptor relDesc) {
        this.relationships.add(relDesc);
    }

    public void removeRelationship(RelationshipDescriptor relDesc) {
        this.relationships.remove(relDesc);
    }

    public String getRelationshipsDescription() {
        if (this.relationshipsDescription == null) {
            this.relationshipsDescription = "";
        }
        return this.relationshipsDescription;
    }

    public void setRelationshipsDescription(String relationshipsDescription) {
        this.relationshipsDescription = relationshipsDescription;
    }

    public Set<RelationshipDescriptor> getRelationships() {
        return this.relationships;
    }

    public boolean hasRelationships() {
        return this.relationships.size() > 0;
    }

    public boolean hasRelationship(RelationshipDescriptor rd) {
        return this.relationships.contains(rd);
    }

    public ResourceReferenceDescriptor getCMPResourceReference() {
        return this.cmpResourceReference;
    }

    public void setCMPResourceReference(ResourceReferenceDescriptor resourceReference) {
        this.cmpResourceReference = resourceReference;
    }

    public Descriptor getDescriptorByName(String name) {
        try {
            return this.getEjbByName(name);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    @Override
    public String getName() {
        if ("".equals(super.getName())) {
            super.setName("Ejb1");
        }
        return super.getName();
    }

    private void doMethodDescriptorConversions() throws Exception {
        for (EjbDescriptor ejbDescriptor : this.getEjbs()) {
            ejbDescriptor.doMethodDescriptorConversions();
        }
    }

    public void setUniqueId(long id) {
        this.uniqueId = id;
        EjbDescriptor[] descs = this.ejbs.toArray(new EjbDescriptor[this.ejbs.size()]);
        Arrays.sort(descs, new Comparator<EjbDescriptor>(){

            @Override
            public int compare(EjbDescriptor o1, EjbDescriptor o2) {
                return o2.getName().compareTo(o1.getName());
            }
        });
        for (int i = 0; i < descs.length; ++i) {
            descs[i].setUniqueId(id | (long)i);
        }
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public static int getIdFromEjbId(long ejbId) {
        long id = ejbId >> 32;
        return (int)id;
    }

    @Override
    public boolean hasWebServiceClients() {
        for (EjbDescriptor next : this.getEjbs()) {
            Set<ServiceReferenceDescriptor> serviceRefs = next.getServiceReferenceDescriptors();
            if (serviceRefs.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Set<ServiceReferenceDescriptor> getEjbServiceReferenceDescriptors() {
        OrderedSet<ServiceReferenceDescriptor> serviceRefs = new OrderedSet<ServiceReferenceDescriptor>();
        for (EjbDescriptor next : this.getEjbs()) {
            serviceRefs.addAll(next.getServiceReferenceDescriptors());
        }
        return serviceRefs;
    }

    @Override
    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("EjbBundleDescriptor\n");
        super.print(toStringBuffer);
        if (this.cmpResourceReference != null) {
            toStringBuffer.append("\ncmp resource ");
            this.cmpResourceReference.print(toStringBuffer);
        }
        toStringBuffer.append("\nclient JAR ").append(this.getEjbClientJarUri());
        for (EjbDescriptor o : this.getEjbs()) {
            toStringBuffer.append("\n------------\n");
            ((Descriptor)o).print(toStringBuffer);
            toStringBuffer.append("\n------------");
        }
    }

    @Override
    public void visit(DescriptorVisitor aVisitor) {
        if (aVisitor instanceof EjbBundleVisitor) {
            this.visit((EjbBundleVisitor)aVisitor);
        } else {
            super.visit(aVisitor);
        }
    }

    public void visit(EjbBundleVisitor aVisitor) {
        aVisitor.accept(this);
        EjbVisitor ejbVisitor = aVisitor.getEjbVisitor();
        if (ejbVisitor != null) {
            for (EjbDescriptor anEjb : this.getEjbs()) {
                anEjb.visit(ejbVisitor);
            }
        }
        if (this.hasRelationships()) {
            for (RelationshipDescriptor rd : this.getRelationships()) {
                aVisitor.accept(rd);
            }
        }
        for (WebService aWebService : this.getWebServices().getWebServices()) {
            aVisitor.accept(aWebService);
        }
        for (MessageDestinationDescriptor msgDestDescriptor : this.getMessageDestinations()) {
            aVisitor.accept(msgDestDescriptor);
        }
        for (InjectionCapable injectable : this.getInjectableResources(this)) {
            aVisitor.accept(injectable);
        }
        Set<EjbReference> ejbRefs = this.getEjbReferenceDescriptors();
        Iterator<InjectionCapable> itr = ejbRefs.iterator();
        while (itr.hasNext()) {
            aVisitor.accept(itr.next());
        }
        for (ResourceReferenceDescriptor resourceReferenceDescriptor : this.getResourceReferenceDescriptors()) {
            aVisitor.accept(resourceReferenceDescriptor);
        }
        for (JmsDestinationReferenceDescriptor jmsDestinationReferenceDescriptor : this.getJmsDestinationReferenceDescriptors()) {
            aVisitor.accept(jmsDestinationReferenceDescriptor);
        }
        Set<MessageDestinationReferenceDescriptor> msgDestRefs = this.getMessageDestinationReferenceDescriptors();
        Iterator<MessageDestinationReferenceDescriptor> iterator = msgDestRefs.iterator();
        while (iterator.hasNext()) {
            aVisitor.accept((MessageDestinationReferencer)iterator.next());
        }
        for (MessageDestinationDescriptor msgDestDescriptor : this.getMessageDestinations()) {
            aVisitor.accept(msgDestDescriptor);
        }
        Set<ServiceReferenceDescriptor> set = this.getServiceReferenceDescriptors();
        Iterator<ServiceReferenceDescriptor> itr3 = set.iterator();
        while (itr3.hasNext()) {
            aVisitor.accept(itr3.next());
        }
    }

    @Override
    public XModuleType getModuleType() {
        return XModuleType.EJB;
    }

    public void setPersistenceManagerInuse(String id, String ver) {
        this.pm_inuse = new PersistenceManagerInUse(id, ver);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("***IASEjbBundleDescriptor.setPersistenceManagerInUse done -#- ");
        }
    }

    public void setPersistenceManagerInUse(PersistenceManagerInUse inuse) {
        this.pm_inuse = inuse;
    }

    public PersistenceManagerInUse getPersistenceManagerInUse() {
        return this.pm_inuse;
    }

    public void addPersistenceManager(IASPersistenceManagerDescriptor pmDesc) {
        if (this.configured_pms == null) {
            this.configured_pms = new Vector();
        }
        this.configured_pms.add(pmDesc);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("***IASEjbBundleDescriptor.addPersistenceManager done -#- ");
        }
    }

    public IASPersistenceManagerDescriptor getPreferredPersistenceManager() {
        boolean debug = _logger.isLoggable(Level.FINE);
        if (this.configured_pms == null || this.configured_pms.size() == 0) {
            return null;
        }
        String pminuse_id = this.pm_inuse.get_pm_identifier().trim();
        String pminuse_ver = this.pm_inuse.get_pm_version().trim();
        if (debug) {
            _logger.fine("IASPersistenceManagerDescriptor.getPreferred - inid*" + pminuse_id.trim() + "*");
            _logger.fine("IASPersistenceManagerDescriptor.getPreferred - inver*" + pminuse_ver.trim() + "*");
        }
        int size = this.configured_pms.size();
        for (int i = 0; i < size; ++i) {
            IASPersistenceManagerDescriptor pmdesc = (IASPersistenceManagerDescriptor)this.configured_pms.elementAt(i);
            String pmdesc_id = pmdesc.getPersistenceManagerIdentifier();
            String pmdesc_ver = pmdesc.getPersistenceManagerVersion();
            if (debug) {
                _logger.fine("IASPersistenceManagerDescriptor.getPreferred - pmid*" + pmdesc_id.trim() + "*");
                _logger.fine("IASPersistenceManagerDescriptor.getPreferred - pmver*" + pmdesc_ver.trim() + "*");
            }
            if (!pmdesc_id.trim().equals(pminuse_id) || !pmdesc_ver.trim().equals(pminuse_ver)) continue;
            if (debug) {
                _logger.fine("***IASEjbBundleDescriptor.getPreferredPersistenceManager done -#- ");
            }
            return pmdesc;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.nomatchingpminusefound", "No PersistenceManager found that matches specified PersistenceManager in use."));
    }

    public Vector getPersistenceManagers() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("***IASEjbBundleDescriptor.getPersistenceManagers done -#- ");
        }
        return this.configured_pms;
    }

    public void addSecurityRoleMapping(SecurityRoleMapping roleMapping) {
        this.roleMaps.add(roleMapping);
    }

    public List<SecurityRoleMapping> getSecurityRoleMappings() {
        return this.roleMaps;
    }

    @Override
    public Collection<? extends PersistenceUnitDescriptor> findReferencedPUs() {
        HashSet<PersistenceUnitDescriptor> pus = new HashSet<PersistenceUnitDescriptor>();
        for (EjbDescriptor ejb : this.getEjbs()) {
            pus.addAll(EjbBundleDescriptor.findReferencedPUsViaPURefs(ejb));
            pus.addAll(EjbBundleDescriptor.findReferencedPUsViaPCRefs(ejb));
        }
        return pus;
    }

    @Override
    public Set<EjbReference> getEjbReferenceDescriptors() {
        return this.ejbReferences;
    }

    @Override
    public void addEjbReferenceDescriptor(EjbReference ejbReference) {
        this.ejbReferences.add(ejbReference);
        ejbReference.setReferringBundleDescriptor(this);
    }

    @Override
    public void removeEjbReferenceDescriptor(EjbReference ejbReference) {
        this.ejbReferences.remove(ejbReference);
    }

    public EjbReference getEjbReferenceByName(String name) {
        return (EjbReferenceDescriptor)this.getEjbReference(name);
    }

    @Override
    public EjbReference getEjbReference(String name) {
        for (EjbReference er : this.getEjbReferenceDescriptors()) {
            if (!er.getName().equals(name)) continue;
            return er;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoejbrefbyname", "This ejb jar [{0}] has no ejb reference by the name of [{1}] ", new Object[]{this.getName(), name}));
    }

    @Override
    public Set<ServiceReferenceDescriptor> getServiceReferenceDescriptors() {
        return this.serviceReferences;
    }

    @Override
    public void addServiceReferenceDescriptor(ServiceReferenceDescriptor serviceRef) {
        serviceRef.setBundleDescriptor(this);
        this.serviceReferences.add(serviceRef);
    }

    @Override
    public void removeServiceReferenceDescriptor(ServiceReferenceDescriptor serviceRef) {
        this.serviceReferences.remove(serviceRef);
    }

    @Override
    public ServiceReferenceDescriptor getServiceReferenceByName(String name) {
        for (ServiceReferenceDescriptor srd : this.getServiceReferenceDescriptors()) {
            if (!srd.getName().equals(name)) continue;
            return srd;
        }
        throw new IllegalArgumentException("No service ref of name " + name);
    }

    @Override
    public Set<MessageDestinationReferenceDescriptor> getMessageDestinationReferenceDescriptors() {
        return this.messageDestReferences;
    }

    @Override
    public void addMessageDestinationReferenceDescriptor(MessageDestinationReferenceDescriptor messageDestRef) {
        messageDestRef.setReferringBundleDescriptor(this);
        this.messageDestReferences.add(messageDestRef);
    }

    @Override
    public void removeMessageDestinationReferenceDescriptor(MessageDestinationReferenceDescriptor msgDestRef) {
        this.messageDestReferences.remove(msgDestRef);
    }

    @Override
    public MessageDestinationReferenceDescriptor getMessageDestinationReferenceByName(String name) {
        for (MessageDestinationReferenceDescriptor mdr : this.messageDestReferences) {
            if (!mdr.getName().equals(name)) continue;
            return mdr;
        }
        throw new IllegalArgumentException("No message destination ref of name " + name);
    }

    @Override
    public Set<JmsDestinationReferenceDescriptor> getJmsDestinationReferenceDescriptors() {
        return this.jmsDestReferences;
    }

    @Override
    public void addJmsDestinationReferenceDescriptor(JmsDestinationReferenceDescriptor jmsDestReference) {
        this.jmsDestReferences.add(jmsDestReference);
    }

    @Override
    public void removeJmsDestinationReferenceDescriptor(JmsDestinationReferenceDescriptor jmsDestReference) {
        this.jmsDestReferences.remove(jmsDestReference);
    }

    @Override
    public JmsDestinationReferenceDescriptor getJmsDestinationReferenceByName(String name) {
        for (JmsDestinationReferenceDescriptor jdr : this.getJmsDestinationReferenceDescriptors()) {
            if (!jdr.getName().equals(name)) continue;
            return jdr;
        }
        throw new IllegalArgumentException("No resource env ref of name " + name);
    }

    @Override
    public Set<ResourceReferenceDescriptor> getResourceReferenceDescriptors() {
        return this.resourceReferences;
    }

    @Override
    public void addResourceReferenceDescriptor(ResourceReferenceDescriptor resourceReference) {
        this.resourceReferences.add(resourceReference);
    }

    @Override
    public void removeResourceReferenceDescriptor(ResourceReferenceDescriptor resourceReference) {
        this.resourceReferences.remove(resourceReference);
    }

    @Override
    public ResourceReferenceDescriptor getResourceReferenceByName(String name) {
        for (ResourceReferenceDescriptor next : this.getResourceReferenceDescriptors()) {
            if (!next.getName().equals(name)) continue;
            return next;
        }
        throw new IllegalArgumentException("no resource ref of name " + name);
    }

    @Override
    public EnvironmentProperty getEnvironmentPropertyByName(String name) {
        for (EnvironmentProperty ev : this.getEnvironmentProperties()) {
            if (!ev.getName().equals(name)) continue;
            return ev;
        }
        throw new IllegalArgumentException("no env-entry of name " + name);
    }

    @Override
    public Set<EnvironmentProperty> getEnvironmentProperties() {
        return this.environmentProperties;
    }

    @Override
    public void addEnvironmentProperty(EnvironmentProperty environmentProperty) {
        this.environmentProperties.add(environmentProperty);
    }

    @Override
    public void removeEnvironmentProperty(EnvironmentProperty environmentProperty) {
        this.getEnvironmentProperties().remove(environmentProperty);
    }

    @Override
    public Set<EntityManagerFactoryReferenceDescriptor> getEntityManagerFactoryReferenceDescriptors() {
        return this.entityManagerFactoryReferences;
    }

    @Override
    public EntityManagerFactoryReferenceDescriptor getEntityManagerFactoryReferenceByName(String name) {
        for (EntityManagerFactoryReferenceDescriptor next : this.getEntityManagerFactoryReferenceDescriptors()) {
            if (!next.getName().equals(name)) continue;
            return next;
        }
        throw new IllegalArgumentException("No entity manager factory reference of name " + name);
    }

    @Override
    public void addEntityManagerFactoryReferenceDescriptor(EntityManagerFactoryReferenceDescriptor reference) {
        reference.setReferringBundleDescriptor(this);
        this.entityManagerFactoryReferences.add(reference);
    }

    @Override
    public Set<EntityManagerReferenceDescriptor> getEntityManagerReferenceDescriptors() {
        return this.entityManagerReferences;
    }

    @Override
    public EntityManagerReferenceDescriptor getEntityManagerReferenceByName(String name) {
        for (EntityManagerReferenceDescriptor next : this.getEntityManagerReferenceDescriptors()) {
            if (!next.getName().equals(name)) continue;
            return next;
        }
        throw new IllegalArgumentException("No entity manager reference of name " + name);
    }

    @Override
    public void addEntityManagerReferenceDescriptor(EntityManagerReferenceDescriptor reference) {
        reference.setReferringBundleDescriptor(this);
        this.getEntityManagerReferenceDescriptors().add(reference);
    }

    @Override
    public Set<DataSourceDefinitionDescriptor> getDataSourceDefinitionDescriptors() {
        return this.datasourceDefinitionDescs;
    }

    @Override
    public void addDataSourceDefinitionDescriptor(DataSourceDefinitionDescriptor reference) {
        for (DataSourceDefinitionDescriptor desc : this.getDataSourceDefinitionDescriptors()) {
            if (!desc.getName().equals(reference.getName())) continue;
            throw new IllegalStateException(localStrings.getLocalString("exceptionapplicationduplicatedatasourcedefinition", "This application [{0}] cannot have datasource definitions of same name : [{1}]", new Object[]{this.getName(), reference.getName()}));
        }
        this.getDataSourceDefinitionDescriptors().add(reference);
    }

    @Override
    public void removeDataSourceDefinitionDescriptor(DataSourceDefinitionDescriptor reference) {
        this.getDataSourceDefinitionDescriptors().remove(reference);
    }

    @Override
    public List<InjectionCapable> getInjectableResourcesByClass(String className) {
        return this.getInjectableResourcesByClass(className, this);
    }

    @Override
    public InjectionInfo getInjectionInfoByClass(String className) {
        return this.getInjectionInfoByClass(className, this);
    }

    @Override
    public Set<LifecycleCallbackDescriptor> getPostConstructDescriptors() {
        return new HashSet<LifecycleCallbackDescriptor>();
    }

    @Override
    public void addPostConstructDescriptor(LifecycleCallbackDescriptor postConstructDesc) {
    }

    @Override
    public LifecycleCallbackDescriptor getPostConstructDescriptorByClass(String className) {
        return null;
    }

    @Override
    public Set<LifecycleCallbackDescriptor> getPreDestroyDescriptors() {
        return new HashSet<LifecycleCallbackDescriptor>();
    }

    @Override
    public void addPreDestroyDescriptor(LifecycleCallbackDescriptor preDestroyDesc) {
    }

    @Override
    public LifecycleCallbackDescriptor getPreDestroyDescriptorByClass(String className) {
        return null;
    }
}

